/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    Model parentModel;
    IncludeModel includeModel;
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext seic, String tagName, Attributes attributes) throws ActionException {
        String optionalStr = attributes.getValue(OPTIONAL_ATTR);
        this.includeModel = new IncludeModel();
        this.includeModel.setOptional(optionalStr);
        this.fillInIncludeModelAttributes(this.includeModel, tagName, attributes);
        if (!seic.isModelStackEmpty()) {
            this.parentModel = seic.peekModel();
        }
        int lineNumber = IncludeAction.getLineNumber(seic);
        this.includeModel.setLineNumber(lineNumber);
        seic.pushModel(this.includeModel);
    }

    private void fillInIncludeModelAttributes(IncludeModel includeModel, String tagName, Attributes attributes) {
        this.includeModel.setTag(tagName);
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        this.includeModel.setFile(fileAttribute);
        this.includeModel.setUrl(urlAttribute);
        this.includeModel.setResource(resourceAttribute);
    }

    @Override
    public void end(SaxEventInterpretationContext seic, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model m4 = seic.peekModel();
        if (m4 != this.includeModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.includeModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.includeModel);
            seic.popModel();
        }
    }
}

