/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.deployer;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.esb.job.converter.Converter;

public class JobDeploymentListener
implements ArtifactUrlTransformer {
    private Converter converter;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobDeploymentListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        if (!artifact.getPath().endsWith(".zip")) {
            LOGGER.debug("Artifact {} is not a zip.", (Object)artifact.getName());
            return false;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(artifact);
            if (JobDeploymentListener.findInZip(zip, "systemRoutines") && JobDeploymentListener.findInZip(zip, "userRoutines") && JobDeploymentListener.findInZip(zip, "Default.properties")) {
                LOGGER.debug("Talend job zip detected {}", (Object)artifact.getName());
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public URL transform(URL artifact) throws Exception {
        File jobZip = new File(artifact.toURI());
        this.converter.convertToBundle(jobZip, true);
        return null;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    protected static boolean findInZip(ZipFile zip, String name) {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().contains(name)) continue;
            return true;
        }
        return false;
    }
}

