/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sts.config;

import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

public class StsConfigurator {
    private String useMessageLogging = null;
    private Bus bus;

    public StsConfigurator(Bus bus) {
        this.bus = bus;
    }

    public void init() {
        this.setMessageLogging(this.useMessageLogging != null && this.useMessageLogging.equalsIgnoreCase("true"));
    }

    public void setUseMessageLogging(String useMessageLogging) {
        this.useMessageLogging = useMessageLogging;
    }

    private void setMessageLogging(boolean logMessages) {
        this.setMessageLogging(logMessages, this.bus);
    }

    private void setMessageLogging(boolean logMessages, Bus bus) {
        if (logMessages) {
            if (!this.hasLoggingFeature(bus)) {
                this.addMessageLogging(bus);
            }
        } else if (this.hasLoggingFeature(bus)) {
            this.removeMessageLogging(bus);
        }
    }

    private boolean hasLoggingFeature(Bus bus) {
        Collection features = bus.getFeatures();
        for (Feature feature : features) {
            if (!(feature instanceof LoggingFeature)) continue;
            return true;
        }
        return false;
    }

    private void addMessageLogging(Bus bus) {
        LoggingFeature logFeature = new LoggingFeature();
        logFeature.initialize(bus);
        bus.getFeatures().add(logFeature);
    }

    private void removeMessageLogging(Bus bus) {
        Collection features = bus.getFeatures();
        Feature logFeature = null;
        Interceptor inLogInterceptor = null;
        Interceptor outLogInterceptor = null;
        for (Feature feature : features) {
            if (!(feature instanceof LoggingFeature)) continue;
            logFeature = feature;
            break;
        }
        if (logFeature != null) {
            features.remove(logFeature);
        }
        for (Interceptor interceptor : bus.getInInterceptors()) {
            if (!(interceptor instanceof LoggingInInterceptor)) continue;
            inLogInterceptor = interceptor;
            break;
        }
        for (Interceptor interceptor : bus.getOutInterceptors()) {
            if (!(interceptor instanceof LoggingOutInterceptor)) continue;
            outLogInterceptor = interceptor;
            break;
        }
        if (inLogInterceptor != null) {
            bus.getInInterceptors().remove(inLogInterceptor);
        }
        if (outLogInterceptor != null) {
            bus.getOutInterceptors().remove(outLogInterceptor);
        }
    }
}

