/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.ChunkUtil;
import amazon.emr.metrics.Credentials;
import amazon.emr.metrics.MetricsConfig;
import amazon.emr.metrics.MetricsSaver;
import amazon.emr.metrics.MetricsServer;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.S3Path;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdhocTest {
    static final Logger logger = LoggerFactory.getLogger(AdhocTest.class);
    static Random random = new Random();
    static final String SAMPLE_URL = "http://10.196.13.149:9103/mapOutput?job=job_201307022029_0001&map=attempt_201307022029_0001_m_000001_0&reduce=1";
    static final String SAMPLE_S3_OBJ = "s3://aws157-logs-prod/compressed/j-1000A5C9OIXG6.tar.gz";
    static final int READ_BUF_SIZE = 8192;
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    AdhocTest() {
    }

    static void usageAndExit() {
        System.out.println("Amazon EMR Metric Server Test Utility Usage Examples:");
        System.out.println("  1. metrics-server --test read_write_hbase");
        System.out.println("     Write records to a test hbase table and read them");
        System.out.println("  2. metrics-server --test metrics_saver_stress");
        System.out.println("     Save 10M metics records");
        System.out.println("  3. metrics-server --test read_s3 s3://netflix-data-benchmark/data/streaming_client_log/dateint=20130601/hour=0/batchid=merged_1/");
        System.out.println("     Read (download) all S3 objects under the path and measure performance");
        System.out.println("  4. metrics-server --test write_s3 s3://danzhi-test/testmpuld/ 100 10 1024");
        System.out.println("     Write objects with specificed number of blocks (8GB per block)");
        System.out.println("  5. metrics-server --test create_log_files");
        System.out.println("     Generate log file under /mnt/var/log/hadoop/steps/");
        System.out.println("  6. metrics-server --test url_connection http://10.196.13.149:9103/mapOutput?job=job_201307022029_0001&map=attempt_201307022029_0001_m_000001_0&reduce=1");
        System.out.println("     Test URL connection");
        System.out.println("  7. metrics-server --test read_s3_stream s3://aws157-logs-prod/compressed/j-1000A5C9OIXG6.tar.gz");
        System.out.println("     Read S3 input stream");
        System.out.println("  8. metrics-server --test read_s3_object s3://aws157-logs-prod/compressed/j-1000A5C9OIXG6.tar.gz 300000000");
        System.out.println("     Read S3 object with offset");
        System.out.println("");
        System.exit(0);
    }

    public static void run(String[] args) throws Exception {
        if (args.length < 2 || !args[0].equals("-test") && !args[0].equals("--test")) {
            AdhocTest.usageAndExit();
        }
        logger.info("AdhocTest invoked with {} args", (Object)args.length);
        for (String a : args) {
            logger.info("Arg {}", (Object)a);
        }
        String cmd = args[1];
        if (cmd.equals("read_write_hbase")) {
            AdhocTest.redWriteHbase();
        } else if (cmd.equals("metrics_saver_stress")) {
            AdhocTest.metricsSaverStress();
        } else if (cmd.equals("write_s3")) {
            String path = args[2];
            for (int i = 3; i < args.length; ++i) {
                int numBlocks = Integer.parseInt(args[i]);
                if (numBlocks < 0) continue;
                String key = String.format("%stest_%dMB", path, numBlocks * 8);
                AdhocTest.createS3Object(key, numBlocks);
            }
        } else {
            if (cmd.equals("read_s3")) {
                String path = args[2];
                while (true) {
                    try {
                        while (true) {
                            AdhocTest.readS3(path);
                            logger.info("Sleep 180 seconds");
                            Thread.sleep(180000L);
                        }
                    }
                    catch (Exception ex) {
                        logger.info("Exception: ", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
            if (cmd.equals("create_log_files")) {
                AdhocTest.testCreateLogFiles();
            } else if (cmd.equals("url_connection")) {
                AdhocTest.urlConnection(args.length > 2 ? args[2] : SAMPLE_URL);
            } else if (cmd.equals("read_s3_stream")) {
                String s3path = args.length > 2 ? args[2] : SAMPLE_S3_OBJ;
                Long offset = args.length > 3 ? Long.parseLong(args[3]) : 0L;
                AdhocTest.readS3Stream(s3path, offset);
            } else if (cmd.equals("read_s3_object")) {
                String s3path = args.length > 2 ? args[2] : SAMPLE_S3_OBJ;
                Long offset = args.length > 3 ? Long.parseLong(args[3]) : 0L;
                AdhocTest.readS3Object(s3path, offset);
            } else {
                AdhocTest.usageAndExit();
            }
        }
        logger.info("AdhocTest completed");
    }

    public static void redWriteHbase() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HBaseAdmin hbase = new HBaseAdmin(conf);
        String tableName = "mytesttable";
        String family1 = "family1";
        String family2 = "family2";
        if (!hbase.tableExists("mytesttable")) {
            HTableDescriptor desc = new HTableDescriptor("mytesttable");
            HColumnDescriptor meta = new HColumnDescriptor("family1".getBytes());
            HColumnDescriptor prefix = new HColumnDescriptor("family2".getBytes());
            desc.addFamily(meta);
            desc.addFamily(prefix);
            hbase.createTable(desc);
            logger.info("Created table {}", (Object)"mytesttable");
        } else {
            logger.info("Found table {}", (Object)"mytesttable");
        }
        HTable table = new HTable(conf, "mytesttable");
        if (MetricsServer.consoleReadYesNo("Insert records (Y/N)")) {
            String qualifier = "qualifier1";
            for (int i = 0; i < 10000; ++i) {
                String rowkey = "rowkey" + (random.nextInt(9000000) + 1000000);
                String value = "HelloWorld" + (random.nextInt(9000000) + 1000000);
                Put put = new Put(Bytes.toBytes((String)rowkey));
                put.add(Bytes.toBytes((String)"family1"), Bytes.toBytes((String)"qualifier1"), Bytes.toBytes((String)value));
                table.put(put);
                if (i % 1000 != 0) continue;
                logger.info("{} insert recored {}", (Object)i, (Object)rowkey);
            }
        }
        Scan s = new Scan();
        ResultScanner ss = table.getScanner(s);
        int count = 0;
        for (Result r : ss) {
            for (KeyValue kv : r.raw()) {
                if (++count % 1000 != 0) continue;
                String m = String.format("  %6d %s %s %s %s %s", count, new String(kv.getRow()), new String(kv.getFamily()), new String(kv.getQualifier()), kv.getTimestamp(), new String(kv.getValue()));
                logger.info("{}", (Object)m);
            }
        }
        ss.close();
        table.close();
        hbase.close();
    }

    public static void metricsSaverStress() throws RuntimeException, IOException, InterruptedException {
        MetricsConfig config = new MetricsConfig(true);
        MetricsConfig.disableMetricSaver = false;
        MetricsConfig.systemMetricsPublishPeriodSec = 0;
        if (!MetricsUtil.fileExists(config.enableMetricsFile)) {
            System.out.format("Create %s\n", config.enableMetricsFile);
            MetricsUtil.ensureDir(config.rootDir);
            MetricsUtil.writeStringToFile("1", config.enableMetricsFile);
        } else {
            System.out.format("Detected %s\n", config.enableMetricsFile);
        }
        int N = 10000000;
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        logger.info("Add {} metrics values ", (Object)N);
        for (int i = 0; i < N; ++i) {
            MetricsSaver.addValue("TestPinterest", i);
            if (i % 200000 != 0) continue;
            MemoryUsage memoryUsage = memoryBean.getHeapMemoryUsage();
            String message = String.format("  added %8d metrics values; HeapMemoryUsage %10d", i, memoryUsage.getUsed());
            logger.info("{}", (Object)message);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        MetricsSaver.addValue("TestPinterest", N);
        logger.info("Will do GC collection in 100 seconds");
        Thread.sleep(100000L);
        logger.info("Force Garbage Collection");
        System.gc();
        logger.info("Wait forever until termination");
        Thread.sleep(100000000L);
    }

    static void readS3(String path) throws Exception {
        logger.info("readS3 {}", (Object)path);
        S3Path p = S3Path.parse(path);
        Credentials cred = Credentials.newInstance();
        ClientConfiguration configuration = new ClientConfiguration();
        logger.info("Configure AmazonS3Client to use HTTPS");
        configuration.setProtocol(Protocol.HTTPS);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentials)cred, configuration);
        ObjectListing objectListing = s3.listObjects(p.s3bucket, p.s3key);
        ArrayList<S3ObjectSummary> objects = new ArrayList<S3ObjectSummary>();
        StringBuilder sb = new StringBuilder();
        long totalSize = 0L;
        for (S3ObjectSummary obj : objectListing.getObjectSummaries()) {
            if (obj.getKey().endsWith("$folder$")) continue;
            String key = obj.getKey();
            objects.add(obj);
            sb.append(String.format("\n  %10d %s", obj.getSize(), key.substring(p.s3key.length())));
            totalSize += obj.getSize();
        }
        logger.info("Found {} objects total size {} under {}:{}", new Object[]{objects.size(), totalSize, path, sb.toString()});
        String DST_ROOT = "/mnt/var/tmp";
        File r = new File(DST_ROOT);
        if (!r.exists()) {
            r.mkdir();
            logger.info("Create {}", (Object)DST_ROOT);
        }
        long totalReadBytes = 0L;
        int totalSeconds = 0;
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        for (S3ObjectSummary obj : objects) {
            String s3Path = "s3://" + obj.getBucketName() + "/" + obj.getKey();
            String dstFile = DST_ROOT + "/" + obj.getKey();
            MetricsUtil.ensureDir(dstFile);
            if (MetricsUtil.fileExists(dstFile)) {
                MetricsUtil.deleteFile(dstFile);
            }
            stopWatch.reset();
            ChunkUtil.download(s3, s3Path, dstFile);
            MetricsUtil.deleteFile(dstFile);
            totalSeconds = (int)((long)totalSeconds + stopWatch.elapsedSeconds());
            logger.info(String.format("Read %10d in %3d seconds total:%12d %6.3f MB/s %s", obj.getSize(), stopWatch.elapsedSeconds(), totalReadBytes += obj.getSize(), AdhocTest.getThroughputMBs(totalReadBytes, totalSeconds), s3Path.substring(p.s3key.length())));
        }
        if (totalSeconds > 0) {
            String m = String.format("Completed reading %d bytes in %4d seconds throughput %6.3f MB/s", totalReadBytes, totalSeconds, AdhocTest.getThroughputMBs(totalReadBytes, totalSeconds));
            logger.info(m);
            String hfile = "/home/hadoop/reads3.txt";
            if (!new File("/home/hadoop/reads3.txt").exists()) {
                MetricsUtil.writeStringToFile(" ", "/home/hadoop/reads3.txt");
            }
            String history = MetricsUtil.readFileAsString("/home/hadoop/reads3.txt");
            history = history + m + "\n";
            MetricsUtil.writeStringToFile(history, "/home/hadoop/reads3.txt");
        }
    }

    static double getThroughputMBs(long totalReadBytes, int totalSeconds) {
        long MB = 0x100000L;
        double rate = totalReadBytes;
        rate /= totalSeconds == 0 ? 1.0 : (double)totalSeconds;
        return rate /= (double)MB;
    }

    static void createS3Object(String path, int blocks) throws Exception {
        int BLOCK_SIZE = 0x800000;
        Configuration configuration = new Configuration();
        FileSystem fs = FileSystem.get((URI)new URI(path), (Configuration)configuration);
        FSDataOutputStream output = fs.create(new Path(path));
        long total = 0x800000L * (long)blocks;
        logger.info("Write {} bytes to local {}", (Object)total, (Object)path);
        byte[] data = new byte[0x800000];
        Arrays.fill(data, (byte)68);
        for (int i = 0; i < blocks; ++i) {
            logger.info("Write block {} {} bytes", (Object)i, (Object)0x800000);
            output.write(data);
        }
        logger.info("Close FSDataOutputStream for {}", (Object)path);
        output.close();
        logger.info("Closed FSDataOutputStream for {}", (Object)path);
    }

    public static void testCreateLogFiles() throws IOException, URISyntaxException {
        int index = random.nextInt(9000) + 1000;
        File file = new File("/mnt/var/log/hadoop/steps/test-" + index + ".log");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        long numLines = 0x40000000L;
        int i = 0;
        while ((long)i < numLines) {
            bw.write("H" + i + "\n");
            if (i % 10000000 == 0) {
                logger.info("  {} lines", (Object)i);
            }
            ++i;
        }
        bw.close();
        logger.info("created file {}", (Object)file.getPath());
    }

    public static void testCreateS3NativeFile(String[] args) throws IOException, URISyntaxException {
        int index = random.nextInt(9000) + 1000;
        String path = "s3://aws157-user-prod/test/test-" + index;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)new URI(path), (Configuration)conf);
        IntWritable key = new IntWritable();
        BytesWritable value = new BytesWritable();
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)new Path(path), key.getClass(), value.getClass());
        byte[] imageData = new byte[1024];
        for (int i = 0; i < 262144; ++i) {
            if (i % 4096 == 0) {
                logger.info("write block {}", (Object)i);
            }
            key.set(i);
            value.set(imageData, 0, imageData.length);
            writer.append((Writable)key, (Writable)value);
        }
        IOUtils.closeStream((Closeable)writer);
    }

    public static void testS3NativeSeek(String[] args) throws Exception {
        String path = "s3://danzhi-test/testbillions/test.0.tsv.gz";
        int length = 85168128;
        int numSeeks = 85168;
        Configuration configuration = new Configuration();
        FileSystem fs = FileSystem.get((URI)new URI("s3://danzhi-test/testbillions/test.0.tsv.gz"), (Configuration)configuration);
        FSDataInputStream input = fs.open(new Path("s3://danzhi-test/testbillions/test.0.tsv.gz"), 131072);
        byte[] buf = new byte[0x100000];
        for (int i = 0; i < 85168; ++i) {
            long offset = i * 1000;
            if (i % 100 == 0) {
                logger.info("{} seek to {}", (Object)i, (Object)offset);
            }
            input.seek(offset);
            input.read(buf, 0, 1024);
        }
        logger.info("done");
    }

    public static void testFileDelete(String[] args) throws Exception {
        String outputFileName = "file:///mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz";
        logger.info("{}", (Object)"file:///mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz");
        Configuration conf = new Configuration();
        FileSystem outputFs = null;
        outputFs = FileSystem.get((URI)URI.create("file:///mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz"), (Configuration)conf);
        try {
            outputFs.delete(new Path("file:///mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz"), false);
        }
        catch (Exception ex) {
            logger.info("delete exception ", (Throwable)ex);
        }
        String outputFileName2 = "/mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz";
        logger.info("{}", (Object)"/mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz");
        outputFs.delete(new Path("/mnt/var/log/tmp/13440559e6b56245be46379705b38b37b254a8ihi_20971064_seclog-56002.nrt8.amazon.com-authpriv.2012-01-02-00:00.UTC.gz"), false);
    }

    public static void testS3GetObjectMetadataStress(String s3path) throws RuntimeException, IOException {
        S3Path s3p = S3Path.parse(s3path);
        Credentials cred = Credentials.newInstance();
        ClientConfiguration configuration = new ClientConfiguration();
        logger.info("Configure AmazonS3Client to use HTTPS");
        configuration.setProtocol(Protocol.HTTPS);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentials)cred, configuration);
        for (int i = 0; i < 50000; ++i) {
            ObjectMetadata meta = s3.getObjectMetadata(s3p.s3bucket, s3p.s3key);
            if (i % 1000 != 0) continue;
            logger.info("  {} length:{}", (Object)i, (Object)meta.getContentLength());
        }
    }

    public static void analyzeDatanodeLog(String logfile) throws Exception {
        String line;
        FileInputStream fstream = new FileInputStream(logfile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        HashMap<String, Long> map = new HashMap<String, Long>();
        while ((line = br.readLine()) != null) {
            int ds = line.indexOf("dest: /");
            int bs = line.indexOf("bytes: ");
            if (ds < 0 || bs < 0) continue;
            int de = line.indexOf(":", ds + 6);
            int be = line.indexOf(",", bs);
            if (de < 0 || be < 0) continue;
            String dest = line.substring(ds + 7, de);
            int bytes = Integer.parseInt(line.substring(bs + 7, be));
            long value = map.containsKey(dest) ? (Long)map.get(dest) + (long)bytes : (long)bytes;
            map.put(dest, value);
        }
        in.close();
        long total = 0L;
        for (String key : map.keySet()) {
            logger.info(String.format("%-20s %d", key, map.get(key)));
            total += ((Long)map.get(key)).longValue();
        }
        logger.info("Total bytes {}", (Object)total);
    }

    static String getTimeStr(long time) {
        return time == 0L ? "" : MetricsUtil.getTimeStr(time);
    }

    public static void urlConnection(String urlStr) throws IOException {
        int READ_TIMEOUT = 180000;
        int UNIT_CONNECTION_TIMEOUT = 30000;
        int connectionTimeout = 180000;
        int unit = 30000;
        logger.info("URL {}", (Object)urlStr);
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(180000);
        connection.setConnectTimeout(30000);
        MetricsSaver.StopWatch watch = new MetricsSaver.StopWatch();
        while (true) {
            try {
                logger.info("Try connect ReadTimeout:{} ConnectTimeout:{} connectionTimeout:" + connectionTimeout, (Object)180000, (Object)30000);
                connection.connect();
                logger.info("Connect successfully in {} seconds", (Object)watch.elapsedSeconds());
            }
            catch (IOException ioe) {
                logger.info("Connect IOException {} seconds", (Object)watch.elapsedSeconds(), (Object)ioe);
                logger.info("connectionTimeout:{}", (Object)(connectionTimeout -= unit));
                if (connectionTimeout == 0) {
                    throw ioe;
                }
                if (connectionTimeout >= unit) continue;
                unit = connectionTimeout;
                connection.setConnectTimeout(unit);
                continue;
            }
            break;
        }
    }

    public static String asHex(byte[] buf, int len) {
        char[] chars = new char[2 * len];
        for (int i = 0; i < Math.min(len, buf.length); ++i) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readS3Stream(String s3path, long startOffset) throws IOException {
        try (FSDataInputStream inputStream = null;){
            int readlen;
            logger.info("readS3Stream {}", (Object)s3path);
            Configuration configuration = new Configuration();
            FileSystem s3nfs = FileSystem.get((URI)new URI(s3path), (Configuration)configuration);
            logger.info("FileSystem {}", (Object)s3nfs);
            Path path = new Path(s3path);
            inputStream = s3nfs.open(path);
            logger.info("Opened FSDataInputStream for {}", (Object)path);
            if (startOffset != 0L) {
                logger.info("Try to seek to {}", (Object)startOffset);
                inputStream.seek(startOffset);
            }
            logger.info("Current input stream position {}", (Object)inputStream.getPos());
            byte[] buf = new byte[8192];
            int count = 0;
            long total = 0L;
            do {
                total += (readlen = inputStream.read(buf, 0, 8192)) <= 0 ? 0L : (long)readlen;
                if (++count % 100 != 1 && readlen > 0) continue;
                logger.info(String.format("%5d read %5d bytes: %s total:%d pos:%d", count, readlen, AdhocTest.asHex(buf, 8), total, inputStream.getPos()));
            } while (readlen >= 0);
            logger.info("Completed readS3Stream {}", (Object)s3path);
        }
    }

    public static void readS3Object(String s3path, long startOffset) {
        try {
            int readlen;
            logger.info("readS3Object {} {}", (Object)s3path, (Object)startOffset);
            S3Path s3p = S3Path.parse(s3path);
            Credentials cred = Credentials.newInstance();
            ClientConfiguration configuration = new ClientConfiguration();
            configuration.setProtocol(Protocol.HTTPS);
            AmazonS3Client s3 = new AmazonS3Client((AWSCredentials)cred, configuration);
            ObjectMetadata meta = s3.getObjectMetadata(s3p.s3bucket, s3p.s3key);
            long length = meta.getContentLength();
            logger.info("getObject {} {} {} {}", new Object[]{s3p.s3bucket, s3p.s3key, startOffset, length});
            S3Object s3Object = s3.getObject(new GetObjectRequest(s3p.s3bucket, s3p.s3key).withRange(startOffset, length));
            S3ObjectInputStream inputStream = s3Object.getObjectContent();
            byte[] buf = new byte[8192];
            int count = 0;
            long total = 0L;
            do {
                total += (readlen = inputStream.read(buf, 0, 8192)) <= 0 ? 0L : (long)readlen;
                if (++count % 100 != 1 && readlen > 0) continue;
                logger.info(String.format("%5d read %5d bytes: %s total:%d", count, readlen, AdhocTest.asHex(buf, 8), total));
            } while (readlen >= 0);
            logger.info("Completed readS3Object {}", (Object)s3path);
        }
        catch (Exception e) {
            logger.info("testS3RangeRead exception: ", (Throwable)e);
        }
    }
}

