/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.DataMap;
import amazon.emr.metrics.DataOption;
import amazon.emr.metrics.ErrorMap;
import amazon.emr.metrics.MetricsEngine;
import com.google.visualization.datasource.DataSourceServlet;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartServlet
extends DataSourceServlet {
    static final Logger logger = LoggerFactory.getLogger(ChartServlet.class);
    static final Random rand = new Random();
    MetricsEngine engine;

    public ChartServlet(MetricsEngine engine) {
        this.engine = engine;
    }

    public DataTable generateDataTable(Query query, HttpServletRequest request) {
        DataTable table = null;
        DataOption option = new DataOption(request);
        table = option.type == DataOption.ChartType.EMAP ? this.getErrorTableSingle(option) : (option.single ? this.getDataTableSingle(option) : this.getDataTableMultiple(option));
        return table;
    }

    public DataTable getDataTableSingle(DataOption option) {
        logger.info("getDataTableSingle for {}", (Object)option.params);
        DataTable table = new DataTable();
        ArrayList<ColumnDescription> cd = new ArrayList<ColumnDescription>();
        cd.add(new ColumnDescription("time", ValueType.DATETIME, "time"));
        cd.add(new ColumnDescription(option.id, ValueType.NUMBER, option.id));
        table.addColumns(cd);
        TreeMap<Long, Double> map = DataMap.getDataMapSingle(this.engine, option);
        try {
            for (Map.Entry<Long, Double> entry : map.entrySet()) {
                TableRow tr = new TableRow();
                tr.addCell((Value)ChartServlet.GetDataTimeValue(entry.getKey()));
                tr.addCell(entry.getValue().doubleValue());
                table.addRow(tr);
            }
            logger.info("getDataTableSingle with {} rows", (Object)map.size());
        }
        catch (TypeMismatchException e) {
            logger.info("getDataTableSingle {}", (Throwable)e);
        }
        return table;
    }

    public DataTable getErrorTableSingle(DataOption option) {
        logger.info("getErrorTableSingle for {}", (Object)option.params);
        TreeMap<Long, int[]> map = new TreeMap<Long, int[]>();
        Vector<MetricProtos.EmrMetricRecord> records = DataMap.getStreamRecords(this.engine, option.key);
        ErrorMap errors = new ErrorMap();
        for (MetricProtos.EmrMetricRecord r : records) {
            errors.add(r);
        }
        List<Map.Entry<String, Integer>> top = errors.getTop(3);
        int N = top.size();
        for (MetricProtos.EmrMetricRecord r : records) {
            for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
                long time = emrMetricAggregatedValue.getStop();
                if (map.containsKey(time)) continue;
                int[] arr = new int[N + 1];
                Arrays.fill(arr, 0);
                int others = emrMetricAggregatedValue.getNumError();
                for (MetricProtos.EmrMetricErrorItem t : emrMetricAggregatedValue.getErrorsList()) {
                    int index = -1;
                    for (int j = 0; j < top.size(); ++j) {
                        if (!t.getError().equals(top.get(j).getKey())) continue;
                        index = j;
                        others -= t.getCount();
                        break;
                    }
                    if (index < 0) continue;
                    arr[index] = t.getCount();
                }
                if (others > 0) {
                    arr[N] = others;
                }
                map.put(time, arr);
            }
        }
        DataTable table = new DataTable();
        ArrayList<ColumnDescription> cd = new ArrayList<ColumnDescription>();
        cd.add(new ColumnDescription("time", ValueType.DATETIME, "time"));
        for (Map.Entry entry : top) {
            cd.add(new ColumnDescription((String)entry.getKey(), ValueType.NUMBER, (String)entry.getKey()));
        }
        cd.add(new ColumnDescription("Others", ValueType.NUMBER, "Others"));
        table.addColumns(cd);
        try {
            for (Map.Entry entry : map.entrySet()) {
                TableRow tr = new TableRow();
                tr.addCell((Value)ChartServlet.GetDataTimeValue((Long)entry.getKey()));
                int[] arr = (int[])entry.getValue();
                for (int i = 0; i < N + 1; ++i) {
                    tr.addCell((double)arr[i]);
                }
                table.addRow(tr);
            }
            logger.info("getErrorTableSingle with {} rows", (Object)map.size());
        }
        catch (TypeMismatchException e) {
            logger.info("getErrorTableSingle {}", (Throwable)e);
        }
        return table;
    }

    public DataTable getDataTableMultiple(DataOption option) {
        logger.info("getDataTableMultiple for {}", (Object)option.params);
        DataTable table = new DataTable();
        ArrayList<ColumnDescription> cd = new ArrayList<ColumnDescription>();
        cd.add(new ColumnDescription("time", ValueType.DATETIME, "time"));
        for (int i = 0; i < option.keys.size(); ++i) {
            cd.add(new ColumnDescription(option.keys.get(i).getInstanceId(), ValueType.NUMBER, option.keys.get(i).getInstanceId()));
        }
        table.addColumns(cd);
        TreeMap<Long, TreeMap<Integer, Double>> map = DataMap.getDataMapMultiple(this.engine, option);
        double[] last = new double[10];
        for (int i = 0; i < 10; ++i) {
            last[i] = 0.0;
        }
        try {
            for (Map.Entry<Long, TreeMap<Integer, Double>> entry : map.entrySet()) {
                long time = entry.getKey();
                TreeMap<Integer, Double> v = entry.getValue();
                TableRow tr = new TableRow();
                tr.addCell((Value)ChartServlet.GetDataTimeValue(time));
                for (int i = 0; i < option.keys.size(); ++i) {
                    if (v.containsKey(i)) {
                        tr.addCell(v.get(i).doubleValue());
                        last[i] = v.get(i);
                        continue;
                    }
                    if (option.key.getInterval() == 0 && last[i] != 0.0) {
                        tr.addCell(last[i]);
                        continue;
                    }
                    tr.addCell((Value)NumberValue.getNullValue());
                }
                table.addRow(tr);
            }
            logger.info("getDataTableMultiple with {} rows", (Object)map.size());
        }
        catch (TypeMismatchException e) {
            logger.info("getDataTableMultiple {}", (Throwable)e);
        }
        return table;
    }

    public static DateTimeValue GetDataTimeValue(long milliseconds) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(milliseconds);
        return new DateTimeValue(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
    }
}

