/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.Credentials;
import amazon.emr.metrics.FileType;
import amazon.emr.metrics.InstanceControllerRpcClient;
import amazon.emr.metrics.MetricsSaver;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.S3Path;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkUtil {
    static final Logger logger = LoggerFactory.getLogger(ChunkUtil.class);
    public static ExecutorService executorService = Executors.newFixedThreadPool(10, new DaemonThreadFactory());
    static InstanceControllerRpcClient icproxy = null;
    static InstanceControllerRpcClient.GetPolicyResponse policy = null;
    static MultiThreadedHttpConnectionManager hcm = null;
    static HttpClient httpClient = null;
    static final String aws157LogsProd = "aws157-logs-prod";

    static Vector<MetricProtos.FileChunk> mergeChunks(Vector<MetricProtos.FileChunk> chunks, long minTime) {
        if (chunks.size() <= 1) {
            return chunks;
        }
        HashMap chunkMap = new HashMap();
        for (MetricProtos.FileChunk c : chunks) {
            if (c.getMaxTime() != 0L && c.getMaxTime() < minTime) continue;
            if (!chunkMap.containsKey(c.getFilePath())) {
                chunkMap.put(c.getFilePath(), new Vector());
            }
            ((Vector)chunkMap.get(c.getFilePath())).add(c);
        }
        Vector<MetricProtos.FileChunk> output = new Vector<MetricProtos.FileChunk>();
        for (Vector chunksOneFile : chunkMap.values()) {
            if (chunksOneFile.size() <= 1) {
                output.addAll(chunksOneFile);
                continue;
            }
            if (!ChunkUtil.chunksMergeable(chunksOneFile)) {
                logger.info("unexpected non-mergeable chunks");
                output.addAll(chunksOneFile);
                continue;
            }
            output.add(ChunkUtil.mergeChunksSameFile(chunksOneFile));
        }
        return output;
    }

    static Vector<MetricProtos.FileChunk> mergeChunks(Vector<MetricProtos.FileChunk> chunks) {
        return ChunkUtil.mergeChunks(chunks, 0L);
    }

    static boolean chunksMergeable(Vector<MetricProtos.FileChunk> chunks) {
        if (chunks.size() <= 1) {
            return false;
        }
        long lastEnd = chunks.firstElement().getEnd();
        for (int i = 1; i < chunks.size(); ++i) {
            MetricProtos.FileChunk chunk = chunks.get(i);
            if (chunk.getBegin() != lastEnd) {
                return false;
            }
            lastEnd = chunk.getEnd();
        }
        return true;
    }

    static MetricProtos.FileChunk mergeChunksSameFile(Vector<MetricProtos.FileChunk> chunks) {
        MetricProtos.FileChunk first = chunks.firstElement();
        long minBegin = first.getBegin();
        long maxEnd = first.getEnd();
        long minTime = first.getMinTime();
        long maxTime = first.getMaxTime();
        for (MetricProtos.FileChunk c : chunks) {
            minBegin = Math.min(minBegin, c.getBegin());
            maxEnd = Math.max(maxEnd, c.getEnd());
            minTime = Math.min(minTime, c.getMinTime());
            maxTime = Math.max(maxTime, c.getMaxTime());
        }
        MetricProtos.FileChunk.Builder cb = MetricProtos.FileChunk.newBuilder();
        cb.setFilePath(first.getFilePath());
        cb.setTime(System.currentTimeMillis());
        cb.setBegin(minBegin);
        cb.setEnd(maxEnd);
        cb.setMinTime(minTime);
        cb.setMaxTime(maxTime);
        return cb.build();
    }

    public static void showChunks(Vector<MetricProtos.FileChunk> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            logger.info(String.format("  %2d %s [%d,%d)", i, chunks.get(i).getFilePath(), chunks.get(i).getBegin(), chunks.get(i).getEnd()));
        }
    }

    public static boolean upload(AmazonS3Client s3, String srcFile, String s3path) {
        int attemp = 0;
        S3Path p = S3Path.parse(s3path);
        while (++attemp < 6) {
            try {
                if (attemp > 1) {
                    Thread.sleep(1000L);
                }
                File file = new File(srcFile);
                long length = MetricsUtil.getFileLength(srcFile);
                MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
                s3.putObject(new PutObjectRequest(p.s3bucket, p.s3key, file));
                logger.info(String.format("Upload %s %dms %d", s3path, stopWatch.elapsedTime(), length));
                MetricsSaver.addValue("S3WriteDelay", stopWatch.elapsedTime());
                MetricsSaver.addValue("S3WriteBytes", length);
                return true;
            }
            catch (AmazonServiceException ase) {
                logger.error("AmazonServiceException {}", (Throwable)ase);
            }
            catch (Exception e) {
                if (attemp <= 1) continue;
                logger.error("uploadFile error {}", (Throwable)e);
            }
        }
        logger.error("Upload {} failed", (Object)s3path);
        return false;
    }

    public static boolean download(AmazonS3Client s3, String s3path, String dstFile) throws IOException {
        S3Path p = S3Path.parse(s3path);
        int attemp = 0;
        while (++attemp < 6) {
            try {
                if (attemp > 1) {
                    Thread.sleep(1000L);
                }
                MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
                S3Object obj = s3.getObject(new GetObjectRequest(p.s3bucket, p.s3key));
                File file = new File(dstFile);
                if (file.exists()) {
                    ObjectMetadata meta = obj.getObjectMetadata();
                    if (meta.getContentLength() == file.length() && meta.getLastModified().getTime() < file.lastModified()) {
                        return true;
                    }
                    MetricsUtil.deleteFile(dstFile);
                }
                S3ObjectInputStream input = obj.getObjectContent();
                FileOutputStream output = new FileOutputStream(dstFile);
                long length = 0L;
                byte[] buf = new byte[65536];
                MetricsSaver.StopWatch sw = new MetricsSaver.StopWatch();
                while (true) {
                    sw.reset();
                    int len = input.read(buf);
                    MetricsSaver.addValue("S3ReadDelay", sw.elapsedTime());
                    if (len > 0) {
                        MetricsSaver.addValue("S3ReadBytes", len);
                    }
                    if (len <= 0) break;
                    output.write(buf, 0, len);
                    length += (long)len;
                }
                input.close();
                output.close();
                logger.info(String.format("downloaded %s %s %dms %d", s3path, dstFile, stopWatch.elapsedTime(), length));
                return true;
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equals("NoSuchKey")) {
                    MetricsUtil.deleteFile(dstFile);
                    return false;
                }
                logger.error("AmazonServiceException {}", (Throwable)ase);
            }
            catch (Exception e) {
                if (attemp <= 1) continue;
                logger.error("download {} error {}", (Object)s3path, (Object)e);
            }
        }
        logger.error("download {} failed", (Object)s3path);
        return false;
    }

    public static String getStringMd5OfFile(File file) {
        try {
            HashCode hash = Files.hash((File)file, (HashFunction)Hashing.md5());
            byte[] md5 = hash.asBytes();
            return new String(Base64.encodeBase64((byte[])md5));
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating file MD5", e);
        }
    }

    public static Vector<DownloadChunkTask> downloadChunks(AmazonS3Client s3, Vector<MetricProtos.FileChunk> s3chunks, String localDir) throws InterruptedException {
        Vector<DownloadChunkTask> tasks = new Vector<DownloadChunkTask>();
        for (MetricProtos.FileChunk s3chunk : s3chunks) {
            tasks.add(new DownloadChunkTask(s3, s3chunk, localDir));
        }
        executorService.invokeAll(tasks);
        return tasks;
    }

    public static void stitchFiles(Vector<String> inputFiles, String outputFile) throws IOException {
        Vector<MetricProtos.FileChunk> chunks = new Vector<MetricProtos.FileChunk>();
        for (String file : inputFiles) {
            MetricProtos.FileChunk.Builder cb = MetricProtos.FileChunk.newBuilder();
            cb.setFilePath(file);
            cb.setBegin(0L);
            cb.setEnd(new File(file).length());
            cb.setMinTime(0L);
            cb.setMaxTime(0L);
            cb.setTime(System.currentTimeMillis());
            chunks.add(cb.build());
        }
        ChunkUtil.stitchFileChunks(chunks, outputFile);
    }

    public static void stitchFileChunks(Vector<MetricProtos.FileChunk> chunks, String outputFile) throws IOException {
        MetricsUtil.deleteFile(outputFile);
        FileOutputStream output = new FileOutputStream(outputFile);
        long length = 0L;
        for (MetricProtos.FileChunk chunk : chunks) {
            length += ChunkUtil.writeFileChunkToStream(output, chunk);
        }
        output.close();
        logger.info(String.format("Stitched %d chunks to %s %d", chunks.size(), outputFile, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long writeFileChunkToStream(FileOutputStream output, MetricProtos.FileChunk chunk) throws IOException {
        int bufSize = 65536;
        byte[] buf = new byte[65536];
        long length = 0L;
        int bytesRemain = (int)(chunk.getEnd() - chunk.getBegin());
        if (MetricsUtil.getFileType(chunk.getFilePath()) == FileType.HDFS) {
            try (FSDataInputStream hdfsInput = null;){
                Configuration configuration = new Configuration();
                FileSystem hdfs = FileSystem.get((Configuration)configuration);
                Path path = new Path(chunk.getFilePath());
                hdfsInput = hdfs.open(path);
                hdfsInput.seek(chunk.getBegin());
                while (bytesRemain > 0) {
                    int len = hdfsInput.read(buf, 0, Math.min(65536, bytesRemain));
                    if (len <= 0) {
                    }
                    output.write(buf, 0, len);
                    bytesRemain -= len;
                    length += (long)len;
                }
            }
        } else {
            int len;
            FileInputStream input = new FileInputStream(chunk.getFilePath());
            input.skip(chunk.getBegin());
            while (bytesRemain > 0 && (len = input.read(buf, 0, Math.min(65536, bytesRemain))) > 0) {
                output.write(buf, 0, len);
                bytesRemain -= len;
                length += (long)len;
            }
            input.close();
        }
        return length;
    }

    public static void showS3Recursive(AmazonS3Client s3, String s3path) {
        S3Path p = S3Path.parse(s3path);
        ObjectListing objectListing = s3.listObjects(p.s3bucket, p.s3key + "/");
        for (S3ObjectSummary obj : objectListing.getObjectSummaries()) {
            System.out.format("%9d %s\n", obj.getSize(), S3Path.getPath(obj.getBucketName(), obj.getKey()));
        }
    }

    public static void showS3Recursive(String s3path) throws RuntimeException, IOException {
        Credentials credentials = Credentials.newInstance();
        ChunkUtil.showS3Recursive(new AmazonS3Client((AWSCredentials)credentials), s3path);
    }

    public static class DownloadChunkTask
    implements Callable<Boolean> {
        public MetricProtos.FileChunk chunk;
        public boolean success;
        public String localFile;
        S3Path p;
        AmazonS3Client s3;

        DownloadChunkTask(AmazonS3Client s3, MetricProtos.FileChunk s3chunk, String localDir) {
            this.s3 = s3;
            this.chunk = s3chunk;
            this.p = S3Path.parse(s3chunk.getFilePath());
            this.success = false;
            this.localFile = MetricsUtil.combinePath(localDir, this.p.basename);
        }

        @Override
        public Boolean call() {
            try {
                this.success = ChunkUtil.download(this.s3, this.p.path, this.localFile);
                return this.success;
            }
            catch (Exception e) {
                logger.info("DownloadChunkTask {} exception {}", (Object)this.p.path, (Object)e);
                return false;
            }
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

