/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.MetricsUtil;
import com.amazonaws.auth.AWSCredentials;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Credentials
implements AWSCredentials {
    static final String hadoopCoreSiteFile = "/home/hadoop/conf/core-site.xml";
    static final String emrCredentialsJsonFile = "/home/danzhi/emr/credentials.json";
    @SerializedName(value="access-id")
    public String accessId;
    @SerializedName(value="private-key")
    public String privateKey;
    @SerializedName(value="key-pair")
    public String keyPair;
    @SerializedName(value="key-pair-file")
    public String keyPairFile;
    @SerializedName(value="log-uri")
    public String logUri;

    public String getAWSAccessKeyId() {
        return this.accessId;
    }

    public String getAWSSecretKey() {
        return this.privateKey;
    }

    public static Credentials newInstance(String credentialsFile) throws RuntimeException, IOException {
        if (!MetricsUtil.fileExists(credentialsFile)) {
            throw new RuntimeException("credential file does NOT exist: " + credentialsFile);
        }
        if (credentialsFile.indexOf(".json") >= 0) {
            String json = MetricsUtil.readFileAsString(credentialsFile);
            return (Credentials)new Gson().fromJson(json, Credentials.class);
        }
        if (credentialsFile.indexOf(".xml") >= 0) {
            return Credentials.parseFromHadoopXml(credentialsFile);
        }
        throw new RuntimeException("not supported credential file: " + credentialsFile);
    }

    public static Credentials newInstance() throws RuntimeException, IOException {
        if (MetricsUtil.fileExists(emrCredentialsJsonFile)) {
            return Credentials.newInstance(emrCredentialsJsonFile);
        }
        if (MetricsUtil.fileExists(hadoopCoreSiteFile)) {
            return Credentials.newInstance(hadoopCoreSiteFile);
        }
        throw new RuntimeException("default credential file not found");
    }

    public Credentials(String accessKey, String secretKey) {
        this.accessId = accessKey;
        this.privateKey = secretKey;
    }

    protected Credentials() {
    }

    private static Credentials parseFromHadoopXml(String hadoopXmlFile) {
        try {
            String accessKey = null;
            String secretKey = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(hadoopXmlFile);
            Element rootElem = dom.getDocumentElement();
            NodeList properties = rootElem.getElementsByTagName("property");
            if (properties != null && properties.getLength() > 0) {
                for (int i = 0; i < properties.getLength(); ++i) {
                    NodeList values;
                    Element elp = (Element)properties.item(i);
                    NodeList names = elp.getElementsByTagName("name");
                    if (names == null) continue;
                    if (names.item(0).getTextContent().equals("fs.s3.awsAccessKeyId") && (values = elp.getElementsByTagName("value")) != null) {
                        accessKey = values.item(0).getTextContent();
                    }
                    if (!names.item(0).getTextContent().equals("fs.s3.awsSecretAccessKey") || (values = elp.getElementsByTagName("value")) == null) continue;
                    secretKey = values.item(0).getTextContent();
                }
            }
            if (accessKey == null || secretKey == null) {
                throw new RuntimeException("No security keys found in " + hadoopXmlFile);
            }
            return new Credentials(accessKey, secretKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse xml file " + e.getMessage());
        }
    }
}

