/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.DataOption;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.MetricsUtil;
import java.util.TreeMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMap {
    static final Logger logger = LoggerFactory.getLogger(DataMap.class);

    public static Vector<MetricProtos.EmrMetricRecord> getStreamRecords(MetricsEngine engine, MetricProtos.EmrMetricKey key) {
        Vector<MetricProtos.EmrMetricRecord> output;
        if (key.getInterval() == 0) {
            MetricProtos.EmrMetricKey.Builder b = key.toBuilder();
            b.setInterval(10);
            output = engine.getInputRecords(b.build());
        } else {
            output = engine.getOutputRecords(key);
        }
        logger.info("getStreamRecords {} {}", (Object)MetricsUtil.getStreamId(key), (Object)output.size());
        return output;
    }

    public static TreeMap<Long, Double> getDataMapSingle(MetricsEngine engine, DataOption option) {
        TreeMap<Long, Double> map = new TreeMap<Long, Double>();
        Vector<MetricProtos.EmrMetricRecord> records = DataMap.getStreamRecords(engine, option.key);
        for (MetricProtos.EmrMetricRecord r : records) {
            for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
                if (emrMetricAggregatedValue.getCount() == 0 && option.type != DataOption.ChartType.ERR) continue;
                double value = DataMap.getNumericalValue(emrMetricAggregatedValue, option.type);
                if (map.containsKey(emrMetricAggregatedValue.getStop())) continue;
                map.put(emrMetricAggregatedValue.getStop(), value);
            }
            for (MetricProtos.EmrMetricRawValue emrMetricRawValue : r.getValuesList()) {
                if (!emrMetricRawValue.hasValue() || map.containsKey(emrMetricRawValue.getTime())) continue;
                map.put(emrMetricRawValue.getTime(), Double.valueOf(emrMetricRawValue.getValue()));
            }
        }
        logger.info("getDataMapSingle {} {}", (Object)option.params, (Object)map.size());
        return map;
    }

    public static double getNumericalValue(MetricProtos.EmrMetricAggregatedValue v, DataOption.ChartType type) {
        if (type == DataOption.ChartType.COUNT) {
            return v.getCount();
        }
        if (type == DataOption.ChartType.TP90) {
            return v.getTp90();
        }
        if (type == DataOption.ChartType.TP99) {
            return v.getTp99();
        }
        if (type == DataOption.ChartType.SUM) {
            return v.getSum();
        }
        if (type == DataOption.ChartType.ERR) {
            return v.getNumError();
        }
        return v.getAverage();
    }

    public static TreeMap<Long, TreeMap<Integer, Double>> getDataMapMultiple(MetricsEngine engine, DataOption option) {
        TreeMap<Long, TreeMap<Integer, Double>> map = new TreeMap<Long, TreeMap<Integer, Double>>();
        for (int i = 0; i < option.keys.size(); ++i) {
            Vector<MetricProtos.EmrMetricRecord> records = DataMap.getStreamRecords(engine, option.keys.get(i));
            for (MetricProtos.EmrMetricRecord r : records) {
                for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
                    if (emrMetricAggregatedValue.getCount() == 0 && option.type != DataOption.ChartType.ERR) continue;
                    long time = emrMetricAggregatedValue.getStop();
                    if (!map.containsKey(time)) {
                        map.put(time, new TreeMap());
                    }
                    map.get(time).put(i, DataMap.getNumericalValue(emrMetricAggregatedValue, option.type));
                }
                for (MetricProtos.EmrMetricRawValue emrMetricRawValue : r.getValuesList()) {
                    if (!emrMetricRawValue.hasValue()) continue;
                    if (!map.containsKey(emrMetricRawValue.getTime())) {
                        map.put(emrMetricRawValue.getTime(), new TreeMap());
                    }
                    map.get(emrMetricRawValue.getTime()).put(i, Double.valueOf(emrMetricRawValue.getValue()));
                }
            }
        }
        logger.info("getDataMapMultiple {} {}", (Object)option.params, (Object)map.size());
        return map;
    }
}

