/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.MetricsUtil;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DataOption {
    public final Vector<String> ids = new Vector();
    public final Vector<MetricProtos.EmrMetricKey> keys = new Vector();
    public final boolean single;
    public final String id;
    public final MetricProtos.EmrMetricKey key;
    public final ChartType type;
    public final String typeStr;
    public final String params;
    public static final String[] typestrs = new String[]{"avg", "ct", "t90", "t99", "sum", "er", "em"};
    public static final String defaultId = MetricsUtil.getInstanceId() + ":All:HeapMemoryUsage:10";

    public DataOption(HttpServletRequest request) {
        String k;
        String v;
        String tid = request.getParameter("id");
        MetricProtos.EmrMetricKey tkey = MetricsUtil.tryGetEmrMetricKeyFromId(tid);
        if (tkey == null) {
            tid = defaultId;
            tkey = MetricsUtil.getEmrMetricKeyFromId(tid);
        }
        this.id = tid;
        this.key = tkey;
        this.ids.add(this.id);
        this.keys.add(this.key);
        this.type = DataOption.parseChartType(request.getParameter("t"));
        this.typeStr = DataOption.getChartTypeStr(this.type);
        for (int i = 1; i < 10 && (v = request.getParameter(k = String.format("id%d", i))) != null; ++i) {
            if (v.indexOf(58) >= 0) continue;
            boolean dup = false;
            for (int j = 0; j < this.keys.size(); ++j) {
                if (!this.keys.get(j).getInstanceId().equals(v)) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            String fullId = MetricsUtil.getStreamId(v, this.key.getProcess(), this.key.getKey(), this.key.getInterval());
            this.ids.add(fullId);
            this.keys.add(MetricsUtil.getEmrMetricKeyFromId(fullId));
        }
        this.single = this.ids.size() <= 1;
        this.params = this.getParams();
    }

    public static ChartType parseChartType(String t) {
        if (t == null) {
            return ChartType.AVG;
        }
        if (t.equals("ct") || t.equals("c")) {
            return ChartType.COUNT;
        }
        if (t.equals("t90") || t.equals("tp90")) {
            return ChartType.TP90;
        }
        if (t.equals("t99") || t.equals("tp99")) {
            return ChartType.TP99;
        }
        if (t.startsWith("sum")) {
            return ChartType.SUM;
        }
        if (t.startsWith("er")) {
            return ChartType.ERR;
        }
        if (t.startsWith("em")) {
            return ChartType.EMAP;
        }
        return ChartType.AVG;
    }

    public static String getChartTypeStr(ChartType t) {
        if (t == ChartType.AVG) {
            return "avg";
        }
        if (t == ChartType.COUNT) {
            return "ct";
        }
        if (t == ChartType.TP90) {
            return "t90";
        }
        if (t == ChartType.TP99) {
            return "t99";
        }
        if (t == ChartType.SUM) {
            return "sum";
        }
        if (t == ChartType.ERR) {
            return "er";
        }
        if (t == ChartType.EMAP) {
            return "em";
        }
        return "avg";
    }

    public String getInstanceId(int index) {
        if (this.ids.get(index).indexOf(58) <= 0) {
            return this.ids.get(index);
        }
        return this.ids.get(index).substring(0, this.ids.get(index).indexOf(58));
    }

    public boolean hasInstance(String instance) {
        for (MetricProtos.EmrMetricKey key : this.keys) {
            if (!instance.equals(key.getInstanceId())) continue;
            return true;
        }
        return false;
    }

    private String getParams() {
        return String.format("id=%s&t=%s%s", this.ids.get(0), this.typeStr, this.getExtraIdsParam());
    }

    public String getExtraIdsParam() {
        if (this.keys.size() <= 1) {
            return "";
        }
        String params = "";
        for (int i = 1; i < this.keys.size(); ++i) {
            params = params + String.format("&id%d=%s", i, this.keys.get(i).getInstanceId());
        }
        return params;
    }

    public static enum ChartType {
        AVG,
        COUNT,
        TP90,
        TP99,
        SUM,
        ERR,
        EMAP;

    }
}

