/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.PutMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceControllerRpcClient {
    static final Logger logger = LoggerFactory.getLogger(InstanceControllerRpcClient.class);
    RpcClient client = new RpcClient(RpcClient.newDefaultConfiguration());

    public PingResponse ping() {
        return this.client.call("/ping", PingResponse.class);
    }

    public GetPolicyResponse getPolicy() {
        return this.client.call("/getPolicy", GetPolicyResponse.class);
    }

    public SupportedProducts getSupportedProducts() {
        return this.client.call("/supportedProducts", SupportedProducts.class);
    }

    static class RpcClient {
        SimpleHttpConnectionManager connMgr = new SimpleHttpConnectionManager();
        HttpClient client;

        public RpcClient(Configuration configuration) {
            this.connMgr.getParams().setConnectionTimeout(configuration.getConnectionTimeout());
            this.connMgr.getParams().setSoTimeout(configuration.getSoTimeout());
            this.client = new HttpClient((HttpConnectionManager)this.connMgr);
            this.client.getHostConfiguration().setHost(configuration.getHostName(), configuration.getPort());
        }

        public <T> T call(String methodName, Class<T> responseType) {
            PutMethod method = new PutMethod(methodName);
            RuntimeException exStatus = null;
            try {
                this.client.executeMethod((HttpMethod)method);
                if (method.getStatusCode() != 200) {
                    exStatus = new RuntimeException("RPC " + methodName + " error status code=" + method.getStatusCode() + " response=" + method.getResponseBodyAsString());
                }
                T t = RpcClient.fromGson(method.getResponseBodyAsString(), responseType);
                return t;
            }
            catch (Exception e) {
                throw new RuntimeException("RPC " + methodName + " error " + e.getMessage());
            }
            finally {
                method.releaseConnection();
                this.connMgr.closeIdleConnections(0L);
                if (exStatus != null) {
                    throw exStatus;
                }
            }
        }

        public static Configuration newDefaultConfiguration() {
            return new Configuration();
        }

        public static <T> T fromGson(String value, Class<T> type) {
            return (T)RpcClient.createJsonBuilder().fromJson(value, type);
        }

        public static Gson createJsonBuilder() {
            return new GsonBuilder().disableHtmlEscaping().create();
        }

        static class Configuration {
            int connectionTimeout = 5000;
            int soTimeout = 90000;
            String hostName = "localhost";
            int port = 8321;

            Configuration() {
            }

            public String getHostName() {
                return this.hostName;
            }

            public void setHostName(String hostName) {
                this.hostName = hostName;
            }

            public int getPort() {
                return this.port;
            }

            public void setPort(int port) {
                this.port = port;
            }

            public int getConnectionTimeout() {
                return this.connectionTimeout;
            }

            public void setConnectionTimeout(int connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
            }

            public int getSoTimeout() {
                return this.soTimeout;
            }

            public void setSoTimeout(int soTimeout) {
                this.soTimeout = soTimeout;
            }
        }
    }

    public static class SupportedProducts {
        public String[] supportedProducts;
    }

    public static class PingResponse {
        public int id = 0;
        public String localStartupState;
    }

    public static class GetPolicyResponse {
        public String bucket;
        public String keyPrefix;
        public long expirationTime;
        public String accessKeyId;
        public String secretAccessKey;
        public String sessionToken;
    }
}

