/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.ProcessProcessor;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstanceProcessor {
    static final Logger logger = LoggerFactory.getLogger(InstanceProcessor.class);
    public final String instanceId;
    final MetricsEngine engine;
    HashMap<String, ProcessProcessor> processors;
    ProcessProcessor allProcessor;

    InstanceProcessor(MetricsEngine engine, String instanceId) {
        logger.info("Construct InstanceProcessor {}", (Object)instanceId);
        this.engine = engine;
        this.instanceId = instanceId;
        this.processors = new HashMap();
        this.allProcessor = new ProcessProcessor(engine, instanceId, "All");
        this.processors.put("All", this.allProcessor);
    }

    public void getProcessorStates(Vector<MetricProtos.ProcessorState> states) {
        for (ProcessProcessor p : this.processors.values()) {
            p.getProcessorStates(states);
        }
    }

    public void dispatchInput(MetricProtos.EmrMetricRecord r) {
        int interval = r.getKey().getInterval();
        if (interval != 0 && interval != 10 && interval != 60) {
            return;
        }
        ProcessProcessor p = this.ensureProcessor(r.getKey().getProcess());
        p.dispatchInput(r);
        if (r.getKey().getInterval() < 10) {
            this.allProcessor.dispatchInput(r);
        }
    }

    public void dispatchOutput(MetricProtos.EmrMetricRecord r) {
        ProcessProcessor p = this.ensureProcessor(r.getKey().getProcess());
        p.dispatchOutput(r);
    }

    public void process(long engineCursor, int interval, Vector<MetricProtos.EmrMetricRecord> output) {
        for (ProcessProcessor p : this.processors.values()) {
            p.process(engineCursor, interval, output);
        }
    }

    public Set<String> getProcesses() {
        return this.processors.keySet();
    }

    public Set<String> getKeys() {
        TreeSet<String> names = new TreeSet<String>();
        for (ProcessProcessor p : this.processors.values()) {
            Set<String> keys = p.getKeys();
            names.addAll(keys);
        }
        return names;
    }

    ProcessProcessor getProcessor(String process) {
        return this.processors.get(process);
    }

    synchronized ProcessProcessor ensureProcessor(String process) {
        if (!this.processors.containsKey(process)) {
            ProcessProcessor pp = new ProcessProcessor(this.engine, this.instanceId, process);
            this.processors.put(process, pp);
        }
        return this.processors.get(process);
    }
}

