/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.IntervalValuesMap;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.MetricsProcessorBase;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.ValueCountMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntervalAggregator
extends MetricsProcessorBase {
    static final Logger logger = LoggerFactory.getLogger(IntervalAggregator.class);
    public static final int MaxValuesPerRecord = 50;
    int durationMs;
    IntervalValuesMap inputValues;

    public IntervalAggregator(MetricsEngine engine, String instanceId, String process, String key, int interval) {
        super(engine, instanceId, process, key, interval);
        this.durationMs = interval * 1000;
        this.inputValues = new IntervalValuesMap(interval);
    }

    @Override
    public boolean addInputRecord(MetricProtos.EmrMetricRecord r) {
        boolean ok = super.addInputRecord(r);
        if (ok) {
            this.inputValues.add(r);
        }
        return ok;
    }

    @Override
    public Vector<MetricProtos.EmrMetricRecord> process(long engineCursor) {
        Vector<MetricProtos.EmrMetricRecord> output = new Vector<MetricProtos.EmrMetricRecord>();
        this.inputCursor = this.aggregate(engineCursor, output);
        for (MetricProtos.EmrMetricRecord r : output) {
            this.addOutputRecord(r);
        }
        if (this.traceme) {
            logger.info(String.format("%s aggregate input:%d output:%d records", this.id, this.inputQueue.size(), output.size()));
        }
        this.removeExpiredRecords();
        int count = this.inputValues.removeExpiredValues(this.inputCursor);
        if (this.traceme) {
            logger.info("{} removed {} expired values", (Object)this.id, (Object)count);
        }
        return output;
    }

    private long aggregate(long engineCursor, Vector<MetricProtos.EmrMetricRecord> output) {
        if (this.traceme) {
            logger.info("{} aggregate {}", (Object)this.id, (Object)engineCursor);
        }
        long intervalStop = TimeInterval.getIntervalStart(engineCursor, this.interval);
        long minInput = this.getMinInputTime();
        if (this.inputQueue.size() == 0 || minInput >= intervalStop || this.inputCursor >= intervalStop) {
            return intervalStop;
        }
        long intervalStart = TimeInterval.getIntervalStart(Math.max(this.inputCursor, minInput), this.interval);
        MetricProtos.EmrMetricRecord.Builder b = null;
        for (long t = intervalStart; t < intervalStop; t += (long)this.durationMs) {
            if (!this.inputValues.contains(t)) continue;
            ValueCountMap valueCountMap = new ValueCountMap();
            valueCountMap.addRawValues(this.inputValues.getRvalues(t));
            valueCountMap.addAggValues(this.inputValues.getAvalues(t));
            if (valueCountMap.isEmpty()) continue;
            MetricProtos.EmrMetricAggregatedValue value = valueCountMap.aggregate(t, t + (long)this.durationMs);
            if (b == null) {
                b = MetricProtos.EmrMetricRecord.newBuilder();
            }
            b.addValuesEx(value);
            if (b.getValuesExCount() < 50) continue;
            b.setKey(this.metricKey);
            MetricProtos.EmrMetricRecord r = b.build();
            output.add(r);
            b = null;
        }
        if (b != null && b.getValuesExCount() > 0) {
            b.setKey(this.metricKey);
            MetricProtos.EmrMetricRecord r = b.build();
            output.add(r);
        }
        return intervalStop;
    }

    public static MetricProtos.EmrMetricAggregatedValue aggregateInterval(Vector<MetricProtos.EmrMetricRecord> records, TimeInterval interval) {
        ValueCountMap countMap = new ValueCountMap();
        block0: for (MetricProtos.EmrMetricRecord r : records) {
            for (MetricProtos.EmrMetricRawValue emrMetricRawValue : r.getValuesList()) {
                if (emrMetricRawValue.getTime() < interval.start) continue;
                if (emrMetricRawValue.getTime() >= interval.stop) break;
                countMap.add(emrMetricRawValue);
            }
            for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
                if (emrMetricAggregatedValue.getStop() <= interval.start) continue;
                if (emrMetricAggregatedValue.getStart() >= interval.stop) continue block0;
                countMap.add(emrMetricAggregatedValue);
            }
        }
        return countMap.isEmpty() ? null : countMap.aggregate(interval);
    }

    public static MetricProtos.EmrMetricRecord aggregateRawValues(MetricProtos.EmrMetricRecord r, int maxDensity) {
        int count = r.getValuesCount();
        if (count <= maxDensity) {
            return r;
        }
        int durationSec = 1 + (int)(MetricsUtil.getDuration(r) / 1000L);
        if (count < durationSec * maxDensity) {
            return r;
        }
        MetricProtos.EmrMetricRecord.Builder rb = MetricProtos.EmrMetricRecord.newBuilder();
        rb.setKey(r.getKey());
        rb.addAllValuesEx(r.getValuesExList());
        List<MetricProtos.EmrMetricAggregatedValue> aggValues = IntervalAggregator.aggregateRawValues(r.getValuesList());
        if (aggValues.size() > 0) {
            rb.addAllValuesEx(aggValues);
        }
        return rb.build();
    }

    public static List<MetricProtos.EmrMetricAggregatedValue> aggregateRawValues(List<MetricProtos.EmrMetricRawValue> values) {
        ArrayList<MetricProtos.EmrMetricAggregatedValue> output = new ArrayList<MetricProtos.EmrMetricAggregatedValue>();
        if (values == null || values.size() == 0) {
            return output;
        }
        TimeInterval interval = new TimeInterval(values.get(0).getTime(), 1000);
        ValueCountMap countMap = new ValueCountMap();
        for (MetricProtos.EmrMetricRawValue v : values) {
            if (v.getTime() >= interval.stop) {
                output.add(countMap.aggregate(interval));
                interval = new TimeInterval(v.getTime(), 1000);
                countMap = new ValueCountMap();
            }
            countMap.add(v);
        }
        output.add(countMap.aggregate(interval));
        return output;
    }

    public static MetricProtos.EmrMetricAggregatedValue aggregateRecords(Vector<MetricProtos.EmrMetricRecord> records) {
        if (records.size() == 0) {
            return null;
        }
        ValueCountMap countMap = new ValueCountMap();
        countMap.addRecords(records);
        return countMap.aggregate();
    }

    public static class TimeInterval {
        public final long start;
        public final long stop;
        final int duration;

        public static long getIntervalStart(long time, int interval) {
            return time - time % (long)(interval * 1000);
        }

        public TimeInterval(long time, int duration) {
            this.start = time - time % (long)duration;
            this.stop = this.start + (long)duration;
            this.duration = duration;
        }

        public boolean contains(long time) {
            return time >= this.start && time < this.stop;
        }

        TimeInterval getNextInterval() {
            return new TimeInterval(this.stop, this.duration);
        }

        public String toString() {
            return String.format("[%d, %d)", this.start, this.stop);
        }
    }
}

