/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.IntervalAggregator;
import java.util.TreeMap;
import java.util.Vector;

public class IntervalValuesMap {
    int interval;
    TreeMap<Long, Vector<MetricProtos.EmrMetricRawValue>> rvalues;
    TreeMap<Long, Vector<MetricProtos.EmrMetricAggregatedValue>> avalues;

    IntervalValuesMap(int interval) {
        this.interval = interval;
        this.rvalues = new TreeMap();
        this.avalues = new TreeMap();
    }

    public void add(MetricProtos.EmrMetricRecord r) {
        for (MetricProtos.EmrMetricRawValue emrMetricRawValue : r.getValuesList()) {
            this.ensureRaw(emrMetricRawValue.getTime()).add(emrMetricRawValue);
        }
        for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
            this.ensureAgg(emrMetricAggregatedValue.getStart()).add(emrMetricAggregatedValue);
        }
    }

    public int removeExpiredValues(long cutoff) {
        long key;
        int i;
        int count = 0;
        for (i = 0; i < this.rvalues.size() && (key = this.rvalues.firstKey().longValue()) < cutoff; ++i) {
            this.rvalues.remove(key);
            ++count;
        }
        for (i = 0; i < this.avalues.size() && (key = this.avalues.firstKey().longValue()) < cutoff; ++i) {
            this.avalues.remove(key);
            ++count;
        }
        return count;
    }

    public Vector<MetricProtos.EmrMetricRawValue> getRvalues(long key) {
        return this.rvalues.get(key);
    }

    public Vector<MetricProtos.EmrMetricAggregatedValue> getAvalues(long key) {
        return this.avalues.get(key);
    }

    public boolean contains(long key) {
        return this.rvalues.containsKey(key) || this.avalues.containsKey(key);
    }

    private synchronized Vector<MetricProtos.EmrMetricRawValue> ensureRaw(long time) {
        long key = IntervalAggregator.TimeInterval.getIntervalStart(time, this.interval);
        if (!this.rvalues.containsKey(key)) {
            this.rvalues.put(key, new Vector());
        }
        return this.rvalues.get(key);
    }

    private synchronized Vector<MetricProtos.EmrMetricAggregatedValue> ensureAgg(long time) {
        long key = IntervalAggregator.TimeInterval.getIntervalStart(time, this.interval);
        if (!this.avalues.containsKey(key)) {
            this.avalues.put(key, new Vector());
        }
        return this.avalues.get(key);
    }
}

