/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.IntervalAggregator;
import amazon.emr.metrics.MetricsEngine;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyProcessor {
    static final Logger logger = LoggerFactory.getLogger(KeyProcessor.class);
    public final String instanceId;
    public final String process;
    public final String key;
    public final String id;
    final MetricsEngine engine;
    IntervalAggregator ia10;
    IntervalAggregator ia60;
    IntervalAggregator ia300;
    HashMap<Integer, IntervalAggregator> ia;
    private static AtomicInteger scounter = new AtomicInteger();

    KeyProcessor(MetricsEngine engine, String instanceId, String process, String key) {
        this.id = String.format("%s:%s:%s", instanceId, process, key);
        logger.info("{} Create KeyProcessor {}", (Object)scounter.incrementAndGet(), (Object)this.id);
        this.engine = engine;
        this.instanceId = instanceId;
        this.process = process;
        this.key = key;
        this.ia10 = new IntervalAggregator(engine, instanceId, process, key, 10);
        this.ia60 = new IntervalAggregator(engine, instanceId, process, key, 60);
        this.ia300 = new IntervalAggregator(engine, instanceId, process, key, 300);
        this.ia = new HashMap();
        this.ia.put(10, this.ia10);
        this.ia.put(60, this.ia60);
        this.ia.put(300, this.ia300);
    }

    public void getProcessorStates(Vector<MetricProtos.ProcessorState> states) {
        for (IntervalAggregator p : this.ia.values()) {
            MetricProtos.ProcessorState s = p.getState();
            states.add(s);
        }
    }

    IntervalAggregator getProcessor(int interval) {
        return this.ia.get(interval);
    }

    public void dispatchInput(MetricProtos.EmrMetricRecord r) {
        int interval = r.getKey().getInterval();
        if (interval == 0) {
            this.ia10.addInputRecord(r);
        } else if (interval == 10) {
            this.ia60.addInputRecord(r);
        } else if (interval == 60) {
            this.ia300.addInputRecord(r);
        }
    }

    public void dispatchOutput(MetricProtos.EmrMetricRecord r) {
        int interval = r.getKey().getInterval();
        if (interval == 10) {
            this.ia10.addOutputRecord(r);
        } else if (interval == 60) {
            this.ia60.addOutputRecord(r);
        } else if (interval == 300) {
            this.ia300.addOutputRecord(r);
        }
    }

    public void process(long engineCursor, int interval, Vector<MetricProtos.EmrMetricRecord> output) {
        if (interval != 10 && interval != 60 && interval != 300) {
            return;
        }
        IntervalAggregator a = this.ia.get(interval);
        Vector<MetricProtos.EmrMetricRecord> records = a.process(engineCursor);
        output.addAll(records);
    }

    public Vector<MetricProtos.EmrMetricRecord> getOutputRecords(int interval) {
        IntervalAggregator a = this.ia.get(interval);
        if (a == null) {
            return new Vector<MetricProtos.EmrMetricRecord>();
        }
        return a.getOutputRecords();
    }

    public Vector<MetricProtos.EmrMetricRecord> getInputRecords(int interval) {
        IntervalAggregator a = this.ia.get(interval);
        if (a == null) {
            return new Vector<MetricProtos.EmrMetricRecord>();
        }
        return a.getInputRecords();
    }
}

