/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.FileType;
import amazon.emr.metrics.MetricsReader;
import amazon.emr.metrics.MetricsUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRecordReader {
    static final Logger logger = LoggerFactory.getLogger(MetricRecordReader.class);
    String filePath;
    long beginOffset;
    long endOffset;
    boolean hdfs;
    FSDataInputStream hdfsInput = null;
    FileInputStream fileInput = null;
    MetricsReader.PositionInputStream ps = null;
    int numRecordsRead = 0;

    public MetricRecordReader(String filePath) {
        this(filePath, 0L, 0L);
    }

    public MetricRecordReader(MetricProtos.FileChunk chunk) {
        this(chunk.getFilePath(), chunk.getBegin(), chunk.getEnd());
    }

    public MetricRecordReader(String filePath, long beginOffset, long endOffset) {
        this.filePath = filePath;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
        this.hdfs = MetricsUtil.getFileType(filePath) == FileType.HDFS;
    }

    public MetricProtos.EmrMetricRecord read() throws IOException {
        MetricProtos.EmrMetricRecord r;
        MetricProtos.EmrMetricRecord emrMetricRecord = r = this.hdfs ? this.readHDFS() : this.readLocal();
        if (r != null) {
            ++this.numRecordsRead;
        }
        return r;
    }

    public Vector<MetricProtos.EmrMetricRecord> readAll() throws IOException {
        MetricProtos.EmrMetricRecord r;
        Vector<MetricProtos.EmrMetricRecord> records = new Vector<MetricProtos.EmrMetricRecord>();
        while ((r = this.read()) != null) {
            ++this.numRecordsRead;
            records.add(r);
        }
        return records;
    }

    public int getNumRecordsRead() {
        return this.numRecordsRead;
    }

    public void close() throws IOException {
        if (this.hdfsInput != null) {
            this.hdfsInput.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.fileInput != null) {
            this.fileInput.close();
        }
    }

    MetricProtos.EmrMetricRecord readHDFS() throws IOException {
        if (this.hdfsInput == null) {
            Configuration configuration = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)configuration);
            Path path = new Path(this.filePath);
            this.hdfsInput = hdfs.open(path);
            if (this.beginOffset > 0L) {
                this.hdfsInput.seek(this.beginOffset);
            }
        }
        if (this.endOffset > 0L && this.hdfsInput.getPos() >= this.endOffset) {
            return null;
        }
        return MetricProtos.EmrMetricRecord.parseDelimitedFrom((InputStream)this.hdfsInput);
    }

    MetricProtos.EmrMetricRecord readLocal() throws IOException {
        if (this.ps == null) {
            this.fileInput = new FileInputStream(this.filePath);
            this.ps = new MetricsReader.PositionInputStream(this.fileInput);
            if (this.beginOffset > 0L) {
                this.ps.skip(this.beginOffset);
            }
        }
        if (this.endOffset > 0L && this.ps.getPosition() >= this.endOffset) {
            return null;
        }
        return MetricProtos.EmrMetricRecord.parseDelimitedFrom(this.ps);
    }

    public static Vector<MetricProtos.EmrMetricRecord> readMetricsFile(MetricProtos.FileChunk chunk) throws IOException {
        return MetricRecordReader.readMetricsFile(chunk.getFilePath(), chunk.getBegin(), chunk.getEnd());
    }

    public static Vector<MetricProtos.EmrMetricRecord> readMetricsFile(String filename) throws IOException {
        return MetricRecordReader.readMetricsFile(filename, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<MetricProtos.EmrMetricRecord> readMetricsFile(String filePath, long beginOffset, long endOffset) throws IOException {
        try (MetricRecordReader reader = null;){
            reader = new MetricRecordReader(filePath, beginOffset, endOffset);
            Vector<MetricProtos.EmrMetricRecord> records = reader.readAll();
            logger.info(String.format("Read %4d records from %s [%d,%d)", records.size(), filePath, beginOffset, endOffset));
            Vector<MetricProtos.EmrMetricRecord> vector = records;
            return vector;
        }
    }
}

