/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.S3Path;
import com.google.gson.Gson;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfig {
    static Logger logger = LoggerFactory.getLogger(MetricsConfig.class);
    public static final String configRoot = "/mnt/var/run/metrics-server/";
    public static final String configFile = "/mnt/var/run/metrics-server/emr-metrics.config";
    public static boolean disableMetricSaver = false;
    public static boolean disableEngineCycle = false;
    public static boolean withinEmrJobFlow = true;
    public static int saverPeriodSec = 60;
    public static int systemMetricsPublishPeriodSec = 10;
    public static List<String> traceids = null;
    public final boolean hdfs;
    public final String rootDir;
    public final String rawDir;
    public final String aggDir;
    public final String rawChunkIndexFile;
    public final String aggChunkIndexFile;
    public final String engineStateFile;
    public final String s3UploadStateFile;
    public final String s3bucket;
    public final String s3root;
    public final String s3rawDir;
    public final String s3aggDir;
    public final String s3uploaderScratchDir;
    public final String enableMetricsFile;
    public final int LateArrivalWaitPeriodMilliSec = 120000;
    public final String instanceId;
    public final String jobFlowId;
    public final String masterInstanceId;
    private JobFlow jobflow;
    public static CACHE_LEVEL outputCacheLevel = CACHE_LEVEL.LOW;

    public MetricsConfig() {
        this(true, null);
    }

    public MetricsConfig(boolean useHDFS) {
        this(useHDFS, null);
    }

    public MetricsConfig(boolean useHDFS, String instanceIdToUse) {
        this.hdfs = useHDFS;
        this.rootDir = this.hdfs ? "hdfs:///mnt/var/lib/hadoop/metrics/" : "/mnt/var/lib/hadoop/metrics/";
        this.rawDir = MetricsConfig.CombinePath(this.rootDir, "raw");
        this.aggDir = MetricsConfig.CombinePath(this.rootDir, "agg");
        this.rawChunkIndexFile = MetricsConfig.CombinePath(this.rootDir, "raw_chunk_index.bin");
        this.aggChunkIndexFile = MetricsConfig.CombinePath(this.rootDir, "agg_chunk_index.bin");
        this.engineStateFile = MetricsConfig.CombinePath(this.rootDir, "engine_state.bin");
        this.s3UploadStateFile = MetricsConfig.CombinePath(this.rootDir, "s3_upload_state.bin");
        this.enableMetricsFile = MetricsConfig.CombinePath(this.rootDir, "enable_metrics.txt");
        this.instanceId = MetricsConfig.getInstanceId(instanceIdToUse);
        String JobFlowFile = "/mnt/var/lib/info/job-flow.json";
        String s1 = "j-NOTAJOBFLOW";
        String s2 = this.instanceId;
        try {
            String json = MetricsUtil.readFileAsString("/mnt/var/lib/info/job-flow.json");
            this.jobflow = (JobFlow)new Gson().fromJson(json, JobFlow.class);
            s1 = this.jobflow.jobFlowId;
            s2 = this.jobflow.masterInstanceId;
        }
        catch (Exception e) {
            logger.info("could NOT read {}, assume not within EMR cluster and disable MetricsSaver", (Object)"/mnt/var/lib/info/job-flow.json");
            disableMetricSaver = true;
            withinEmrJobFlow = false;
        }
        this.jobFlowId = s1;
        this.masterInstanceId = s2;
        this.s3bucket = "danzhi-test";
        this.s3root = S3Path.getPath(this.s3bucket, "metrics/" + this.jobFlowId);
        this.s3rawDir = S3Path.combine(this.s3root, "raw");
        this.s3aggDir = S3Path.combine(this.s3root, "agg");
        this.s3uploaderScratchDir = "/mnt/var/lib/metrics-server/s3uploader";
    }

    public String toString() {
        return String.format("root:%s period:%d instanceId:%s jobflow:%s", this.rootDir, saverPeriodSec, this.instanceId, this.jobFlowId);
    }

    private static String getInstanceId(String idToUse) {
        int index;
        if (idToUse == null) {
            idToUse = MetricsUtil.getInstanceId();
        }
        if ((index = idToUse.indexOf(58)) >= 0) {
            idToUse = idToUse.substring(0, index);
        }
        if (idToUse.length() > 40) {
            idToUse = idToUse.substring(0, 40);
        }
        return idToUse;
    }

    private static String CombinePath(String dir, String filename) {
        return new File(dir, filename).getPath();
    }

    public static class JobFlow {
        public String jobFlowId;
        public String jobFlowCreationInstant;
        public int instanceCount;
        public String masterInstanceId;
        public String masterPrivateDnsName;
        public String masterInstanceType;
        public String hadoopVersion;
        public InstanceGroup[] instanceGroups = null;

        public static class InstanceGroup {
            public String instanceGroupId;
            public String instanceGroupName;
            public String instanceRole;
            public String marketType;
            public String instanceType;
            public String requestedInstanceCount;
        }
    }

    public static enum CACHE_LEVEL {
        OFF,
        LOW,
        MEDIUM,
        HIGH;

    }
}

