/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.MetricsConfig;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.MetricsUtil;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MetricsProcessorBase {
    static final Logger logger = LoggerFactory.getLogger(MetricsProcessorBase.class);
    public final String instanceId;
    public final String process;
    public final String key;
    public final int interval;
    public final String id;
    public final MetricProtos.EmrMetricKey metricKey;
    final MetricsEngine engine;
    TreeMultimap<Long, MetricProtos.EmrMetricRecord> inputQueue;
    Vector<MetricProtos.EmrMetricRecord> inputCache;
    long inputCacheDuration;
    long inputCursor;
    TreeMap<Long, MetricProtos.EmrMetricRecord> outputCache;
    long outputCacheDuration;
    long outputCursor;
    long maxOutputTime;
    boolean traceme = false;
    int tracemecnt = 0;
    private static AtomicInteger scounter = new AtomicInteger();

    public MetricsProcessorBase(MetricsEngine engine, String instanceId, String process, String key, int interval) {
        this.engine = engine;
        this.instanceId = instanceId;
        this.process = process;
        this.key = key;
        this.interval = interval;
        this.metricKey = MetricsUtil.getEmrMetricKey(instanceId, process, key, interval);
        this.id = MetricsUtil.getStreamId(instanceId, process, key, interval);
        this.traceme = MetricsConfig.traceids != null && MetricsConfig.traceids.contains(this.id);
        this.inputQueue = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new CompareRecord());
        this.outputCache = new TreeMap();
        this.inputCache = new Vector();
        this.outputCacheDuration = MetricsEngine.getOutputCacheDuration(interval);
        this.inputCacheDuration = MetricsEngine.getInputCacheDuration(interval);
        MetricProtos.ProcessorState s = engine.getProcessorState(this.metricKey);
        this.inputCursor = s.getInputCursor();
        this.outputCursor = s.getOutputCursor();
        this.maxOutputTime = 0L;
        logger.info(String.format("%d Created %s ic: %d oc: %d", scounter.incrementAndGet(), this.id, this.inputCursor, this.outputCursor));
        engine.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInputRecord(MetricProtos.EmrMetricRecord r) {
        if (MetricsUtil.isEmpty(r)) {
            return false;
        }
        if (this.getInputAge(r) > 0L) {
            return false;
        }
        long rtime = MetricsUtil.getMaxTimeStamp(r);
        MetricsProcessorBase metricsProcessorBase = this;
        synchronized (metricsProcessorBase) {
            this.inputQueue.put((Object)rtime, (Object)r);
            if (this.traceme && ++this.tracemecnt % 10 == 0) {
                logger.info("{} addInputRecord {}", (Object)this.id, (Object)MetricsUtil.getMaxTimeStamp(r));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputRecord(MetricProtos.EmrMetricRecord r) {
        if (MetricsUtil.isEmpty(r)) {
            return;
        }
        if (this.getOutputAge(r) > 0L) {
            return;
        }
        long rtime = MetricsUtil.getMaxTimeStamp(r);
        MetricsProcessorBase metricsProcessorBase = this;
        synchronized (metricsProcessorBase) {
            this.outputCache.put(rtime, r);
            this.maxOutputTime = Math.max(this.maxOutputTime, rtime);
            if (this.traceme && ++this.tracemecnt % 10 == 0) {
                logger.info("{} addOutputRecord {}", (Object)this.id, (Object)rtime);
            }
        }
    }

    public abstract Vector<MetricProtos.EmrMetricRecord> process(long var1);

    public long getInputCursor() {
        return this.inputCursor;
    }

    protected void setInputCursor(long cursor) {
        this.inputCursor = cursor;
    }

    public String getId() {
        return this.id;
    }

    public long getOutputCursor() {
        return this.outputCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MetricProtos.EmrMetricRecord> getInputRecords() {
        Vector<MetricProtos.EmrMetricRecord> output = new Vector<MetricProtos.EmrMetricRecord>();
        MetricsProcessorBase metricsProcessorBase = this;
        synchronized (metricsProcessorBase) {
            output.addAll(this.inputCache);
            output.addAll(this.inputQueue.values());
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MetricProtos.EmrMetricRecord> getOutputRecords() {
        Vector<MetricProtos.EmrMetricRecord> output = new Vector<MetricProtos.EmrMetricRecord>();
        MetricsProcessorBase metricsProcessorBase = this;
        synchronized (metricsProcessorBase) {
            output.addAll(this.outputCache.values());
        }
        return output;
    }

    public MetricProtos.ProcessorState getState() {
        MetricProtos.ProcessorState.Builder sb = MetricProtos.ProcessorState.newBuilder();
        sb.setKey(this.metricKey);
        sb.setInputCursor(this.inputCursor);
        sb.setOutputCursor(this.outputCursor);
        if (this.traceme) {
            logger.info("{} getState ic: {}", (Object)this.id, (Object)this.inputCursor);
        }
        if (this.traceme) {
            logger.info("{} getState oc: {}", (Object)this.id, (Object)this.outputCursor);
        }
        return sb.build();
    }

    protected long getMinInputTime() {
        if (this.inputQueue.size() == 0) {
            return 0L;
        }
        long minKey = (Long)this.inputQueue.keySet().first();
        long min = 0L;
        for (MetricProtos.EmrMetricRecord r : this.inputQueue.get((Object)minKey)) {
            long time = MetricsUtil.getMinTimeStamp(r);
            if (min != 0L && time >= min) continue;
            min = time;
        }
        return min;
    }

    protected long getMaxInputTime() {
        if (this.inputQueue.size() == 0) {
            return 0L;
        }
        return (Long)this.inputQueue.keySet().last();
    }

    void removeExpiredRecords() {
        long time;
        long key;
        Vector<Long> expired = null;
        Iterator i$ = this.inputQueue.keySet().iterator();
        while (i$.hasNext() && (key = ((Long)i$.next()).longValue()) <= this.inputCursor) {
            if (expired == null) {
                expired = new Vector<Long>();
            }
            expired.add(key);
        }
        if (expired != null) {
            i$ = expired.iterator();
            while (i$.hasNext()) {
                key = (Long)i$.next();
                if (this.traceme) {
                    logger.info("{} expire input record {}", (Object)this.id, (Object)key);
                }
                this.inputQueue.removeAll((Object)key);
            }
        }
        if (this.outputCursor < this.maxOutputTime - this.outputCacheDuration) {
            this.outputCursor = this.maxOutputTime - this.outputCacheDuration;
            if (this.traceme) {
                logger.info("{} move up outputCursor {}", (Object)this.id, (Object)this.outputCursor);
            }
        }
        while (this.outputCache.size() > 0 && (time = this.outputCache.firstKey().longValue()) < this.outputCursor) {
            if (this.traceme) {
                logger.info("{} expire output record {}", (Object)this.id, (Object)time);
            }
            this.outputCache.remove(time);
        }
        while (this.inputCache.size() > 0 && this.getInputAge(this.inputCache.firstElement()) > this.inputCacheDuration) {
            this.inputCache.remove(0);
        }
    }

    long getInputAge(MetricProtos.EmrMetricRecord r) {
        return this.inputCursor - MetricsUtil.getMaxTimeStamp(r);
    }

    long getOutputAge(MetricProtos.EmrMetricRecord r) {
        return this.outputCursor - MetricsUtil.getMaxTimeStamp(r);
    }

    class CompareRecord
    implements Comparator<MetricProtos.EmrMetricRecord> {
        CompareRecord() {
        }

        @Override
        public int compare(MetricProtos.EmrMetricRecord r1, MetricProtos.EmrMetricRecord r2) {
            long v2;
            long t2;
            long t1 = MetricsUtil.getMaxTimeStamp(r1);
            if (t1 < (t2 = MetricsUtil.getMaxTimeStamp(r2))) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            long v1 = this.getFirstValue(r1);
            if (v1 < (v2 = this.getFirstValue(r2))) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        long getFirstValue(MetricProtos.EmrMetricRecord r) {
            if (r.getValuesCount() > 0) {
                return r.getValues(0).getValue();
            }
            if (r.getValuesExCount() > 0) {
                return (long)r.getValuesEx(0).getAverage();
            }
            return 0L;
        }
    }
}

