/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.MetricsSaver;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsSampleProducer
extends TimerTask {
    static final Logger logger = LoggerFactory.getLogger(MetricsSampleProducer.class);
    Random rand;
    int producedCount;

    public MetricsSampleProducer() {
        logger.info("MetricsSampleProducer started");
        this.rand = new Random();
        this.producedCount = 0;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)this, 0L, 1L);
    }

    @Override
    public void run() {
        try {
            this.producedCount += this.produceSeveral("SampleTestA");
            this.producedCount += this.produceSeveral("SampleTestB");
        }
        catch (Exception e) {
            logger.info("MetricsSampleProducer exception {}", (Throwable)e);
        }
    }

    public int getProducedCount() {
        return this.producedCount;
    }

    String getSampleError() {
        int value = this.rand.nextInt(6);
        if (value == 0) {
            return "SampleError1";
        }
        if (value <= 2) {
            return "SampleError2";
        }
        return "SampleError3";
    }

    int produceSeveral(String key) throws Exception {
        int count = this.rand.nextInt(2);
        int flavor = this.rand.nextInt(20);
        String context = "sample context";
        block7: for (int i = 0; i < count; ++i) {
            long value = this.getRandomInt();
            String error = this.getSampleError();
            switch (flavor) {
                case 0: {
                    MetricsSaver.addError(key, error);
                    continue block7;
                }
                case 1: {
                    MetricsSaver.addError(key, error, context);
                    continue block7;
                }
                case 2: {
                    MetricsSaver.addValueWithError(key, value, error);
                    continue block7;
                }
                case 3: {
                    MetricsSaver.addValueWithError(key, value, error, context);
                    continue block7;
                }
                case 4: {
                    MetricsSaver.addValue(key, value, context);
                }
                default: {
                    MetricsSaver.addValue(key, value);
                }
            }
        }
        return count;
    }

    int getRandomInt() {
        double mean = 1.0;
        double std = 0.6;
        double v = mean + std * this.rand.nextGaussian();
        if (v < 0.0) {
            v = 0.0;
        }
        return (int)(v * 1000.0);
    }
}

