/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.IntervalAggregator;
import amazon.emr.metrics.MetricsConfig;
import amazon.emr.metrics.MetricsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSaver
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(MetricsSaver.class);
    private MetricsConfig config;
    private String metricFile;
    private HashMap<String, MetricProtos.EmrMetricRecord.Builder> records;
    private FileOutputStream fileOutput;
    private FSDataOutputStream hdfsOutput;
    private static MetricsSaver instance = null;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
    private SystemMetricProducer systemProducer;
    private boolean needEnsureDir;
    private String processName;
    private static boolean metricsEnabledInCluster = true;
    private Boolean shutdownComplete;
    private boolean emrClusterStarted = false;
    private boolean emrClusterMapR = false;
    private StopWatch waitClusterStartWatch = new StopWatch();
    private StopWatch waitEnableFileWatch = new StopWatch();
    static int compactTraceCount = 0;

    public static void initialize(MetricsConfig config) throws Exception {
        MetricsSaver.ensureSingleton(config);
    }

    public static void initialize() throws Exception {
        MetricsSaver.ensureSingleton(null);
    }

    public static MetricsSaver singleton() throws Exception {
        MetricsSaver.ensureSingleton(null);
        return instance;
    }

    public static void addValue(String key, long value) {
        MetricsSaver.addInternal(key, value, null, null);
    }

    public static void addValue(String key, long value, String context) {
        MetricsSaver.addInternal(key, value, null, context);
    }

    public static void addError(String key, String error) {
        MetricsSaver.addInternal(key, null, error, null);
    }

    public static void addError(String key, String error, String context) {
        MetricsSaver.addInternal(key, null, error, context);
    }

    public static void addValueWithError(String key, long value, String error) {
        MetricsSaver.addInternal(key, value, error, null);
    }

    public static void addValueWithError(String key, long value, Exception e) {
        MetricsSaver.addInternal(key, value, e.getClass().toString(), null);
    }

    public static void addValueWithError(String key, long value, String error, String context) {
        MetricsSaver.addInternal(key, value, error, context);
    }

    protected MetricsSaver(MetricsConfig config) throws Exception {
        this.config = config;
        this.fileOutput = null;
        this.hdfsOutput = null;
        String baseFileName = String.format("%s_%5s_raw.bin", config.instanceId, MetricsUtil.getPid()).replace(' ', '0');
        this.metricFile = new File(config.rawDir, baseFileName).getPath();
        this.records = new HashMap();
        this.systemProducer = new SystemMetricProducer();
        if (MetricsConfig.saverPeriodSec > 0) {
            this.scheduler.scheduleAtFixedRate(this, MetricsConfig.saverPeriodSec, MetricsConfig.saverPeriodSec, TimeUnit.SECONDS);
        }
        if (MetricsConfig.systemMetricsPublishPeriodSec > 0) {
            this.scheduler.scheduleAtFixedRate(this.systemProducer, 45L, MetricsConfig.systemMetricsPublishPeriodSec, TimeUnit.SECONDS);
        }
        this.needEnsureDir = true;
        metricsEnabledInCluster = true;
        this.shutdownComplete = false;
        this.processName = MetricsUtil.getProcessMainClassName(true);
        if (this.processName == null) {
            this.processName = MetricsUtil.getPid();
        }
        logger.info("MetricsSaver {} {}", (Object)this.processName, (Object)config.toString());
        if (config.hdfs && MetricsConfig.withinEmrJobFlow) {
            this.emrClusterMapR = MetricsUtil.emrClusterMapR();
            if (this.emrClusterMapR) {
                metricsEnabledInCluster = false;
                logger.info("Disable MetricsSaver due to MapR cluster");
            }
        }
    }

    @Override
    public void run() {
        try {
            this.flush(true);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInternal(String key, Long value, String error, String context) {
        int maxErrorLength = 64;
        if (MetricsConfig.disableMetricSaver || !metricsEnabledInCluster) {
            return;
        }
        try {
            key.replace(':', '_');
            String simpleError = MetricsSaver.truncateError(error, 64);
            MetricsSaver.ensureSingleton(null);
            MetricsSaver metricsSaver = instance;
            synchronized (metricsSaver) {
                MetricProtos.EmrMetricRecord.Builder rb = instance.getMetricRecord(key);
                instance.addRecordValue(rb, value, simpleError, context);
            }
        }
        catch (Exception e) {
            logger.info("add metric {}", (Throwable)e);
        }
    }

    private static String truncateError(String error, int maxLen) {
        if (error == null || error.length() <= maxLen) {
            return error;
        }
        String e = error.substring(0, maxLen);
        int index = e.lastIndexOf(32, maxLen >> 1);
        return index > 0 ? e.substring(0, index) + " ..." : e;
    }

    protected MetricProtos.EmrMetricRecord.Builder getMetricRecord(String key) {
        MetricProtos.EmrMetricRecord.Builder rb = null;
        rb = this.records.get(key);
        if (rb != null) {
            return rb;
        }
        rb = MetricProtos.EmrMetricRecord.newBuilder();
        MetricProtos.EmrMetricKey.Builder kb = MetricProtos.EmrMetricKey.newBuilder();
        kb.setInstanceId(this.config.instanceId);
        kb.setProcess(this.processName);
        kb.setKey(key);
        kb.setInterval(0);
        rb.setKey(kb);
        this.records.put(key, rb);
        return rb;
    }

    protected void addRecordValue(MetricProtos.EmrMetricRecord.Builder rb, Long value, String error, String context) throws Exception {
        MetricProtos.EmrMetricRawValue.Builder vb = MetricProtos.EmrMetricRawValue.newBuilder();
        vb.setTime(System.currentTimeMillis());
        if (value != null) {
            vb.setValue(value);
        }
        if (error != null) {
            vb.setError(error);
        }
        if (context != null) {
            vb.setContext(context);
        }
        this.compactRawValues(rb, vb.getTime());
        rb.addValues(vb);
    }

    protected void compactRawValues(MetricProtos.EmrMetricRecord.Builder rb, long newTime) {
        int n = rb.getValuesCount();
        if (n < 50 || newTime / 1000L == rb.getValues(n - 1).getTime() / 1000L) {
            return;
        }
        List<MetricProtos.EmrMetricAggregatedValue> aggValues = IntervalAggregator.aggregateRawValues(rb.getValuesList());
        rb.clearValues();
        rb.addAllValuesEx(aggValues);
        if (++compactTraceCount % 100 == 1) {
            String message = String.format("aggregated %s %d raw values into %d aggregated values, total %d", rb.getKey().getKey(), n, aggValues.size(), rb.getValuesExCount());
            logger.info(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean withRetry) throws Exception {
        HashMap<String, MetricProtos.EmrMetricRecord.Builder> recordsToSave;
        boolean shouldFlush = this.checkShouldFlush();
        if (!shouldFlush) {
            return;
        }
        MetricsSaver metricsSaver = this;
        synchronized (metricsSaver) {
            recordsToSave = this.records;
            this.records = new HashMap();
        }
        if (recordsToSave.isEmpty()) {
            return;
        }
        Vector<MetricProtos.EmrMetricRecord> records = new Vector<MetricProtos.EmrMetricRecord>();
        for (MetricProtos.EmrMetricRecord.Builder rb : recordsToSave.values()) {
            records.add(rb.build());
        }
        int[] retries = new int[]{0, 1000, 2000, 4000, 8000, 16000};
        for (int i = 0; i < retries.length; ++i) {
            try {
                if (this.needEnsureDir) {
                    MetricsUtil.ensureDir(this.config.rootDir);
                    MetricsUtil.ensureDir(this.config.rawDir);
                    this.needEnsureDir = false;
                }
                if (retries[i] != 0) {
                    Thread.sleep(retries[i]);
                }
                this.openOutputStream(false);
                int count = records.size();
                int valueCount = 0;
                while (records.size() > 0) {
                    MetricProtos.EmrMetricRecord r = (MetricProtos.EmrMetricRecord)records.firstElement();
                    MetricProtos.EmrMetricRecord r2 = IntervalAggregator.aggregateRawValues(r, 50);
                    r2.writeDelimitedTo((OutputStream)(this.config.hdfs ? this.hdfsOutput : this.fileOutput));
                    valueCount += r2.getValuesCount() + r2.getValuesExCount();
                    records.remove(0);
                }
                logger.info(String.format("Saved %d:%d records to %s", count, valueCount, this.metricFile));
                break;
            }
            catch (IllegalStateException ex) {
                break;
            }
            catch (Exception e) {
                logger.error("Failed SaveRecords {} {}", (Object)this.metricFile, (Object)e.getMessage());
                if (withRetry) continue;
                break;
            }
            finally {
                this.closeOutputStream();
            }
        }
        if (records.size() != 0) {
            logger.info("Discard {} records", (Object)records.size());
        }
    }

    private boolean checkShouldFlush() {
        boolean enabled;
        block10: {
            if (MetricsConfig.disableMetricSaver) {
                return false;
            }
            if (this.config.hdfs && this.emrClusterMapR) {
                return false;
            }
            if (!this.emrClusterStarted && this.config.hdfs) {
                if (!MetricsUtil.emrClusterStarted()) {
                    if (this.records.size() > 0) {
                        logger.info("Wait for instance controller started to flush {} records", (Object)this.records.size());
                        if (this.waitClusterStartWatch.elapsedSeconds() > 3600L) {
                            logger.info("Give up {} records waiting for instance controller", (Object)this.records.size());
                            this.records.clear();
                        }
                    }
                    return false;
                }
                this.waitClusterStartWatch.stop();
                this.emrClusterStarted = true;
            }
            enabled = metricsEnabledInCluster;
            try {
                enabled = MetricsUtil.fileExists(this.config.enableMetricsFile);
                this.waitEnableFileWatch.reset();
            }
            catch (Exception e) {
                logger.info("fileExists failed {}", (Object)this.config.enableMetricsFile);
                if (this.records.size() <= 0 || this.waitEnableFileWatch.elapsedSeconds() <= 3600L) break block10;
                logger.info("Give up {} records waiting for HDFS", (Object)this.records.size());
                this.records.clear();
            }
        }
        if (enabled != metricsEnabledInCluster) {
            metricsEnabledInCluster = enabled;
            logger.info("EMR metrics is {}abled", (Object)(enabled ? "en" : "dis"));
        }
        if (this.records.isEmpty()) {
            return false;
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureSingleton(MetricsConfig config) throws Exception {
        if (instance != null) return;
        Class<MetricsSaver> clazz = MetricsSaver.class;
        synchronized (MetricsSaver.class) {
            MetricsSaver s;
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (config == null) {
                config = new MetricsConfig(true);
            }
            instance = s = new MetricsSaver(config);
            ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

                @Override
                public void run() {
                    MetricsSaver.shutdown();
                }
            }, 20);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performShutdown() {
        logger.info("Inside MetricsSaver Shutdown Hook");
        try {
            Boolean bl = this.shutdownComplete;
            synchronized (bl) {
                if (!this.shutdownComplete.booleanValue()) {
                    instance.flush(false);
                    this.shutdownComplete = true;
                } else {
                    logger.info("Shutdown already completed");
                }
            }
        }
        catch (IllegalStateException ex) {
            logger.info("Error while flushing {}", (Object)ex.getMessage());
        }
        catch (Exception e) {
            logger.info("Error while flushing", (Throwable)e);
        }
    }

    public static void shutdown() {
        if (instance != null) {
            instance.performShutdown();
        }
    }

    private void openOutputStream(boolean forceReopen) throws Exception {
        if (forceReopen) {
            this.closeOutputStream();
        }
        if (this.config.hdfs) {
            Path path;
            if (this.hdfsOutput != null) {
                return;
            }
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            this.hdfsOutput = hdfs.exists(path = new Path(this.metricFile)) ? hdfs.append(path) : hdfs.create(path);
        } else {
            if (this.fileOutput != null) {
                return;
            }
            this.fileOutput = new FileOutputStream(this.metricFile, true);
        }
    }

    private void closeOutputStream() throws Exception {
        if (this.config.hdfs) {
            if (this.hdfsOutput != null) {
                this.hdfsOutput.close();
            }
            this.hdfsOutput = null;
        } else {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
            this.fileOutput = null;
        }
    }

    static class SystemMetricProducer
    implements Runnable {
        private MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        private List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

        SystemMetricProducer() {
        }

        @Override
        public void run() {
            MetricsSaver.addValue("DaemonThreadCount", this.threadBean.getDaemonThreadCount());
            MetricsSaver.addValue("ThreadCount", this.threadBean.getThreadCount());
            MemoryUsage memoryUsage = this.memoryBean.getHeapMemoryUsage();
            MetricsSaver.addValue("HeapMemoryUsage", memoryUsage.getUsed());
            MetricsSaver.addValue("HeapMemoryMax", memoryUsage.getMax());
            MetricsSaver.addValue("HeapMemoryCommitted", memoryUsage.getCommitted());
            long collectionTime = 0L;
            long collectionCount = 0L;
            for (GarbageCollectorMXBean gcBean : this.gcBeans) {
                long t = gcBean.getCollectionTime();
                long c = gcBean.getCollectionCount();
                if (t >= 0L) {
                    collectionTime += t;
                }
                if (c < 0L) continue;
                collectionCount += c;
            }
            MetricsSaver.addValue("GCTime", collectionTime);
            MetricsSaver.addValue("GCCount", collectionCount);
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class StopWatch {
        long start;
        long stop;
        boolean stopped;

        public StopWatch() {
            this.reset();
        }

        public void reset() {
            this.start = System.currentTimeMillis();
            this.stopped = false;
            this.stop = 0L;
        }

        public void stop() {
            this.stopped = true;
            this.stop = System.currentTimeMillis();
        }

        public long elapsedTime() {
            return this.stopped ? this.stop - this.start : System.currentTimeMillis() - this.start;
        }

        public long elapsedSeconds() {
            return this.elapsedTime() / 1000L;
        }
    }
}

