/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.AdhocTest;
import amazon.emr.metrics.ChunkUtil;
import amazon.emr.metrics.MetricsConfig;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.MetricsReader;
import amazon.emr.metrics.MetricsSampleProducer;
import amazon.emr.metrics.MetricsSaver;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.PidFileLock;
import amazon.emr.metrics.TestS3ChunkStream;
import amazon.emr.metrics.WebServerHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.log4j.PropertyConfigurator;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartcliparser.CommandLineProgram;
import org.smartcliparser.Flag;

public class MetricsServer {
    static final Logger logger = LoggerFactory.getLogger(MetricsServer.class);
    static final int serverPort = 8327;
    static Random random = new Random();

    public static void runForever(MetricsConfig config) throws Exception {
        logger.info("Check whether metrics server port {} is available", (Object)8327);
        MetricsServer.checkPortAvailability(8327);
        MetricsSaver.initialize(config);
        MetricsEngine engine = new MetricsEngine(config);
        String serverId = MetricsUtil.getHostName() + ":" + 8327;
        logger.info("starting MetricsServer {}", (Object)serverId);
        try {
            Server server = new Server(8327);
            server.setHandler((Handler)new WebServerHandler(engine));
            server.start();
            logger.info("Started metrics server {}", (Object)serverId);
            server.join();
            logger.info("Exit metrics server {}", (Object)serverId);
        }
        catch (Exception e) {
            engine.shutdown();
            System.exit(0);
        }
    }

    public static void usageAndExit() {
        System.out.println("Amazon EMR Metric Server Utility Usage Examples:");
        System.out.println("  1. metrics-server --ls");
        System.out.println("     List all metric files recursively under the metrics root dir");
        System.out.println("  2. metrics-server --read hdfs:/mnt/var/lib/hadoop/metrics/raw/i-e987e18c_13462_raw.bin");
        System.out.println("     Read specified metric file (raw, chunk_history, engine_state etc)");
        System.out.println("  3. metrics-server --read hdfs:/mnt/var/lib/hadoop/metrics/agg/output_005.bin \\");
        System.out.println("     --filter pseudo-2:MetricsServer:HeapMemoryUsage:10");
        System.out.println("     Read specified metric file with the specific filter");
        System.out.println("  4. metrics-server --enable");
        System.out.println("     Enable metrics within the cluster.");
        System.out.println("  5. metrics-server --disable");
        System.out.println("     Disable metrics within the cluster.");
        System.out.println("");
        System.exit(0);
    }

    static boolean isCommand(String[] args, String cmd) {
        return args[0].equals(cmd) || args[0].equals("-" + cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPortAvailability(int port) throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(port);
        }
    }

    private static void configLog4j() throws IOException {
        if (!MetricsUtil.fileExists("/mnt/var/run/metrics-server/emr-metrics.config")) {
            System.out.format("Extract %s\n", "/mnt/var/run/metrics-server/emr-metrics.config");
            MetricsUtil.ensureDir("/mnt/var/run/metrics-server/");
            MetricsUtil.extractMetricsJarFile("emr-metrics.config", "/mnt/var/run/metrics-server/");
        }
        if (MetricsUtil.fileExists("/mnt/var/run/metrics-server/emr-metrics.config")) {
            PropertyConfigurator.configure((String)"/mnt/var/run/metrics-server/emr-metrics.config");
            logger.info("Configured log4j with {}", (Object)"/mnt/var/run/metrics-server/emr-metrics.config");
        } else {
            logger.info("Use default log4j configuration due to missing {}", (Object)"/mnt/var/run/metrics-server/emr-metrics.config");
        }
    }

    static void enableMetrics(MetricsConfig config) throws IOException {
        if (!MetricsUtil.fileExists(config.enableMetricsFile)) {
            System.out.format("Create %s\n", config.enableMetricsFile);
            MetricsUtil.ensureDir(config.rootDir);
            MetricsUtil.writeStringToFile("1", config.enableMetricsFile);
        } else {
            System.out.format("Detected %s\n", config.enableMetricsFile);
        }
        String runFile = "/mnt/var/lib/metrics-server/run-metrics-server";
        if (!MetricsUtil.fileExists("/mnt/var/lib/metrics-server/run-metrics-server")) {
            System.out.format("Create %s with content 1\n", "/mnt/var/lib/metrics-server/run-metrics-server");
            MetricsUtil.ensureDir("/mnt/var/lib/metrics-server");
            MetricsUtil.writeStringToFile("1", "/mnt/var/lib/metrics-server/run-metrics-server");
        } else {
            String content = MetricsUtil.readFileAsString("/mnt/var/lib/metrics-server/run-metrics-server");
            if (!content.equals("1")) {
                MetricsUtil.writeStringToFile("1", "/mnt/var/lib/metrics-server/run-metrics-server");
                content = MetricsUtil.readFileAsString("/mnt/var/lib/metrics-server/run-metrics-server");
            }
            System.out.format("Ensured %s content is %s\n", "/mnt/var/lib/metrics-server/run-metrics-server", content);
        }
    }

    static void disableMetrics(MetricsConfig config) throws IOException {
        if (MetricsUtil.fileExists(config.enableMetricsFile)) {
            boolean result = MetricsUtil.deleteFile(config.enableMetricsFile);
            System.out.format("Delete %s %s\n", config.enableMetricsFile, result ? "success" : "failed");
        } else {
            System.out.format("Not found %s\n", config.enableMetricsFile);
        }
        String runFile = "/mnt/var/lib/metrics-server/run-metrics-server";
        if (MetricsUtil.fileExists("/mnt/var/lib/metrics-server/run-metrics-server")) {
            String content = MetricsUtil.readFileAsString("/mnt/var/lib/metrics-server/run-metrics-server");
            if (content.equals("1")) {
                MetricsUtil.writeStringToFile("0", "/mnt/var/lib/metrics-server/run-metrics-server");
                content = MetricsUtil.readFileAsString("/mnt/var/lib/metrics-server/run-metrics-server");
            }
            System.out.format("Ensured %s content is %s\n", "/mnt/var/lib/metrics-server/run-metrics-server", content);
        } else {
            System.out.format("Not found %s\n", "/mnt/var/lib/metrics-server/run-metrics-server");
        }
    }

    static void runAsServer(MetricsServerArgs args, MetricsConfig config) {
        try {
            MetricsConfig.disableMetricSaver = false;
            if (args.cachelevel.isSet()) {
                String value = (String)args.cachelevel.args.get(0);
                MetricsConfig.CACHE_LEVEL level = MetricsConfig.CACHE_LEVEL.LOW;
                boolean match = false;
                for (MetricsConfig.CACHE_LEVEL v : MetricsConfig.CACHE_LEVEL.values()) {
                    if (!value.equalsIgnoreCase(v.toString())) continue;
                    level = v;
                    match = true;
                    break;
                }
                if (!match) {
                    logger.info("unknown cache_level ", (Object)level);
                }
                logger.info("cache_level set to be {}", (Object)level);
                MetricsConfig.outputCacheLevel = level;
            }
            if (args.traceid.isSet()) {
                MetricsConfig.traceids = args.traceid.args;
            }
            logger.info("Try to start metrics-server");
            if (!config.instanceId.equalsIgnoreCase(config.masterInstanceId)) {
                logger.error("Metrics server MUST run on master instance {}", (Object)config.masterInstanceId);
                Thread.sleep(1000L);
                System.exit(0);
            }
            String pidfile = args.pidfile.isSet() ? (String)args.pidfile.args.get(0) : null;
            PidFileLock lock = new PidFileLock(pidfile);
            MetricsUtil.ensureDir(config.rootDir);
            MetricsUtil.ensureDir(config.rawDir);
            if (!args.nosaver.isSet()) {
                MetricsSaver.initialize(config);
            }
            if (args.readonly.isSet()) {
                MetricsConfig.disableEngineCycle = true;
            }
            MetricsServer.runForever(config);
            lock.release();
        }
        catch (Exception ex) {
            logger.error("runAsServer failed: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static final boolean consoleReadYesNo(String prompt) throws IOException {
        System.out.print(prompt);
        char c = (char)System.in.read();
        return c == 'Y' || c == 'y';
    }

    public static void main(String[] rawargs) throws Exception {
        if (rawargs.length == 0) {
            MetricsServer.usageAndExit();
        }
        MetricsServerArgs args = new MetricsServerArgs(rawargs);
        MetricsServer.configLog4j();
        String hostname = MetricsUtil.getHostName();
        boolean useHDFS = !hostname.contains("desktop.amazon.com");
        MetricsConfig config = new MetricsConfig(useHDFS);
        MetricsConfig.disableMetricSaver = true;
        if (args.read.isSet()) {
            String filter = args.filter.isSet() ? (String)args.filter.args.get(0) : null;
            for (String v : args.read.args) {
                MetricsReader.readMetricsFile(v, filter);
            }
        } else if (args.ls.isSet()) {
            if (args.ls.args.size() == 0) {
                MetricsReader.showDirFileRecursive(config.rootDir);
            } else {
                for (String v : args.ls.args) {
                    Thread.sleep(1000L);
                    MetricsSaver.addValue("TestPinterest", 100L);
                    logger.info("Will do GC collection in 100 seconds");
                    Thread.sleep(100000L);
                    logger.info("Force Garbage Collection");
                    System.gc();
                    logger.info("Wait forever until termination");
                    if (v.startsWith("s3:")) {
                        ChunkUtil.showS3Recursive(v);
                        continue;
                    }
                    MetricsReader.showDirFileRecursive(v);
                }
            }
        } else if (args.producer.isSet()) {
            MetricsConfig.disableMetricSaver = false;
            if (args.producer.args.size() > 0) {
                config = new MetricsConfig(useHDFS, (String)args.producer.args.get(0));
            }
            MetricsSaver.initialize(config);
            new MetricsSampleProducer();
            Thread.sleep(Long.MAX_VALUE);
        } else if (args.resetreset.isSet()) {
            boolean confirmed = MetricsServer.consoleReadYesNo("Reset metrics data [Y or N]?:");
            if (confirmed) {
                boolean enabled = MetricsUtil.fileExists(config.enableMetricsFile);
                MetricsUtil.backupDirAndRecreate(config.rootDir);
                if (enabled) {
                    MetricsServer.enableMetrics(config);
                }
            }
        } else if (args.enable.isSet()) {
            MetricsServer.enableMetrics(config);
        } else if (args.disable.isSet()) {
            MetricsServer.disableMetrics(config);
        } else if (args.server.isSet()) {
            MetricsServer.runAsServer(args, config);
        } else if (args.s3test.isSet()) {
            TestS3ChunkStream test = new TestS3ChunkStream();
            test.run(config);
        } else if (args.test.isSet()) {
            MetricsConfig.disableMetricSaver = false;
            AdhocTest.run(rawargs);
        } else {
            MetricsServer.usageAndExit();
        }
    }

    static class MetricsServerArgs
    extends CommandLineProgram {
        public Flag server;
        public Flag read;
        public Flag ls;
        public Flag pidfile;
        public Flag filter;
        public Flag producer;
        public Flag resetreset;
        public Flag enable;
        public Flag disable;
        public Flag readonly;
        public Flag nosaver;
        public Flag s3test;
        public Flag traceid;
        public Flag test;
        public Flag cachelevel;

        public MetricsServerArgs(String[] args) {
            super(args);
        }

        public void initialize() {
            this.server = this.newFlag("server", 0, 0);
            this.read = this.newFlag("read", 1, 100);
            this.ls = this.newFlag("ls", 0, 100);
            this.pidfile = this.newFlag("pidfile", 1, 1);
            this.filter = this.newFlag("filter", 0, 1);
            this.producer = this.newFlag("producer", 0, 1);
            this.resetreset = this.newFlag("resetreset", 0, 0);
            this.enable = this.newFlag("enable", 0, 0);
            this.disable = this.newFlag("disable", 0, 0);
            this.readonly = this.newFlag("readonly", 0, 0);
            this.nosaver = this.newFlag("nosaver", 0, 0);
            this.s3test = this.newFlag("s3test", 0, 0);
            this.traceid = this.newFlag("traceid", 1, 100);
            this.test = this.newFlag("test", 0, 100);
            this.cachelevel = this.newFlag("cache_level", 1, 1);
            this.registerFlag(this.server);
            this.registerFlag(this.read);
            this.registerFlag(this.ls);
            this.registerFlag(this.pidfile);
            this.registerFlag(this.filter);
            this.registerFlag(this.producer);
            this.registerFlag(this.resetreset);
            this.registerFlag(this.enable);
            this.registerFlag(this.disable);
            this.registerFlag(this.readonly);
            this.registerFlag(this.nosaver);
            this.registerFlag(this.s3test);
            this.registerFlag(this.traceid);
            this.registerFlag(this.test);
            this.registerFlag(this.cachelevel);
        }

        public void run() {
        }

        private Flag newFlag(String name, int minArgs, int maxArgs) {
            return new Flag(new String[]{name}, false, minArgs, maxArgs);
        }
    }
}

