/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.FileType;
import amazon.emr.metrics.InstanceControllerRpcClient;
import amazon.emr.metrics.S3Path;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsUtil {
    static final Logger logger = LoggerFactory.getLogger(MetricsUtil.class);
    static String instanceId = null;

    static FileType getFileType(String path) {
        if (path.startsWith("hdfs:/")) {
            return FileType.HDFS;
        }
        return FileType.LOCAL;
    }

    public static String getPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static String getPathName(FileStatus s) {
        return "hdfs:" + s.getPath().toUri().getPath();
    }

    public static String getTimeStr(long milliseconds) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS aa");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return formatter.format(calendar.getTime());
    }

    public static boolean fileExists(String filename) throws IOException {
        if (MetricsUtil.getFileType(filename) == FileType.HDFS) {
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            return hdfs.exists(new Path(filename));
        }
        File file = new File(filename);
        return file.exists();
    }

    public static boolean deleteFile(String filename) throws IOException {
        if (MetricsUtil.getFileType(filename) == FileType.HDFS) {
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            return hdfs.delete(new Path(filename), false);
        }
        File file = new File(filename);
        return file.delete();
    }

    public static long getAgeMs(long time) {
        return System.currentTimeMillis() - time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstanceId() {
        if (instanceId != null) {
            return instanceId;
        }
        String hostname = MetricsUtil.getHostName();
        String instance = MetricsUtil.getFakeInstanceIdFromHost(hostname);
        if (!hostname.contains("desktop.amazon.com")) {
            int timeout = hostname.contains(".ec2.internal") ? 30000 : 2000;
            String url = "http://169.254.169.254/latest/meta-data/instance-id";
            GetMethod getMethod = new GetMethod("http://169.254.169.254/latest/meta-data/instance-id");
            try {
                SimpleHttpConnectionManager manager = new SimpleHttpConnectionManager();
                HttpConnectionManagerParams params = manager.getParams();
                params.setConnectionTimeout(timeout);
                params.setSoTimeout(timeout);
                HttpClient httpClient = new HttpClient((HttpConnectionManager)manager);
                int status = httpClient.executeMethod((HttpMethod)getMethod);
                if (status < 200 || status > 299) {
                    logger.info("error status code {} GET {}", (Object)status, (Object)"http://169.254.169.254/latest/meta-data/instance-id");
                } else {
                    instance = getMethod.getResponseBodyAsString().replace(':', '_');
                }
            }
            catch (Exception e) {
                logger.info("GET {} exception {}", (Object)"http://169.254.169.254/latest/meta-data/instance-id", (Object)e);
            }
            finally {
                getMethod.releaseConnection();
            }
        }
        instanceId = instance;
        return instance;
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    private static String getFakeInstanceIdFromHost(String host) {
        host.replace(':', '_');
        int dotIndex = host.indexOf(46);
        return dotIndex > 0 ? host.substring(0, dotIndex) : host;
    }

    public static String getStr(MetricProtos.FileChunk chunk) {
        return String.format("%s [%d,%d)", chunk.getFilePath(), chunk.getBegin(), chunk.getEnd());
    }

    public static long getMinTimeStamp(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            return r.getValues(0).getTime();
        }
        if (r.getValuesExCount() > 0) {
            return r.getValuesEx(0).getStart();
        }
        return 0L;
    }

    public static long getMaxTimeStamp(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            return r.getValues(r.getValuesCount() - 1).getTime();
        }
        if (r.getValuesExCount() > 0) {
            return r.getValuesEx(r.getValuesExCount() - 1).getStop() - 1L;
        }
        return 0L;
    }

    public static long getDuration(MetricProtos.EmrMetricRecord r) {
        return MetricsUtil.getMaxTimeStamp(r) - MetricsUtil.getMinTimeStamp(r);
    }

    public static boolean isEmpty(MetricProtos.EmrMetricRecord r) {
        return r.getValuesCount() == 0 && r.getValuesExCount() == 0;
    }

    public static String getStreamId(String instanceId, String process, String key, int interval) {
        return String.format("%s:%s:%s:%d", instanceId, process, key, interval);
    }

    public static String getStreamId(MetricProtos.EmrMetricKey key) {
        return String.format("%s:%s:%s:%d", key.getInstanceId(), key.getProcess(), key.getKey(), key.getInterval());
    }

    public static String getInstanceFromId(String id) {
        String[] parts = id.split(":");
        return parts[0];
    }

    public static String getProcessFromId(String id) {
        String[] parts = id.split(":");
        return parts[1];
    }

    public static String getKeyFromId(String id) {
        String[] parts = id.split(":");
        return parts[2];
    }

    public static MetricProtos.EmrMetricKey tryGetEmrMetricKeyFromId(String id) {
        try {
            return MetricsUtil.getEmrMetricKeyFromId(id);
        }
        catch (Exception e) {
            logger.info("Invalid id {}", (Object)id);
            return null;
        }
    }

    public static MetricProtos.EmrMetricKey getEmrMetricKeyFromId(String id) {
        String[] parts = id.split(":");
        MetricProtos.EmrMetricKey.Builder b = MetricProtos.EmrMetricKey.newBuilder();
        b.setInstanceId(parts[0]);
        b.setProcess(parts[1]);
        b.setKey(parts[2]);
        b.setInterval(Integer.parseInt(parts[3]));
        return b.build();
    }

    public static MetricProtos.EmrMetricKey getEmrMetricKey(String instanceId, String process, String key, int interval) {
        MetricProtos.EmrMetricKey.Builder b = MetricProtos.EmrMetricKey.newBuilder();
        b.setInstanceId(instanceId);
        b.setProcess(process);
        b.setKey(key);
        b.setInterval(interval);
        return b.build();
    }

    public static boolean backupFileAndRecreate(String filename, long sizeLimit) throws IOException {
        String filenameBackup = filename + ".old";
        if (MetricsUtil.getFileType(filename) == FileType.HDFS) {
            Path path;
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            if (!hdfs.exists(path = new Path(filename))) {
                return false;
            }
            FileStatus status = hdfs.getFileStatus(path);
            if (status.getLen() < sizeLimit) {
                return false;
            }
            Path pathBackup = new Path(filenameBackup);
            if (hdfs.exists(pathBackup)) {
                hdfs.delete(pathBackup, false);
            }
            hdfs.rename(path, pathBackup);
        } else {
            File file = new File(filename);
            if (!file.exists()) {
                return false;
            }
            if (file.length() < sizeLimit) {
                return false;
            }
            File fileBackup = new File(filenameBackup);
            if (fileBackup.exists()) {
                fileBackup.delete();
                fileBackup = new File(filenameBackup);
            }
            file.renameTo(fileBackup);
        }
        logger.info("simpleBackupAndReset {} to {}", (Object)filename, (Object)filenameBackup);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(filePath));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public static String readInputStreamToString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    public static void backupDirAndRecreate(String dir) throws IOException {
        logger.info("backupDirAndRecreate {}", (Object)dir);
        if (MetricsUtil.fileExists(dir)) {
            String backupDir = MetricsUtil.getBackupDir(dir);
            logger.info("renamed {} to {}", (Object)dir, (Object)backupDir);
            if (MetricsUtil.getFileType(dir) == FileType.HDFS) {
                Configuration config = new Configuration();
                FileSystem hdfs = FileSystem.get((Configuration)config);
                Path src = new Path(dir);
                Path dst = new Path(backupDir);
                hdfs.rename(src, dst);
            } else {
                File file = new File(dir);
                file.renameTo(new File(backupDir));
            }
        }
        MetricsUtil.ensureDir(dir);
    }

    private static String getBackupDir(String dir) throws IOException {
        File root = new File(dir);
        String srcName = root.getName();
        Calendar c = Calendar.getInstance();
        String backName = String.format("%s%02d%02d", srcName, c.get(2) + 1, c.get(5));
        String backupDir = new File(root.getParent(), backName).getPath();
        if (MetricsUtil.fileExists(backupDir)) {
            for (int i = 0; i < 26; ++i) {
                String backupDir2 = backupDir + (char)(65 + i);
                if (MetricsUtil.fileExists(backupDir2)) continue;
                return backupDir2;
            }
        }
        return backupDir;
    }

    public static void ensureDir(String dir) throws IOException {
        boolean success = false;
        if (MetricsUtil.getFileType(dir) == FileType.HDFS) {
            Path path;
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            if (!hdfs.exists(path = new Path(dir))) {
                success = hdfs.mkdirs(path, new FsPermission(511));
                hdfs.setPermission(path, new FsPermission(511));
                if (!success) {
                    logger.info("mkdir {} {}", (Object)dir, (Object)success);
                }
            } else {
                FileStatus fs = hdfs.getFileStatus(path);
                short umask = fs.getPermission().toShort();
                if (umask != 511) {
                    hdfs.setPermission(path, new FsPermission(511));
                    logger.info("setPermission {}", (Object)dir);
                }
            }
        } else {
            File file = new File(dir);
            if (!file.exists()) {
                MetricsUtil.ensureDir(file.getParent());
                success = file.mkdir();
                if (!success) {
                    logger.info("mkdir {} {}", (Object)dir, (Object)success);
                }
            }
        }
    }

    public static String getEmrMetricsJarFile() {
        String jarFileStandalone = "/usr/share/aws/emr/emr-metrics/lib/EmrMetrics-1.0.jar";
        if (new File("/usr/share/aws/emr/emr-metrics/lib/EmrMetrics-1.0.jar").exists()) {
            return "/usr/share/aws/emr/emr-metrics/lib/EmrMetrics-1.0.jar";
        }
        String jarFileOld = "/home/hadoop/lib/emr-metrics-1.0.jar";
        String jarFileNew = "/home/hadoop/lib/EmrMetrics-1.0.jar";
        return new File("/home/hadoop/lib/emr-metrics-1.0.jar").exists() ? "/home/hadoop/lib/emr-metrics-1.0.jar" : "/home/hadoop/lib/EmrMetrics-1.0.jar";
    }

    public static boolean extractMetricsJarFile(String file, String outputDir) throws IOException {
        String jarFile = MetricsUtil.getEmrMetricsJarFile();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (!e.getName().equals(file)) continue;
            String outputFullPath = new File(outputDir, file).getPath();
            MetricsUtil.writeInputStreamToFile(jar.getInputStream(e), outputFullPath);
            return true;
        }
        return false;
    }

    public static String extractMetricsJarFileAsString(String file) throws IOException {
        String jarFile = MetricsUtil.getEmrMetricsJarFile();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (!e.getName().equals(file)) continue;
            return MetricsUtil.readInputStreamToString(jar.getInputStream(e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToFile(InputStream in, String path) throws IOException {
        try (OutputStream outStream = null;){
            outStream = new FileOutputStream(new File(path));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                outStream.write(bytes, 0, read);
            }
            outStream.flush();
        }
    }

    public static void writeStringToFile(String data, String filePath) throws IOException {
        if (MetricsUtil.getFileType(filePath) == FileType.HDFS) {
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            Path path = new Path(filePath);
            FSDataOutputStream output = hdfs.create(path, true);
            output.writeBytes(data);
            output.close();
        } else {
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
            out.write(data);
            out.close();
        }
    }

    public static String getProcessMainClassName(boolean shortname) {
        StackTraceElement frame;
        StackTraceElement[] frames;
        Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
        for (Thread t : stackTraceMap.keySet()) {
            if (!"main".equals(t.getName()) || (frames = stackTraceMap.get(t)) == null || frames.length <= 0 || !"main".equals((frame = frames[frames.length - 1]).getMethodName())) continue;
            return MetricsUtil.getClassNameHelper(frame.getClassName(), shortname);
        }
        for (Thread t : stackTraceMap.keySet()) {
            frames = stackTraceMap.get(t);
            if (frames == null || frames.length <= 0 || !"main".equals((frame = frames[frames.length - 1]).getMethodName())) continue;
            return MetricsUtil.getClassNameHelper(frame.getClassName(), shortname);
        }
        return null;
    }

    private static String getClassNameHelper(String name, boolean shortname) {
        String[] parts = name.split("\\.");
        int len = parts.length;
        if (!shortname || len <= 1) {
            return name;
        }
        return parts[len - 1].equals("Main") || parts[len - 1].equals("main") ? parts[len - 2] : parts[len - 1];
    }

    public static long getFileLength(String filename) throws IOException {
        if (MetricsUtil.getFileType(filename) == FileType.HDFS) {
            Path path;
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            if (!hdfs.exists(path = new Path(filename))) {
                return 0L;
            }
            FileStatus status = hdfs.getFileStatus(path);
            return status.getLen();
        }
        File file = new File(filename);
        return file.exists() ? file.length() : 0L;
    }

    public static String combinePath(String path, String child) {
        return path.startsWith("s3://") ? S3Path.combine(path, child) : new File(path, child).getPath();
    }

    public static List<String> recursivelyGetAllFiles(String dir) {
        ArrayList<String> output = new ArrayList<String>();
        if (dir == null) {
            return output;
        }
        File folder = new File(dir);
        if (!folder.exists()) {
            return output;
        }
        if (!folder.isDirectory()) {
            output.add(dir);
        } else {
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    output.addAll(MetricsUtil.recursivelyGetAllFiles(files[i].getPath()));
                    continue;
                }
                output.add(files[i].getPath());
            }
        }
        return output;
    }

    public static void recursivelyDeleteFolder(String path) {
        File folder = new File(path);
        if (folder.isDirectory()) {
            File[] files;
            for (File f : files = folder.listFiles()) {
                if (f.isDirectory()) {
                    MetricsUtil.recursivelyDeleteFolder(f.getPath());
                    f.delete();
                    continue;
                }
                logger.info("delete {}", (Object)f.getPath());
                f.delete();
            }
        }
    }

    public static boolean emrClusterStarted() {
        try {
            InstanceControllerRpcClient proxy = new InstanceControllerRpcClient();
            InstanceControllerRpcClient.PingResponse response = proxy.ping();
            logger.info("instance controller state {}", (Object)response.localStartupState);
            return response.localStartupState.equals("completed");
        }
        catch (Exception e) {
            logger.info("Could NOT ping instance controller");
            return false;
        }
    }

    public static boolean emrClusterMapR() {
        try {
            InstanceControllerRpcClient proxy = new InstanceControllerRpcClient();
            InstanceControllerRpcClient.SupportedProducts products = proxy.getSupportedProducts();
            boolean mapr = false;
            for (String p : products.supportedProducts) {
                logger.info("supported product {}", (Object)p);
                if (!p.startsWith("mapr-")) continue;
                mapr = true;
            }
            return mapr;
        }
        catch (Exception e) {
            logger.info("getSupportedProducts {}", (Throwable)e);
            return false;
        }
    }

    public static boolean isDesktopMachine() {
        return MetricsUtil.getHostName().indexOf("desktop.amazon.com") >= 0;
    }
}

