/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.FileType;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.RecordWriter;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutputChunkWriter {
    static final Logger logger = LoggerFactory.getLogger(OutputChunkWriter.class);
    static final long FileSizeLimit = 0x8000000L;
    String dir;
    final String prefix = "output_";
    int fileIndex;
    String outputFile;
    String chunkHistoryFile;
    FileType type;
    RecordWriter<MetricProtos.FileChunk> chunkHistoryWriter;
    RecordWriter<MetricProtos.EmrMetricRecord> recordWriter;

    public OutputChunkWriter(String dir, String chunkHistoryFile) throws Exception {
        this.dir = dir;
        this.type = MetricsUtil.getFileType(dir);
        MetricsUtil.ensureDir(dir);
        this.chunkHistoryFile = chunkHistoryFile;
        this.chunkHistoryWriter = new RecordWriter(chunkHistoryFile);
        this.fileIndex = this.getCurrentFileIndex();
        this.outputFile = this.getOutputFile(this.fileIndex);
        this.recordWriter = new RecordWriter(this.outputFile);
    }

    MetricProtos.FileChunk write(Vector<MetricProtos.EmrMetricRecord> records) throws Exception {
        if (records.size() == 0) {
            return null;
        }
        long beginSize = MetricsUtil.getFileLength(this.outputFile);
        if (beginSize >= 0x8000000L) {
            logger.info("{} size {} exceeds limit", (Object)this.outputFile, (Object)beginSize);
            this.outputFile = this.getOutputFile(++this.fileIndex);
            beginSize = MetricsUtil.getFileLength(this.outputFile);
            this.recordWriter = new RecordWriter(this.outputFile);
        }
        logger.info("Commit {} output records to {}", (Object)records.size(), (Object)this.outputFile);
        this.recordWriter.appendAndFlush(records);
        MetricProtos.FileChunk.Builder cb = MetricProtos.FileChunk.newBuilder();
        cb.setFilePath(this.outputFile);
        cb.setBegin(beginSize);
        cb.setEnd(MetricsUtil.getFileLength(this.outputFile));
        cb.setTime(System.currentTimeMillis());
        cb.setMaxTime(OutputChunkWriter.getMaxTimeStamp(records));
        cb.setMinTime(OutputChunkWriter.getMinTimeStamp(records));
        MetricProtos.FileChunk chunk = cb.build();
        this.chunkHistoryWriter.appendAndFlush(chunk);
        return chunk;
    }

    String getOutputFile(int index) {
        return new File(this.dir, String.format("%s%03d.bin", "output_", index)).getPath();
    }

    int getFileIndex(String filename) {
        String name = new File(filename).getName();
        if (!name.matches("output_[0-9].bin")) {
            return -1;
        }
        int dotIndex = name.indexOf(46);
        return Integer.parseInt(name.substring("output_".length(), dotIndex));
    }

    int getCurrentFileIndex() throws IOException {
        int index = 0;
        if (MetricsUtil.getFileType(this.dir) == FileType.HDFS) {
            FileStatus[] children;
            Configuration configuration = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)configuration);
            for (FileStatus child : children = hdfs.listStatus(new Path(this.dir))) {
                String path = MetricsUtil.getPathName(child);
                index = Math.max(index, this.getFileIndex(path));
            }
        } else {
            File folder = new File(this.dir);
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                index = Math.max(index, this.getFileIndex(files[i].getPath()));
            }
        }
        return index;
    }

    static long getMinTimeStamp(Vector<MetricProtos.EmrMetricRecord> records) {
        long min = 0L;
        for (MetricProtos.EmrMetricRecord r : records) {
            long t = MetricsUtil.getMinTimeStamp(r);
            if (min != 0L && min <= t) continue;
            min = t;
        }
        return min;
    }

    static long getMaxTimeStamp(Vector<MetricProtos.EmrMetricRecord> records) {
        long max = 0L;
        for (MetricProtos.EmrMetricRecord r : records) {
            long t = MetricsUtil.getMaxTimeStamp(r);
            if (max != 0L && max >= t) continue;
            max = t;
        }
        return max;
    }
}

