/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.MetricsUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PidFileLock {
    static final Logger logger = LoggerFactory.getLogger(PidFileLock.class);
    private File file;
    private RandomAccessFile raf;
    private FileLock lock;

    public PidFileLock(String[] args) throws Exception {
        this(PidFileLock.getPIDFileFromArg(args));
    }

    public PidFileLock(String pidfile) throws Exception {
        if (pidfile == null) {
            logger.info("no pid file to lock");
            return;
        }
        boolean maxAttempts = true;
        int retry = 0;
        long sleepInterval = 1000L;
        while (++retry <= 1) {
            try {
                if (retry > 1) {
                    Thread.sleep(sleepInterval);
                    sleepInterval *= 2L;
                }
                this.file = new File(pidfile);
                this.raf = new RandomAccessFile(this.file, "rws");
                this.lock = this.raf.getChannel().tryLock();
                if (this.lock == null) {
                    logger.error("Failed to lock PID file {} retry={}", (Object)pidfile, (Object)retry);
                    continue;
                }
                logger.info("Locked pid file {}", (Object)pidfile);
                String pid = MetricsUtil.getPid();
                this.raf.writeBytes(pid);
                this.raf.write(0);
                logger.info("Wrote {} to PID file {}", (Object)pid, (Object)pidfile);
                return;
            }
            catch (Exception e) {
                logger.error("Failed to lock PID file {} retry={}", (Object)pidfile, (Object)retry);
            }
        }
        throw new RuntimeException("Could not lock PID file");
    }

    public void release() throws IOException {
        if (this.lock != null) {
            this.lock.release();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public static String getPIDFileFromArg(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--pidfile") && !args[i].equals("-pidfile")) continue;
            if (i >= args.length - 1) {
                throw new Exception("Missing PID file");
            }
            if (args[i + 1].startsWith("-")) {
                throw new Exception("Invalid PID file");
            }
            return args[i + 1];
        }
        return null;
    }
}

