/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.KeyProcessor;
import amazon.emr.metrics.MetricsEngine;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessProcessor {
    static final Logger logger = LoggerFactory.getLogger(ProcessProcessor.class);
    public final String instanceId;
    public final String process;
    final MetricsEngine engine;
    HashMap<String, KeyProcessor> keyProcessors;

    ProcessProcessor(MetricsEngine engine, String instanceId, String process) {
        logger.info("Create ProcessProcessor {}:{}", (Object)instanceId, (Object)process);
        this.engine = engine;
        this.instanceId = instanceId;
        this.process = process;
        this.keyProcessors = new HashMap();
    }

    public void getProcessorStates(Vector<MetricProtos.ProcessorState> states) {
        for (KeyProcessor p : this.keyProcessors.values()) {
            p.getProcessorStates(states);
        }
    }

    public void dispatchInput(MetricProtos.EmrMetricRecord r) {
        KeyProcessor p = this.ensureKeyProcessor(r.getKey().getKey());
        p.dispatchInput(r);
    }

    public void dispatchOutput(MetricProtos.EmrMetricRecord r) {
        KeyProcessor p = this.ensureKeyProcessor(r.getKey().getKey());
        p.dispatchOutput(r);
    }

    public void process(long engineCursor, int interval, Vector<MetricProtos.EmrMetricRecord> output) {
        for (KeyProcessor p : this.keyProcessors.values()) {
            p.process(engineCursor, interval, output);
        }
    }

    public Set<String> getKeys() {
        return this.keyProcessors.keySet();
    }

    KeyProcessor getProcessor(String key) {
        return this.keyProcessors.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyProcessor ensureKeyProcessor(String key) {
        ProcessProcessor processProcessor = this;
        synchronized (processProcessor) {
            if (!this.keyProcessors.containsKey(key)) {
                KeyProcessor p = new KeyProcessor(this.engine, this.instanceId, this.process, key);
                this.keyProcessors.put(key, p);
            }
            return this.keyProcessors.get(key);
        }
    }
}

