/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.FileType;
import amazon.emr.metrics.MetricsUtil;
import com.google.protobuf.AbstractMessage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriter<T extends AbstractMessage> {
    static final Logger logger = LoggerFactory.getLogger(RecordWriter.class);
    public final String filepath;
    private FileOutputStream fileOutput;
    private FSDataOutputStream hdfsOutput;

    public RecordWriter(String filepath) {
        this.filepath = filepath;
        this.fileOutput = null;
        this.hdfsOutput = null;
    }

    public void appendAndFlush(T record) throws IOException {
        if (record == null) {
            return;
        }
        this.OpenOutputStream();
        if (this.hdfsOutput != null) {
            record.writeDelimitedTo((OutputStream)this.hdfsOutput);
        } else {
            record.writeDelimitedTo((OutputStream)this.fileOutput);
        }
        this.CloseOutputStream();
    }

    public void appendAndFlush(Vector<T> records) throws IOException {
        if (records.size() == 0) {
            return;
        }
        this.OpenOutputStream();
        for (AbstractMessage record : records) {
            if (this.hdfsOutput != null) {
                record.writeDelimitedTo((OutputStream)this.hdfsOutput);
                continue;
            }
            record.writeDelimitedTo((OutputStream)this.fileOutput);
        }
        this.CloseOutputStream();
    }

    void OpenOutputStream() throws IOException {
        if (MetricsUtil.getFileType(this.filepath) == FileType.HDFS) {
            Path path;
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            this.hdfsOutput = hdfs.exists(path = new Path(this.filepath)) ? hdfs.append(path) : hdfs.create(path);
        } else {
            this.fileOutput = new FileOutputStream(this.filepath, true);
        }
    }

    void CloseOutputStream() throws IOException {
        if (this.hdfsOutput != null) {
            this.hdfsOutput.close();
            this.hdfsOutput = null;
        } else if (this.fileOutput != null) {
            this.fileOutput.close();
            this.fileOutput = null;
        }
    }
}

