/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.Credentials;
import amazon.emr.metrics.InstanceControllerRpcClient;
import amazon.emr.metrics.MetricsUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.S3Actions;
import com.amazonaws.auth.policy.conditions.StringCondition;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import java.io.IOException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionS3Client {
    static final Logger logger = LoggerFactory.getLogger(SessionS3Client.class);
    public InstanceControllerRpcClient.GetPolicyResponse policy = null;
    InstanceControllerRpcClient client = null;
    Credentials credentials = null;
    private String bucket;
    private String prefix;
    private AmazonS3Client s3client = null;
    private String s3ClientToken = "";

    public SessionS3Client() {
        this.updateToken();
        this.bucket = this.policy.bucket;
        this.prefix = this.policy.keyPrefix;
    }

    public SessionS3Client(String credentialFile, String bucket, String prefix) throws RuntimeException, IOException {
        this.credentials = Credentials.newInstance(credentialFile);
        this.bucket = bucket;
        this.prefix = prefix;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public BasicSessionCredentials getBasicSessionCredentials() {
        this.ensureToken();
        if (this.policy == null) {
            return null;
        }
        return new BasicSessionCredentials(this.policy.accessKeyId, this.policy.secretAccessKey, this.policy.sessionToken);
    }

    public AmazonS3Client s3Client() {
        this.ensureToken();
        if (this.policy == null) {
            logger.info("return null AmazonS3Client due to no session token");
            return null;
        }
        if (this.s3ClientToken.equals(this.policy.sessionToken)) {
            return this.s3client;
        }
        logger.info("create AmazonS3Client with token {}", (Object)SessionS3Client.trimSecret(this.policy.sessionToken, 16));
        this.s3client = new AmazonS3Client((AWSCredentials)new BasicSessionCredentials(this.policy.accessKeyId, this.policy.secretAccessKey, this.policy.sessionToken));
        this.s3ClientToken = this.policy.sessionToken;
        return this.s3client;
    }

    private void ensureToken() {
        if (this.policy == null || this.policy.expirationTime + 60000L < new DateTime().getMillis()) {
            this.updateToken();
        }
        if (this.policy == null || this.expired()) {
            this.policy = null;
        }
    }

    private void updateToken() {
        try {
            if (this.credentials != null) {
                this.policy = this.requestSessionToken();
            } else {
                if (this.client == null) {
                    this.client = new InstanceControllerRpcClient();
                }
                this.policy = this.client.getPolicy();
            }
            logger.info("get {}", (Object)this.getTraceStr(this.policy));
        }
        catch (Exception e) {
            logger.info("could NOT get policy {}", (Throwable)e);
        }
    }

    private boolean expired() {
        if (this.policy == null) {
            return true;
        }
        return this.policy.expirationTime < new DateTime().getMillis();
    }

    private InstanceControllerRpcClient.GetPolicyResponse requestSessionToken() throws RuntimeException, IOException {
        long expirationSeconds = 3600L;
        BasicAWSCredentials cred = new BasicAWSCredentials(this.credentials.accessId, this.credentials.privateKey);
        AWSSecurityTokenServiceClient stsClient = new AWSSecurityTokenServiceClient((AWSCredentials)cred);
        Resource r1 = new Resource(String.format("arn:aws:s3:::%s/%s", this.bucket, this.prefix));
        Resource r2 = new Resource(String.format("arn:aws:s3:::%s/%s*", this.bucket, this.prefix));
        Statement s1 = new Statement(Statement.Effect.Allow).withActions(new Action[]{S3Actions.DeleteObject, S3Actions.DeleteObjectVersion, S3Actions.GetObject, S3Actions.GetObjectVersion, S3Actions.PutObject}).withResources(new Resource[]{r1, r2});
        Resource r3 = new Resource(String.format("arn:aws:s3:::%s", this.bucket));
        StringCondition condition = new StringCondition(StringCondition.StringComparisonType.StringLike, "s3:prefix", this.prefix + "*");
        Statement s2 = new Statement(Statement.Effect.Allow).withActions(new Action[]{S3Actions.ListObjects}).withConditions(new Condition[]{condition}).withResources(new Resource[]{r3});
        Policy awsPolicy = new Policy().withStatements(new Statement[]{s1, s2});
        logger.info("Serialized policy {}", (Object)awsPolicy.toJson());
        GetFederationTokenRequest request = new GetFederationTokenRequest().withDurationSeconds(Integer.valueOf(3600)).withName(MetricsUtil.getHostName()).withPolicy(awsPolicy.toJson());
        GetFederationTokenResult result = stsClient.getFederationToken(request);
        com.amazonaws.services.securitytoken.model.Credentials cn = result.getCredentials();
        InstanceControllerRpcClient.GetPolicyResponse response = new InstanceControllerRpcClient.GetPolicyResponse();
        response.accessKeyId = cn.getAccessKeyId();
        response.secretAccessKey = cn.getSecretAccessKey();
        response.sessionToken = cn.getSessionToken();
        response.expirationTime = 3600000L + new DateTime().getMillis();
        response.bucket = this.bucket;
        response.keyPrefix = this.prefix;
        return response;
    }

    public String getTraceStr(InstanceControllerRpcClient.GetPolicyResponse response) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Policy accessKeyId: " + response.accessKeyId);
        sb.append(" secretAccessKey: " + SessionS3Client.trimSecret(response.secretAccessKey, 4));
        sb.append(" sessionToken " + SessionS3Client.trimSecret(response.sessionToken, 16));
        sb.append(" bucket: " + response.bucket);
        sb.append(" prefix: " + response.keyPrefix);
        sb.append(" expiration: " + MetricsUtil.getTimeStr(response.expirationTime));
        return sb.toString();
    }

    private static String trimSecret(String secret, int len) {
        return secret.length() > len ? secret.substring(0, len) + "****" : "****";
    }
}

