/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.ChartServlet;
import amazon.emr.metrics.DataMap;
import amazon.emr.metrics.DataOption;
import amazon.emr.metrics.InstanceProcessor;
import amazon.emr.metrics.IntervalAggregator;
import amazon.emr.metrics.MetricsEngine;
import amazon.emr.metrics.MetricsUtil;
import amazon.emr.metrics.ProcessProcessor;
import com.ibm.icu.text.DecimalFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerHandler
extends AbstractHandler {
    static final Logger logger = LoggerFactory.getLogger(WebServerHandler.class);
    MetricsEngine engine;
    String masterInstanceId;
    String jobflowId;
    String supportingScripts;
    ChartServlet chartServlet;

    WebServerHandler(MetricsEngine engine) throws IOException {
        this.engine = engine;
        this.masterInstanceId = engine.config.masterInstanceId;
        this.jobflowId = engine.config.jobFlowId;
        this.supportingScripts = this.loadSupportingScripts();
        this.chartServlet = new ChartServlet(engine);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (!target.startsWith("/favicon")) {
            logger.info("handle {}?{}", (Object)target, (Object)request.getQueryString());
        }
        if (!target.startsWith("/favicon")) {
            if (target.startsWith("/raw")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                DataOption option = new DataOption(request);
                response.getWriter().write(this.formatRawData(option));
                this.setHandled(request);
            } else if (target.startsWith("/chart")) {
                this.chartServlet.service((ServletRequest)request, (ServletResponse)response);
                this.setHandled(request);
            } else {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                DataOption option = new DataOption(request);
                response.getWriter().write(this.formatHTML(option));
                this.setHandled(request);
            }
        }
    }

    private void setHandled(HttpServletRequest request) {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        baseRequest.setHandled(true);
    }

    String formatRawData(DataOption option) {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("<html xmlns='http://www.w3.org/1999/xhtml'> \n");
        sb.append("<head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head>\n");
        sb.append("<body><pre>\n");
        if (option.single) {
            this.formatRawDataSingle(sb, option);
        } else {
            this.formatRawDataMultiple(sb, option);
        }
        sb.append("</pre></body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    String formatHTML(DataOption option) {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("<html xmlns='http://www.w3.org/1999/xhtml'>\n");
        this.formatHeader(sb, option);
        this.formatBody(sb, option);
        sb.append("</html>\n");
        return sb.toString();
    }

    void formatHeader(StringBuilder sb, DataOption option) {
        sb.append("<head>\n");
        sb.append("  <meta http-equiv='content-type' content='text/html; charset=utf-8'/>\n");
        sb.append("  <title>Amazon EMR Metrics Server</title>\n");
        this.formatChartScript(sb, option);
        sb.append(this.supportingScripts);
        sb.append("</head>\n");
    }

    void formatBody(StringBuilder sb, DataOption option) {
        sb.append("<body BGCOLOR=\"#FDF5E6\">\n");
        sb.append(String.format("  <h1 ALIGN=CENTER>Amazon EMR Metrics Server for Job Flow %s</h1>\n", this.jobflowId));
        this.formatInstanceProcessSelection(sb, option);
        sb.append("  <table border=\"0\">\n");
        sb.append("  <tr>\n");
        sb.append("    <th>Metrics Keys</th>\n");
        sb.append("    <th>Metrics Charts</th>\n");
        sb.append("    </tr>\n");
        sb.append("    <tr>\n");
        sb.append("      <td>");
        List<String> keys = this.getSortedKeys(option);
        for (String key : keys) {
            sb.append(String.format("      %s<br>\n", this.getShorterDisplayKey(key)));
        }
        sb.append("      </td>");
        sb.append("      <td>");
        for (String key : keys) {
            this.formatKey(sb, option, key);
            sb.append("<br>\n");
        }
        sb.append("      </td>\n");
        sb.append("    </tr>\n");
        sb.append("    </tr>\n");
        sb.append("  </table>\n");
        sb.append("  <p></p>\n");
        sb.append("  <div id='visualization' style='height: 400px; width: 1200px;'></div>\n");
        sb.append("    <p></p><iframe id=\"iframeid\" frameBorder=\"0\" scroll=\"no\" onLoad=\"autoResize('iframeid');\" ");
        sb.append(String.format("src=\"raw?%s\"></iframe>\n", option.params));
        sb.append("</body>\n");
    }

    void formatInstanceProcessSelection(StringBuilder sb, DataOption option) {
        List<String> instances = this.getSortedInstanceList();
        List<String> processes = this.getSortedProcessList(option);
        sb.append("<form id=\"InstanceSelector\">\n");
        int COLUMNS = 9;
        sb.append("  <table border=\"0\">\n");
        String masterStr = String.format("  <input type=checkbox name=\"instance\" value=\"%s\" %s><b>%s</b>\n", this.masterInstanceId, option.hasInstance(this.masterInstanceId) ? "checked" : "", this.masterInstanceId);
        String label = String.format("  <tr><td colspan=\"2\"><b>Instances(%d):</b> %s</td>\n", instances.size(), masterStr);
        sb.append(label);
        int row = 0;
        int col = 2;
        for (String v : instances) {
            if (v.equals(this.masterInstanceId)) continue;
            if (col == 0) {
                sb.append("  <tr>\n");
            }
            sb.append("      <td>");
            sb.append(String.format("  <input type=checkbox name=\"instance\" value=\"%s\" %s>%s\n", v, option.hasInstance(v) ? "checked" : "", v));
            sb.append("      </td>");
            if (++col != 9) continue;
            col = 0;
            ++row;
            sb.append("    </tr>\n");
        }
        sb.append("  </table>\n");
        sb.append("</form>\n");
        sb.append("<form id=\"ProcessSelector\">\n");
        sb.append("<b>Processes:</b> \n");
        for (String p : processes) {
            sb.append(String.format("  <input type=radio name=\"process\" value=\"%s\" %s>%s\n", p, option.key.getProcess().equals(p) ? "checked" : "", p));
        }
        sb.append("<input type=button value=\"Submit\" onclick=\"onSubmit();\">\n");
        sb.append("</form>\n");
    }

    String loadSupportingScripts() throws IOException {
        String scripts = MetricsUtil.extractMetricsJarFileAsString("supportingScripts.js");
        return scripts;
    }

    void formatKey(StringBuilder sb, DataOption option, String key) {
        int[] intervals;
        sb.append(String.format(" <a href=\"index?%s\">raw</a> ", this.formatParams(option, key, 0, "avg")));
        for (int interval : intervals = new int[]{10, 60, 300}) {
            sb.append(String.format("<span> %d: ", interval));
            for (String type : DataOption.typestrs) {
                sb.append(String.format("<a href=\"index?%s\">%s</a> ", this.formatParams(option, key, interval, type), type));
            }
        }
    }

    String formatParams(DataOption option, String key, int interval, String type) {
        MetricProtos.EmrMetricKey.Builder b = option.key.toBuilder();
        b.setKey(key);
        b.setInterval(interval);
        return String.format("id=%s&t=%s%s", MetricsUtil.getStreamId(b.build()), type, option.getExtraIdsParam());
    }

    void formatRawDataSingle(StringBuilder sb, DataOption option) {
        DecimalFormat df = new DecimalFormat("0000000000.0");
        long lastTime = 0L;
        Vector<MetricProtos.EmrMetricRecord> records = DataMap.getStreamRecords(this.engine, option.key);
        MetricProtos.EmrMetricAggregatedValue sv = IntervalAggregator.aggregateRecords(records);
        if (sv == null) {
            return;
        }
        String summary = String.format("Total duration:%d avg:%s ct:%d t90:%s sum:%s er:%d\n", sv.getStop() - sv.getStart(), df.format(sv.getAverage()), sv.getCount(), df.format(sv.getTp90()), df.format(sv.getSum()), sv.getNumError());
        sb.append(summary);
        int index = 0;
        String line = String.format("%5s %26s %7s %6s %12s record\n", "idx", "timestamp", "tdiff", "count", "value");
        sb.append(line);
        for (MetricProtos.EmrMetricRecord r : records) {
            String valueStr;
            boolean firstValueInRecord = true;
            for (MetricProtos.EmrMetricAggregatedValue emrMetricAggregatedValue : r.getValuesExList()) {
                if (option.type == DataOption.ChartType.EMAP && emrMetricAggregatedValue.getNumError() == 0) continue;
                ++index;
                if (lastTime == 0L) {
                    lastTime = emrMetricAggregatedValue.getStart();
                }
                valueStr = "";
                if (option.type != DataOption.ChartType.EMAP) {
                    double value = DataMap.getNumericalValue(emrMetricAggregatedValue, option.type);
                    valueStr = String.format("%6d %s", emrMetricAggregatedValue.getCount(), df.format(value));
                } else {
                    valueStr = String.format("%6d %3d:%s", emrMetricAggregatedValue.getNumError(), emrMetricAggregatedValue.getErrors(0).getCount(), emrMetricAggregatedValue.getErrors(0).getError());
                }
                line = String.format("%5d %s %7d %s %s\n", index, MetricsUtil.getTimeStr(emrMetricAggregatedValue.getStart()), emrMetricAggregatedValue.getStart() - lastTime, valueStr, firstValueInRecord ? MetricsUtil.getStreamId(r.getKey()) : "");
                sb.append(line);
                lastTime = emrMetricAggregatedValue.getStart();
                firstValueInRecord = false;
            }
            for (MetricProtos.EmrMetricRawValue emrMetricRawValue : r.getValuesList()) {
                if (option.type == DataOption.ChartType.EMAP && !emrMetricRawValue.hasError()) continue;
                ++index;
                if (lastTime == 0L) {
                    lastTime = emrMetricRawValue.getTime();
                }
                valueStr = option.type == DataOption.ChartType.EMAP ? emrMetricRawValue.getError() : String.format("%d", emrMetricRawValue.getValue());
                line = String.format("%5d %s %7s %6s %10s %s\n", index, MetricsUtil.getTimeStr(emrMetricRawValue.getTime()), emrMetricRawValue.getTime() - lastTime, "1", valueStr, firstValueInRecord ? MetricsUtil.getStreamId(r.getKey()) : "");
                sb.append(line);
                lastTime = emrMetricRawValue.getTime();
                firstValueInRecord = false;
            }
        }
    }

    void formatRawDataMultiple(StringBuilder sb, DataOption option) {
        logger.info("getRawDataOutput {}", (Object)option.params);
        DecimalFormat df = new DecimalFormat("0000000000.0");
        long lastTime = 0L;
        int index = 0;
        TreeMap<Long, TreeMap<Integer, Double>> map = DataMap.getDataMapMultiple(this.engine, option);
        String line = String.format("%5s %26s %7s", "idx", "timestamp", "tdiff");
        for (int i = 0; i < option.ids.size(); ++i) {
            line = line + String.format("%12s", option.getInstanceId(i));
        }
        sb.append(line);
        sb.append("\n");
        for (Map.Entry<Long, TreeMap<Integer, Double>> entry : map.entrySet()) {
            ++index;
            long time = entry.getKey();
            if (lastTime == 0L) {
                lastTime = time;
            }
            TreeMap<Integer, Double> v = entry.getValue();
            line = String.format("%5d %s %7d ", index, MetricsUtil.getTimeStr(time), time - lastTime);
            for (int i = 0; i < option.ids.size(); ++i) {
                line = line + String.format("%12s ", v.containsKey(i) ? df.format((Object)v.get(i)) : "");
            }
            sb.append(line);
            sb.append("\n");
            lastTime = time;
        }
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    void formatChartScript(StringBuilder sb, DataOption option) {
        String chartUrl = String.format("chart?%s", option.params);
        sb.append("<script type=\"text/javascript\"\n");
        sb.append("  src='https://www.google.com/jsapi?autoload={\"modules\":[{\"name\":\"visualization\",\"version\":\"1\"}]}'>\n");
        sb.append("</script>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("  google.setOnLoadCallback(drawVisualization);\n");
        sb.append("  function drawVisualization() {\n");
        sb.append("    var wrap = new google.visualization.ChartWrapper();\n");
        sb.append("    wrap.setChartType('LineChart');\n");
        sb.append(String.format("    wrap.setDataSourceUrl('%s');\n", chartUrl));
        sb.append("    wrap.setContainerId('visualization');\n");
        sb.append(String.format("    wrap.setOptions({'title':'%s', 'legend':'bottom'});\n", option.params));
        sb.append("    wrap.draw();\n");
        sb.append("  }\n");
        sb.append("</script>\n");
    }

    String getShorterDisplayKey(String key) {
        int len = key.length();
        if (len <= 24) {
            return key;
        }
        int dotIndex = key.indexOf(46);
        if (dotIndex > 0) {
            int k = 0;
            for (int i = 0; i < dotIndex; ++i) {
                char c = key.charAt(i);
                if (c < 'A' || c > 'Z') continue;
                ++k;
            }
            char[] a = new char[k];
            int l = 0;
            for (int i = 0; i < dotIndex; ++i) {
                char c = key.charAt(i);
                if (c < 'A' || c > 'Z') continue;
                a[l++] = c;
            }
            return String.valueOf(a) + key.substring(dotIndex);
        }
        return key.substring(0, 24) + "...";
    }

    List<String> getSortedKeys(DataOption option) {
        TreeSet<String> keys = new TreeSet<String>();
        for (MetricProtos.EmrMetricKey key : option.keys) {
            ProcessProcessor pp;
            InstanceProcessor ip = this.engine.getInstanceProcessor(key.getInstanceId());
            if (ip == null || (pp = ip.getProcessor(key.getProcess())) == null) continue;
            keys.addAll(pp.getKeys());
        }
        return WebServerHandler.asSortedList(keys);
    }

    List<String> getSortedInstanceList() {
        List<String> all = WebServerHandler.asSortedList(this.engine.getInstanceIds());
        for (int i = 0; i < all.size(); ++i) {
            if (all.get(i).equals(this.masterInstanceId) && i > 0) {
                all.remove(i);
                all.add(0, this.masterInstanceId);
                continue;
            }
            if (!all.get(i).equals("global") || i >= all.size() - 1) continue;
            all.remove(i);
            all.add("global");
        }
        return all;
    }

    List<String> getSortedProcessList(DataOption option) {
        TreeSet<String> names = new TreeSet<String>();
        for (MetricProtos.EmrMetricKey key : option.keys) {
            InstanceProcessor p = this.engine.getInstanceProcessor(key.getInstanceId());
            if (p == null) continue;
            names.addAll(p.getProcesses());
        }
        return WebServerHandler.asSortedList(names);
    }
}

