/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.common;

import com.amazon.jdbc.classloader.JarInJarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class PGClassLoaderSingleton {
    private static final JarInJarClassLoader INSTANCE = PGClassLoaderSingleton.initializeSingleton();
    private static Exception s_exc;

    public static ClassLoader getInstance() {
        if (null != s_exc) {
            throw new RuntimeException(s_exc);
        }
        return INSTANCE;
    }

    private static File getContainingJarFile() {
        Class<PGClassLoaderSingleton> clazz = PGClassLoaderSingleton.class;
        URL uRL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (null != uRL && "jar".equals(uRL.getProtocol())) {
            try {
                URL uRL2 = ((JarURLConnection)uRL.openConnection()).getJarFileURL();
                if ("file".equals(uRL2.getProtocol())) {
                    return new File(uRL2.getPath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<String> getInnerJars(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            String string = jarEntry.getName();
            if (jarEntry.isDirectory() || string.length() <= 4 || !".jar".equalsIgnoreCase(string.substring(string.length() - 4))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static JarInJarClassLoader initializeSingleton() {
        try {
            File file = PGClassLoaderSingleton.getContainingJarFile();
            if (null == file) {
                throw new IOException("Unable to load driver: JAR expected but not found.");
            }
            return new JarInJarClassLoader(PGClassLoaderSingleton.getInnerJars(new JarFile(file)));
        }
        catch (Exception exception) {
            s_exc = exception;
            return null;
        }
    }

    private PGClassLoaderSingleton() {
        throw new UnsupportedOperationException();
    }
}

