/*
 * Decompiled with CFR 0.152.
 */
package Zql;

import Zql.ZConstant;
import Zql.ZExp;
import Zql.ZQuery;
import Zql.ZUtils;
import java.util.Vector;

public class ZExpression
implements ZExp {
    String op_ = null;
    Vector operands_ = null;

    public ZExpression(String string) {
        this.op_ = new String(string);
    }

    public ZExpression(String string, ZExp zExp) {
        this.op_ = new String(string);
        this.addOperand(zExp);
    }

    public ZExpression(String string, ZExp zExp, ZExp zExp2) {
        this.op_ = new String(string);
        this.addOperand(zExp);
        this.addOperand(zExp2);
    }

    public String getOperator() {
        return this.op_;
    }

    public void setOperands(Vector vector) {
        this.operands_ = vector;
    }

    public Vector getOperands() {
        return this.operands_;
    }

    public void addOperand(ZExp zExp) {
        if (this.operands_ == null) {
            this.operands_ = new Vector();
        }
        this.operands_.addElement(zExp);
    }

    public ZExp getOperand(int n) {
        if (this.operands_ == null || n >= this.operands_.size()) {
            return null;
        }
        return (ZExp)this.operands_.elementAt(n);
    }

    public int nbOperands() {
        if (this.operands_ == null) {
            return 0;
        }
        return this.operands_.size();
    }

    public String toReversePolish() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.op_);
        for (int i = 0; i < this.nbOperands(); ++i) {
            ZExp zExp = this.getOperand(i);
            if (zExp instanceof ZExpression) {
                stringBuffer.append(" " + ((ZExpression)zExp).toReversePolish());
                continue;
            }
            if (zExp instanceof ZQuery) {
                stringBuffer.append(" (" + zExp.toString() + ")");
                continue;
            }
            stringBuffer.append(" " + zExp.toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.op_.equals("?")) {
            return this.op_;
        }
        if (ZUtils.isCustomFunction(this.op_) > 0) {
            return this.formatFunction();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.needPar(this.op_)) {
            stringBuffer.append("(");
        }
        switch (this.nbOperands()) {
            case 1: {
                ZExp zExp = this.getOperand(0);
                if (zExp instanceof ZConstant) {
                    if (ZUtils.isAggregate(this.op_)) {
                        stringBuffer.append(this.op_ + "(" + zExp.toString() + ")");
                        break;
                    }
                    if (this.op_.equals("IS NULL") || this.op_.equals("IS NOT NULL")) {
                        stringBuffer.append(zExp.toString() + " " + this.op_);
                        break;
                    }
                    stringBuffer.append(this.op_ + " " + zExp.toString());
                    break;
                }
                if (zExp instanceof ZQuery) {
                    stringBuffer.append(this.op_ + " (" + zExp.toString() + ")");
                    break;
                }
                if (this.op_.equals("IS NULL") || this.op_.equals("IS NOT NULL")) {
                    stringBuffer.append(zExp.toString() + " " + this.op_);
                    break;
                }
                stringBuffer.append(this.op_ + " " + zExp.toString());
                break;
            }
            case 3: {
                if (this.op_.toUpperCase().endsWith("BETWEEN")) {
                    stringBuffer.append(this.getOperand(0).toString() + " " + this.op_ + " " + this.getOperand(1).toString() + " AND " + this.getOperand(2).toString());
                    break;
                }
            }
            default: {
                boolean bl = this.op_.equals("IN") || this.op_.equals("NOT IN");
                int n = this.nbOperands();
                for (int i = 0; i < n; ++i) {
                    ZExp zExp;
                    if (bl && i == 1) {
                        stringBuffer.append(" " + this.op_ + " (");
                    }
                    if ((zExp = this.getOperand(i)) instanceof ZQuery && !bl) {
                        stringBuffer.append("(" + zExp.toString() + ")");
                    } else {
                        stringBuffer.append(zExp.toString());
                    }
                    if (i >= n - 1) continue;
                    if (this.op_.equals(",") || bl && i > 0) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    if (bl) continue;
                    stringBuffer.append(" " + this.op_ + " ");
                }
                if (!bl) break;
                stringBuffer.append(")");
            }
        }
        if (this.needPar(this.op_)) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private boolean needPar(String string) {
        return !(string = string.toUpperCase()).equals("ANY") && !string.equals("ALL") && !string.equals("UNION") && !ZUtils.isAggregate(string);
    }

    private String formatFunction() {
        StringBuffer stringBuffer = new StringBuffer(this.op_ + "(");
        int n = this.nbOperands();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getOperand(i).toString() + (i < n - 1 ? "," : ""));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

