/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.common;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jinterop.dcom.common.IJILogger;

final class JIDefaultLoggerImpl
implements IJILogger {
    private final Logger logger = Logger.getLogger("org.jinterop");

    JIDefaultLoggerImpl(Level level) {
        this.logger.setLevel(level);
        try {
            this.logger.setUseParentHandlers(false);
            FileHandler fileHandler = new FileHandler("%t/j-Interop%g.log", 0, 1, true);
            fileHandler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(fileHandler);
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Log file will be created in System's tmp directory, which in the current case is (java.io.tmpdir): " + System.getProperty("java.io.tmpdir"));
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entering(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exiting(sourceClass, sourceMethod);
    }

    public void fine(String msg) {
        LogRecord r = new LogRecord(Level.FINE, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }

    public void finer(String msg) {
        LogRecord r = new LogRecord(Level.FINER, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }

    public void finest(String msg) {
        LogRecord r = new LogRecord(Level.FINEST, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }

    public void info(String msg) {
        LogRecord r = new LogRecord(Level.INFO, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }

    public void severe(String msg) {
        LogRecord r = new LogRecord(Level.SEVERE, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }

    public void exception(String sourceClass, String sourceMethod, Throwable thrown) {
        String msg = "";
        if (thrown != null) {
            msg = String.valueOf(thrown.getMessage() == null ? "[No Message in Exception]" : thrown.getMessage()) + "\n";
            StackTraceElement[] stackTraceElements = thrown.getStackTrace();
            int i = 0;
            while (i < stackTraceElements.length) {
                msg = String.valueOf(msg) + stackTraceElements[i].toString() + "\n";
                ++i;
            }
        }
        this.logger.logp(Level.SEVERE, sourceClass, sourceMethod, msg);
    }

    public void warning(String msg) {
        LogRecord r = new LogRecord(Level.WARNING, msg);
        r.setSourceClassName("");
        r.setSourceMethodName("Thread: " + Thread.currentThread().getName());
        this.logger.log(r);
    }
}

