/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jinterop.dcom.common.JIMethodDescriptor;
import org.jinterop.dcom.common.JISystem;

public final class JIInterfaceDefinition
implements Serializable {
    private static final long serialVersionUID = 7683984211902254797L;
    private String interfaceIdentifier = null;
    private Map opnumVsMethodInfo = new HashMap();
    private Map dispIdVsMethodInfo = new HashMap();
    private Map nameVsMethodInfo = new HashMap();
    private int nextNum = 0;
    Object instance = null;
    Class clazz = null;
    private boolean dispInterface = true;

    public JIInterfaceDefinition(String interfaceIdentifier) {
        this.interfaceIdentifier = interfaceIdentifier;
    }

    public JIInterfaceDefinition(String interfaceIdentifier, boolean isDispInterface) {
        this.interfaceIdentifier = interfaceIdentifier;
        this.dispInterface = isDispInterface;
    }

    public void addMethodDescriptor(JIMethodDescriptor methodDescriptor) {
        if (this.nameVsMethodInfo.containsKey(methodDescriptor.getMethodName())) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4131));
        }
        methodDescriptor.setMethodNum(this.nextNum);
        ++this.nextNum;
        this.opnumVsMethodInfo.put(new Integer(methodDescriptor.getMethodNum()), methodDescriptor);
        if (this.dispInterface) {
            if (methodDescriptor.getMethodDispID() == -1) {
                throw new IllegalArgumentException(JISystem.getLocalizedMessage(4151));
            }
            this.dispIdVsMethodInfo.put(new Integer(methodDescriptor.getMethodDispID()), methodDescriptor);
        }
        this.nameVsMethodInfo.put(methodDescriptor.getMethodName(), methodDescriptor);
    }

    public JIMethodDescriptor getMethodDescriptor(int opnum) {
        return (JIMethodDescriptor)this.opnumVsMethodInfo.get(new Integer(opnum));
    }

    public JIMethodDescriptor getMethodDescriptorForDispId(int dispId) {
        return (JIMethodDescriptor)this.dispIdVsMethodInfo.get(new Integer(dispId));
    }

    public JIMethodDescriptor getMethodDescriptor(String name) {
        return (JIMethodDescriptor)this.nameVsMethodInfo.get(name);
    }

    public JIMethodDescriptor[] getMethodDescriptors() {
        return this.opnumVsMethodInfo.values().toArray(new JIMethodDescriptor[this.opnumVsMethodInfo.values().size()]);
    }

    public String getInterfaceIdentifier() {
        return this.interfaceIdentifier;
    }

    public void removeMethodDescriptor(int opnum) {
        JIMethodDescriptor methodDescriptor = (JIMethodDescriptor)this.opnumVsMethodInfo.remove(new Integer(opnum));
        if (methodDescriptor != null) {
            this.nameVsMethodInfo.remove(methodDescriptor.getMethodName());
        }
    }

    public void removeMethodDescriptor(String methodName) {
        JIMethodDescriptor methodDescriptor = (JIMethodDescriptor)this.nameVsMethodInfo.remove(methodName);
        if (methodDescriptor != null) {
            this.nameVsMethodInfo.remove(new Integer(methodDescriptor.getMethodNum()));
        }
    }

    public boolean isDispInterface() {
        return this.dispInterface;
    }
}

