/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.common;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJILogger;
import org.jinterop.dcom.common.JIComVersion;
import org.jinterop.dcom.common.JIDefaultLoggerImpl;

public final class JISystem {
    private static String pathToDB = null;
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle resourceBundle = null;
    private static Properties mapOfProgIdsVsClsids = new Properties();
    private static ArrayList socketQueue = new ArrayList();
    private static JIComVersion comVersion = new JIComVersion();
    private static IJILogger logger = null;
    private static Level level = Level.WARNING;
    private static boolean autoRegister = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private JISystem() {
    }

    public static void setCOMVersion(JIComVersion comVersion) {
        JISystem.comVersion = comVersion;
    }

    public static JIComVersion getCOMVersion() {
        return comVersion;
    }

    public static void setLocale(Locale locale) {
        JISystem.locale = locale;
    }

    public static Locale getLocale() {
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceBundle getErrorMessages() {
        if (resourceBundle != null) return resourceBundle;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jinterop.dcom.common.JISystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            try {
                if (resourceBundle != null) return resourceBundle;
                resourceBundle = ResourceBundle.getBundle("org.jinterop.dcom.jierrormessages", locale);
            }
            catch (MissingResourceException ex) {
                resourceBundle = ResourceBundle.getBundle("org.jinterop.dcom.jierrormessages");
            }
            return resourceBundle;
        }
    }

    public static String getLocalizedMessage(int code) {
        String strKey = Integer.toHexString(code).toUpperCase();
        char[] buffer = new char[]{'0', 'x', '0', '0', '0', '0', '0', '0', '0', '0'};
        System.arraycopy(strKey.toCharArray(), 0, buffer, buffer.length - strKey.length(), strKey.length());
        return JISystem.getLocalizedMessage(String.valueOf(buffer));
    }

    private static String getLocalizedMessage(String key) {
        String message = null;
        try {
            message = JISystem.getErrorMessages().getString(key);
            message = String.valueOf(message) + " [" + key + "]";
        }
        catch (MissingResourceException r) {
            message = "Message not found for errorCode: " + key;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClsidFromProgId(String progId) {
        if (progId == null) {
            return null;
        }
        if (pathToDB != null) return (String)mapOfProgIdsVsClsids.get(progId);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jinterop.dcom.common.JISystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (pathToDB != null) return (String)mapOfProgIdsVsClsids.get(progId);
            JISystem.saveDBPathAndLoadFile();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)mapOfProgIdsVsClsids.get(progId);
        }
    }

    private static void saveDBPathAndLoadFile() {
        Enumeration<URL> resources2;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jinterop.dcom.common.JISystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader loader = clazz.getClassLoader();
        HashSet<URL> locations = new HashSet<URL>();
        if (loader != null) {
            try {
                resources2 = loader.getResources("progIdVsClsidDB.properties");
                if (resources2.hasMoreElements()) {
                    locations.add(resources2.nextElement());
                }
            }
            catch (IOException resources2) {
                // empty catch block
            }
        }
        try {
            if (locations.size() == 0 && (resources2 = ClassLoader.getSystemResources("progIdVsClsidDB.properties")).hasMoreElements()) {
                locations.add(resources2.nextElement());
            }
        }
        catch (IOException resources3) {
            // empty catch block
        }
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            try {
                URL url = (URL)iterator.next();
                pathToDB = url.getPath();
                try {
                    url = new URL("file:" + pathToDB);
                    System.out.println("progIdVsClsidDB file located at: " + url);
                    URLConnection con = url.openConnection();
                    InputStream inputStream = con.getInputStream();
                    mapOfProgIdsVsClsids.load(inputStream);
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("progIdVsClsidDB: " + mapOfProgIdsVsClsids);
        System.out.println();
    }

    public static void writeProgIdsToFile() {
        if (pathToDB != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(pathToDB);
                mapOfProgIdsVsClsids.store(outputStream, "progId Vs ClsidDB");
                outputStream.close();
            }
            catch (FileNotFoundException e) {
                logger.exception("", "", e);
            }
            catch (IOException e) {
                logger.exception("", "", e);
            }
        }
    }

    public static void setClsidtoProgId(String progId, String clsid) {
        mapOfProgIdsVsClsids.put(progId, clsid);
    }

    public static Object getSocket() {
        return socketQueue.remove(0);
    }

    public static void setSocket(Object socket) {
        socketQueue.add(socket);
    }

    public static void setLogLevel(Level level) {
        JISystem.level = level;
    }

    public static void setLogger(IJILogger logger, Level level) {
        JISystem.logger = logger;
        JISystem.level = level;
    }

    public static Level getLogLevel() {
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IJILogger getLogger() {
        if (logger != null) return logger;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jinterop.dcom.common.IJILogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (logger != null) return logger;
            logger = new JIDefaultLoggerImpl(level);
            Properties pr = System.getProperties();
            Iterator<Object> itr = pr.keySet().iterator();
            String str = "";
            while (itr.hasNext()) {
                String key = (String)itr.next();
                str = String.valueOf(str) + key + " = " + pr.getProperty(key) + "\n";
            }
            logger.finest(str);
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    public static void setAutoRegisteration(boolean autoRegisteration) {
        autoRegister = autoRegisteration;
    }

    public static boolean isAutoRegistrationSet() {
        return autoRegister;
    }
}

