/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUtil;
import org.jinterop.dcom.core.JIVariant;
import rpc.core.UUID;

public class JICallObject
extends NdrObject
implements Serializable {
    private static final long serialVersionUID = -2939657500731135110L;
    private int opnum = -1;
    private Object[] outparams = null;
    private boolean dispatchNotSupported = false;
    private String enclosingParentsIPID = null;
    private int inparamFlags = 0;
    private int outparamFlags = 0;
    private ArrayList inParams = new ArrayList();
    private ArrayList outParams = new ArrayList();
    private int hresult = 0;
    private boolean executed = false;
    private Object[] resultsOfException = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JICallObject(String IPIDofParent, boolean dispatchNotSupported) {
        this(IPIDofParent);
        this.dispatchNotSupported = dispatchNotSupported;
    }

    public JICallObject(String IPIDofParent) {
        this.enclosingParentsIPID = IPIDofParent;
    }

    public void reInit() {
        this.opnum = -1;
        this.inParams = new ArrayList();
        this.inparamFlags = 0;
        this.outParams = new ArrayList();
        this.outparamFlags = 0;
        this.hresult = -1;
        this.outparams = null;
        this.executed = false;
    }

    void setParentIpid(String IPIDofParent) {
        this.enclosingParentsIPID = IPIDofParent;
    }

    String getParentIpid() {
        return this.enclosingParentsIPID;
    }

    public void addInParamAsInterfacePointer(JIInterfacePointer interfacePointer, int FLAGS) {
        this.insertInParamAsInterfacePointerAt(this.inParams.size(), interfacePointer, FLAGS);
    }

    public void addInParamAsInt(int value, int FLAGS) {
        this.insertInParamAsIntAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsUnsigned(IJIUnsigned value, int FLAGS) {
        this.insertInParamAsUnsignedAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsFloat(float value, int FLAGS) {
        this.insertInParamAsFloatAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsBoolean(boolean value, int FLAGS) {
        this.insertInParamAsBooleanAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsShort(short value, int FLAGS) {
        this.insertInParamAsShortAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsDouble(double value, int FLAGS) {
        this.insertInParamAsDoubleAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsCharacter(char value, int FLAGS) {
        this.insertInParamAsCharacterAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsString(String value, int FLAGS) {
        this.insertInParamAsStringAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsVariant(JIVariant value, int FLAGS) {
        this.insertInParamAsVariantAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsObject(Object value, int FLAGS) {
        this.insertInParamAsObjectAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsUUID(String value, int FLAGS) {
        this.insertInParamAsUUIDAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsPointer(JIPointer value, int FLAGS) {
        this.insertInParamAsPointerAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsStruct(JIStruct value, int FLAGS) {
        this.insertInParamAsStructAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsArray(JIArray value, int FLAGS) {
        this.insertInParamAsArrayAt(this.inParams.size(), value, FLAGS);
    }

    public void setInParams(Object[] values, int FLAGS) {
        int i = 0;
        while (i < values.length) {
            this.inParams.add(values[i]);
            ++i;
        }
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsInterfacePointerAt(int index, JIInterfacePointer value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsIntAt(int index, int value, int FLAGS) {
        this.inParams.add(index, new Integer(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsUnsignedAt(int index, IJIUnsigned value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsFloatAt(int index, float value, int FLAGS) {
        this.inParams.add(index, new Float(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsBooleanAt(int index, boolean value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsShortAt(int index, short value, int FLAGS) {
        this.inParams.add(index, new Short(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsDoubleAt(int index, double value, int FLAGS) {
        this.inParams.add(index, new Double(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsCharacterAt(int index, char value, int FLAGS) {
        this.inParams.add(index, new Character(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsStringAt(int index, String value, int FLAGS) {
        this.inParams.add(index, new JIString(value, FLAGS));
    }

    public void insertInParamAsVariantAt(int index, JIVariant value, int FLAGS) {
        this.inParams.add(index, value);
    }

    public void insertInParamAsObjectAt(int index, Object value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsUUIDAt(int index, String value, int FLAGS) {
        this.inParams.add(index, new UUID(value));
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsPointerAt(int index, JIPointer value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsStructAt(int index, JIStruct value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void insertInParamAsArrayAt(int index, JIArray value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags |= FLAGS;
    }

    public void removeInParamAt(int index, int FLAGS) {
        Object value = this.inParams.remove(index);
        this.inparamFlags &= ~FLAGS;
    }

    public Object getInParamAt(int index) {
        return this.inParams.get(index);
    }

    public void addOutParamAsType(Class clazz, int FLAGS) {
        this.insertOutParamAt(this.outParams.size(), clazz, FLAGS);
    }

    public void addOutParamAsObject(Object outparam, int FLAGS) {
        this.insertOutParamAt(this.outParams.size(), outparam, FLAGS);
    }

    public void insertOutParamAt(int index, Object classOrInstance, int FLAGS) {
        this.outParams.add(index, classOrInstance);
        this.outparamFlags |= FLAGS;
    }

    public Object getOutParamAt(int index) {
        return this.outParams.get(index);
    }

    public void removeOutParamAt(int index, int FLAGS) {
        this.outParams.remove(index);
        this.outparamFlags &= ~FLAGS;
    }

    public void setOutParams(Object[] values, int FLAGS) {
        int i = 0;
        while (i < values.length) {
            this.outParams.add(values[i]);
            ++i;
        }
        this.outparamFlags = FLAGS;
    }

    public Object[] getResults() {
        return this.outparams;
    }

    public int getResultAsIntAt(int index) {
        this.checkIfCalled();
        return (Integer)this.outparams[index];
    }

    public float getResultAsFloatAt(int index) {
        this.checkIfCalled();
        return ((Float)this.outparams[index]).floatValue();
    }

    public boolean getResultAsBooleanAt(int index) {
        this.checkIfCalled();
        return (Boolean)this.outparams[index];
    }

    public short getResultAsShortAt(int index) {
        this.checkIfCalled();
        return (Short)this.outparams[index];
    }

    public double getResultAsDoubleAt(int index) {
        this.checkIfCalled();
        return (Double)this.outparams[index];
    }

    public char getResultAsCharacterAt(int index) {
        this.checkIfCalled();
        return ((Character)this.outparams[index]).charValue();
    }

    public JIString getResultAsStringAt(int index) {
        this.checkIfCalled();
        return (JIString)this.outparams[index];
    }

    public JIVariant getResultAsVariantAt(int index) {
        this.checkIfCalled();
        return (JIVariant)this.outparams[index];
    }

    public String getResultAsUUIDStrAt(int index) {
        this.checkIfCalled();
        return ((UUID)this.outparams[index]).toString();
    }

    public JIPointer getResultAsPointerAt(int index) {
        this.checkIfCalled();
        return (JIPointer)this.outparams[index];
    }

    public JIStruct getResultAsStructAt(int index) {
        this.checkIfCalled();
        return (JIStruct)this.outparams[index];
    }

    public JIArray getResultAsArrayAt(int index) {
        this.checkIfCalled();
        return (JIArray)this.outparams[index];
    }

    public Object[] getResultsInCaseOfException() {
        return this.resultsOfException;
    }

    public int getHRESULT() {
        return this.hresult;
    }

    private void checkIfCalled() {
        if (!this.executed) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4098));
        }
    }

    public Object[] getInParams() {
        return this.inParams.toArray();
    }

    public Object[] getOutParams() {
        return this.outParams.toArray();
    }

    public int getInparamFlags() {
        return this.inparamFlags;
    }

    public int getOutparamFlags() {
        return this.outparamFlags;
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void setOpnum(int num) {
        int dispatch = 0;
        if (!this.dispatchNotSupported) {
            dispatch = 4;
        }
        this.opnum = dispatch + num + 3;
    }

    void write2(NetworkDataRepresentation ndr) {
        ndr.getBuffer().buf = new byte[this.bufferLength() + 16];
        JIOrpcThat.encode(ndr);
        this.writePacket(ndr);
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.getBuffer().buf = new byte[this.bufferLength() + 16];
        JIOrpcThis orpcthis = new JIOrpcThis();
        orpcthis.encode(ndr);
        this.writePacket(ndr);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
    }

    private void writePacket(NetworkDataRepresentation ndr) {
        Object[] inparams = this.inParams.toArray();
        int index = 0;
        if (inparams != null) {
            if (JISystem.getLogLevel().intValue() < Level.FINE.intValue()) {
                String str = "";
                int i = 0;
                while (i < inparams.length) {
                    str = String.valueOf(str) + "In Param:[" + i + "] " + inparams[i] + "\n";
                    ++i;
                }
                JISystem.getLogger().finest(str);
            }
            while (index < inparams.length) {
                ArrayList listOfDefferedPointers = new ArrayList();
                if (inparams[index] == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    JIUtil.serialize(ndr, clazz, new Integer(0), listOfDefferedPointers, this.inparamFlags);
                } else {
                    JIUtil.serialize(ndr, inparams[index].getClass(), inparams[index], listOfDefferedPointers, this.inparamFlags);
                }
                int x = 0;
                while (x < listOfDefferedPointers.size()) {
                    ArrayList newList = new ArrayList();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jinterop.dcom.core.JIPointer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    JIUtil.serialize(ndr, clazz, (JIPointer)listOfDefferedPointers.get(x), newList, this.inparamFlags);
                    listOfDefferedPointers.addAll(++x, newList);
                }
                ++index;
            }
        }
    }

    public void read(NetworkDataRepresentation ndr) {
        JIOrpcThat orpcThat = JIOrpcThat.decode(ndr);
        this.readPacket(ndr);
        this.readResult(ndr);
    }

    void read2(NetworkDataRepresentation ndr) {
        JIOrpcThis.decode(ndr);
        this.readPacket(ndr);
    }

    private void readPacket(NetworkDataRepresentation ndr) {
        int index = 0;
        this.outparams = this.outParams.toArray();
        if (JISystem.getLogLevel().intValue() < Level.FINE.intValue()) {
            String str = "";
            int i = 0;
            while (i < this.outparams.length) {
                str = String.valueOf(str) + "Out Param:[" + i + "]" + this.outparams[i] + "\n";
                ++i;
            }
            JISystem.getLogger().finest(str);
        }
        HashMap additionalData = new HashMap();
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.outparams != null && this.outparams.length > 0) {
            while (index < this.outparams.length) {
                ArrayList listOfDefferedPointers = new ArrayList();
                results.add(JIUtil.deSerialize(ndr, this.outparams[index], listOfDefferedPointers, this.outparamFlags, additionalData));
                int x = 0;
                while (x < listOfDefferedPointers.size()) {
                    ArrayList newList = new ArrayList();
                    JIPointer replacement = (JIPointer)JIUtil.deSerialize(ndr, (JIPointer)listOfDefferedPointers.get(x), newList, this.outparamFlags, additionalData);
                    ((JIPointer)listOfDefferedPointers.get(x)).replaceSelfWithNewPointer(replacement);
                    listOfDefferedPointers.addAll(++x, newList);
                }
                ++index;
            }
        }
        this.outparams = results.toArray();
        this.executed = true;
    }

    private void readResult(NetworkDataRepresentation ndr) {
        this.hresult = ndr.readUnsignedLong();
        if (this.hresult != 0) {
            this.resultsOfException = this.outparams;
            this.outparams = null;
            throw new JIRuntimeException(this.hresult);
        }
    }

    private int bufferLength() {
        int length = 0;
        Object[] inparams = this.inParams.toArray();
        int i = 0;
        while (i < inparams.length) {
            if (inparams[i] == null) {
                length += 4;
            } else {
                int length2 = JIUtil.getLengthInBytes(inparams[i].getClass(), inparams[i], 0);
                length += length2;
            }
            ++i;
        }
        return length + 2048;
    }

    public boolean isError() {
        this.checkIfCalled();
        return this.hresult != 0;
    }
}

