/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.ObjectId;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIJavaCoClass;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntimeHelper;
import org.jinterop.dcom.core.JIComOxidStub;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JISetId;
import org.jinterop.dcom.core.JIStdObjRef;

final class JIComOxidRuntime {
    private static Properties defaults = new Properties();
    private static Properties defaults2 = new Properties();
    private static boolean stopSystem = false;
    private static boolean resolverStarted = false;
    private static ArrayList listOfSockets = new ArrayList();
    private static int oxidResolverPort = -1;
    private static HashMap mapOfIPIDVsComponent = new HashMap();
    private static HashMap mapOfJavaVsOxidDetails = new HashMap();
    private static HashMap mapOfOxidVsOxidDetails = new HashMap();
    private static HashMap mapOfOIDVsComponents = new HashMap();
    private static HashMap mapOfSetIdVsListOfOIDs = new HashMap();
    private static HashMap mapOfSessionVsPingSetHolder = new HashMap();
    private static HashMap mapOfAddressVsStub = new HashMap();
    private static List listOfExportedJavaComponents = new ArrayList();
    static final Object mutex = new Object();
    private static final Object mutex2 = new Object();
    private static final Object mutex3 = new Object();
    private static ServerSocket serverSocket = null;
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private static Timer pingTimer_2minutes = new Timer(true);
    private static Timer pingTimer_8minutes = new Timer(true);

    static {
        defaults2.put("rpc.ntlm.lanManagerKey", "false");
        defaults2.put("rpc.ntlm.sign", "false");
        defaults2.put("rpc.ntlm.seal", "false");
        defaults2.put("rpc.ntlm.keyExchange", "false");
        defaults2.put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeNTLMConnectionContext");
        defaults.put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeConnectionContext");
    }

    JIComOxidRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateOXIDs(JISession session, String IPID, JIObjectId oid) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder == null) {
                holder = new PingSetHolder();
                holder.username = session.getUserName();
                holder.password = session.getPassword();
                holder.domain = session.getDomain();
                holder.currentSetOIDs.add(oid);
                holder.modified = true;
                mapOfSessionVsPingSetHolder.put(session, holder);
            } else {
                int index = holder.currentSetOIDs.indexOf(oid);
                if (index != -1) {
                    oid = (JIObjectId)holder.currentSetOIDs.get(index);
                } else {
                    if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                        JISystem.getLogger().info("addUpdateOXIDs: Adding OID to holder " + holder + ", current size of currentSetOIDs is " + holder.currentSetOIDs.size());
                    }
                    holder.currentSetOIDs.add(oid);
                    holder.modified = true;
                }
            }
            oid.incrementIPIDRefCountBy1();
            if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                JISystem.getLogger().info("addUpdateOXIDs: finally this oid is " + oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delIPIDReference(String IPID, JIObjectId oid, JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                int index = holder.currentSetOIDs.indexOf(oid);
                if (index == -1) {
                    JISystem.getLogger().warning("In delIPIDReference: Could not find Original OID for this temp OID for session: " + session.getSessionIdentifier() + " , temp oid is " + oid + " , and IPID is " + IPID);
                    return;
                }
                oid = (JIObjectId)holder.currentSetOIDs.get(index);
                oid.decrementIPIDRefCountBy1();
                if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                    JISystem.getLogger().info("delIPIDReference: Decrementing reference count for IPID " + IPID + " on OID " + oid);
                }
                if (oid.getIPIDRefCount() <= 0 && JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                    JISystem.getLogger().info("delIPIDReference: Ref count is <= 0, for OID " + oid);
                }
            } else {
                JISystem.getLogger().warning("In delIPIDReference: Could not find PingSetHolder for this session: " + session.getSessionIdentifier() + " , temp oid is " + oid + " , and IPID is " + IPID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearIPIDsforSession(JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = (PingSetHolder)mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                    JISystem.getLogger().info("clearIPIDsforSession: holder.currentSetOIDs's size is " + holder.currentSetOIDs.size());
                }
                int i = 0;
                while (i < holder.currentSetOIDs.size()) {
                    JIObjectId oid = (JIObjectId)holder.currentSetOIDs.get(i);
                    oid.setIPIDRefCountTo0();
                    ++i;
                }
                holder.modified = true;
                holder.currentSetOIDs.clear();
                holder.closed = true;
            }
        }
    }

    static synchronized void startResolverTimer() {
        pingTimer_2minutes.scheduleAtFixedRate((TimerTask)new ClientPingTimerTask(), 0L, 300000L);
        pingTimer_8minutes.scheduleAtFixedRate((TimerTask)new ServerPingTimerTask(), 0L, 480000L);
    }

    static synchronized void startResolver() {
        if (resolverStarted) {
            return;
        }
        Runnable thread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JIComOxidRuntime.serverSocket = new ServerSocket(0);
                    oxidResolverPort = serverSocket.getLocalPort();
                    while (!stopSystem) {
                        Socket socket = serverSocket.accept();
                        listOfSockets.add(socket);
                        Object object = mutex;
                        synchronized (object) {
                            JISystem.setSocket(socket);
                            Properties properties = new Properties(defaults);
                            properties.put("IID", "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0".toUpperCase());
                            JIComOxidRuntimeHelper oxidResolver = new JIComOxidRuntimeHelper(properties);
                            oxidResolver.startOxid();
                        }
                    }
                }
                catch (IOException socket) {
                    // empty catch block
                }
                int i = 0;
                while (i < listOfSockets.size()) {
                    Socket s = (Socket)listOfSockets.get(i);
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        };
        Thread thread2 = new Thread(thread);
        thread2.setDaemon(true);
        thread2.start();
        resolverStarted = true;
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    static synchronized void stopResolver() {
        stopSystem = true;
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pingTimer_2minutes.cancel();
        pingTimer_8minutes.cancel();
        Iterator itr = mapOfAddressVsStub.values().iterator();
        while (itr.hasNext()) {
            JIComOxidStub s = (JIComOxidStub)((Object)itr.next());
            s.close();
        }
        mapOfAddressVsStub.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIInterfacePointer getInterfacePointer(JISession session, JIJavaCoClass component) throws JIException {
        JIInterfacePointer ptr = null;
        Object object = mutex2;
        synchronized (object) {
            JIComOxidDetails details = (JIComOxidDetails)mapOfJavaVsOxidDetails.get(component);
            if (details != null) {
                return details.getInterfacePtr();
            }
            String str = new ObjectId().toHexString();
            String ipid = str = String.valueOf(str.substring(0, 8)) + "-" + str.substring(8, 12) + "-" + str.substring(12, 16) + "-" + str.substring(16, 20) + "-" + str.substring(20);
            String iid = "00000000-0000-0000-c000-000000000046";
            byte[] bytes = new byte[8];
            randomGen.nextBytes(bytes);
            JIOxid oxid = new JIOxid(bytes);
            byte[] bytes2 = new byte[8];
            randomGen.nextBytes(bytes2);
            JIObjectId oid = new JIObjectId(bytes2);
            component.setObjectId(oid.getOID());
            JIStdObjRef objref = new JIStdObjRef(ipid, oxid, oid);
            ptr = new JIInterfacePointer(iid, oxidResolverPort, objref);
            Properties properties = new Properties(defaults2);
            properties.put("IID", "00000131-0000-0000-C000-000000000046:0.0".toUpperCase());
            properties.put("rpc.ntlm.domain", session.getTargetServer());
            JIComOxidRuntimeHelper remUnknown = new JIComOxidRuntimeHelper(properties);
            details = new JIComOxidDetails(component, oxid, oid, iid, ipid, ptr, remUnknown);
            mapOfJavaVsOxidDetails.put(component, details);
            mapOfOxidVsOxidDetails.put(oxid, details);
            mapOfOIDVsComponents.put(oid, component);
            listOfExportedJavaComponents.add(component);
            mapOfIPIDVsComponent.put(ipid, details);
            if (component.getAssociatedInterfacePointer() != null) {
                throw new JIException(4163);
            }
            component.setAssociatedInterfacePointer(ptr);
        }
        return ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getOxidDetails(JIOxid oxid) {
        Object object = mutex2;
        synchronized (object) {
            return (JIComOxidDetails)mapOfOxidVsOxidDetails.get(oxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getComponentFromIPID(String ipid) {
        Object object = mutex2;
        synchronized (object) {
            return (JIComOxidDetails)mapOfIPIDVsComponent.get(ipid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateSets(JISetId setId, ArrayList objectIdsAdded, ArrayList objectIdsDel) {
        Object object = mutex2;
        synchronized (object) {
            ArrayList listOfOIDs = (ArrayList)mapOfSetIdVsListOfOIDs.get(setId);
            if (listOfOIDs == null) {
                listOfOIDs = new ArrayList();
                listOfOIDs.addAll(objectIdsAdded);
                mapOfSetIdVsListOfOIDs.put(setId, listOfOIDs);
            } else {
                int i = 0;
                while (i < listOfOIDs.size()) {
                    JIObjectId oid = (JIObjectId)listOfOIDs.get(i);
                    if (!objectIdsDel.contains(oid)) {
                        oid.hasExpired();
                    }
                    ++i;
                }
                listOfOIDs.addAll(objectIdsAdded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIJavaCoClass getJavaComponentFromIPID(String ipid) {
        JIJavaCoClass component = null;
        Object object = mutex2;
        synchronized (object) {
            int i = 0;
            while (i < listOfExportedJavaComponents.size()) {
                component = (JIJavaCoClass)listOfExportedJavaComponents.get(i);
                if (component.getIIDFromIpid(ipid) != null) break;
                component = null;
                ++i;
            }
        }
        return component;
    }

    private static class PingSetHolder {
        byte[] setId = null;
        String username = null;
        String password = null;
        String domain = null;
        boolean modified = false;
        boolean closed = false;
        ArrayList currentSetOIDs = new ArrayList();

        private PingSetHolder() {
        }

        public String toString() {
            return "SetID[" + this.setId + "] , currentSetOIDs[" + this.currentSetOIDs + "]";
        }
    }

    private static class ServerPingTimerTask
    extends TimerTask {
        private ServerPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = mutex2;
            synchronized (object) {
                JISystem.getLogger().info("Running ServerPingTimerTask !");
                Iterator itr = mapOfOIDVsComponents.keySet().iterator();
                while (itr.hasNext()) {
                    JIObjectId oid = (JIObjectId)itr.next();
                    if (!oid.hasExpired()) continue;
                    JIJavaCoClass component = (JIJavaCoClass)mapOfOIDVsComponents.get(oid);
                    JIComOxidDetails details = (JIComOxidDetails)mapOfJavaVsOxidDetails.get(component);
                    mapOfOxidVsOxidDetails.remove(details.getOxid());
                    mapOfIPIDVsComponent.remove(details.getIpid());
                    mapOfJavaVsOxidDetails.remove(component);
                    listOfExportedJavaComponents.remove(component);
                    itr.remove();
                    component = null;
                    details = null;
                }
            }
        }
    }

    private static class ClientPingTimerTask
    extends TimerTask {
        private ClientPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = mutex3;
            synchronized (object) {
                JISystem.getLogger().info("Running ClientPingTimerTask !");
                Iterator itr = mapOfSessionVsPingSetHolder.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    PingSetHolder holder = (PingSetHolder)entry.getValue();
                    String address = ((JISession)entry.getKey()).getTargetServer();
                    JIComOxidStub stub = (JIComOxidStub)((Object)mapOfAddressVsStub.get(address));
                    if (stub == null) {
                        stub = new JIComOxidStub(address, holder.domain, holder.username, holder.password);
                        mapOfAddressVsStub.put(address, stub);
                    }
                    ArrayList<JIObjectId> listOfAddedOIDs = new ArrayList<JIObjectId>();
                    ArrayList<JIObjectId> listOfRemovedOIDs = new ArrayList<JIObjectId>();
                    if (holder.setId == null) {
                        listOfAddedOIDs.addAll(holder.currentSetOIDs);
                    } else {
                        Iterator itr2 = holder.currentSetOIDs.iterator();
                        while (itr2.hasNext()) {
                            JIObjectId oid = (JIObjectId)itr2.next();
                            if (oid.getIPIDRefCount() == 0) {
                                listOfRemovedOIDs.add(oid);
                                holder.modified = true;
                                itr2.remove();
                                continue;
                            }
                            listOfAddedOIDs.add(oid);
                        }
                        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                            JISystem.getLogger().info("Within ClientPingTimerTask: holder.currentSetOIDs, current size of which is " + holder.currentSetOIDs.size());
                        }
                    }
                    boolean isSimplePing = false;
                    if (holder.setId != null && !holder.modified) {
                        isSimplePing = true;
                    }
                    holder.setId = stub.call(isSimplePing, holder.setId, listOfAddedOIDs, listOfRemovedOIDs);
                    holder.modified = false;
                    if (!holder.closed) continue;
                    if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                        JISystem.getLogger().info("Within ClientPingTimerTask: Holder " + holder + " is empty, will remove this from mapOfSessionVsPingSetHolder, whose curent size is: " + mapOfSessionVsPingSetHolder.size());
                    }
                    itr.remove();
                }
            }
        }
    }
}

