/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JICallObject;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JIRemActivation;
import org.jinterop.dcom.core.JIRemUnknown;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIStdObjRef;
import org.jinterop.dcom.core.JIStringBinding;
import org.jinterop.dcom.transport.JIComEndpoint;
import org.jinterop.dcom.transport.JIComTransportFactory;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;
import rpc.FaultException;
import rpc.Stub;
import rpc.TransportFactory;
import rpc.core.UUID;

public class JIComServer
extends Stub {
    private static Properties defaults = new Properties();
    private JIRemActivation remoteActivation = null;
    private String clsid = null;
    private String syntax = null;
    private JISession session = null;
    private String unknownIPID = null;
    private final Object mutex = new Object();

    static {
        defaults.put("rpc.ntlm.lanManagerKey", "false");
        defaults.put("rpc.ntlm.sign", "false");
        defaults.put("rpc.ntlm.seal", "false");
        defaults.put("rpc.ntlm.keyExchange", "false");
        defaults.put("rpc.connectionContext", "rpc.security.ntlm.NtlmConnectionContext");
    }

    private JIComServer() {
    }

    public JIComServer(JIProgId progId, JISession session) throws JIException, UnknownHostException {
        this(progId, InetAddress.getLocalHost().getHostAddress(), session);
    }

    public JIComServer(JIClsid clsid, JISession session) throws IllegalArgumentException, JIException, UnknownHostException {
        this(clsid, InetAddress.getLocalHost().getHostAddress(), session);
    }

    public JIComServer(JIProgId progId, String address, JISession session) throws JIException, UnknownHostException {
        if (progId == null || address == null || session == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4109));
        }
        if (session.getStub() != null) {
            throw new JIException(4099);
        }
        address = address.trim();
        address = InetAddress.getByName(address).getHostAddress();
        progId.setServer(address);
        address = "ncacn_ip_tcp:" + address + "[135]";
        JIClsid clsid = progId.getCorrespondingCLSID();
        this.initialise(clsid, address, session);
    }

    public JIComServer(JIClsid clsid, String address, JISession session) throws IllegalArgumentException, JIException, UnknownHostException {
        if (clsid == null || address == null || session == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4109));
        }
        if (session.getStub() != null) {
            throw new JIException(4099);
        }
        address = address.trim();
        address = "ncacn_ip_tcp:" + InetAddress.getByName(address).getHostAddress() + "[135]";
        this.initialise(clsid, address, session);
    }

    private void initialise(JIClsid clsid, String address, JISession session) throws JIException {
        super.setTransportFactory((TransportFactory)JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(defaults));
        super.getProperties().setProperty("rpc.security.username", session.getUserName());
        super.getProperties().setProperty("rpc.security.password", session.getPassword());
        super.getProperties().setProperty("rpc.ntlm.domain", session.getDomain());
        super.setAddress(address);
        this.clsid = clsid.getCLSID().toUpperCase();
        this.session = session;
        this.session.setStub(this);
        this.session.setTargetServer(address.substring(address.indexOf(":") + 1, address.indexOf("[")));
        try {
            this.init();
        }
        catch (JIException e) {
            if (e.getErrorCode() == -2147221164) {
                JISystem.getLogger().warning("Got the class not registered exception , will attempt setting entries based on status flags...");
                if (JISystem.isAutoRegistrationSet() || clsid.isAutoRegistrationSet()) {
                    try {
                        IJIWinReg registry = null;
                        registry = JIWinRegFactory.getSingleTon().getWinreg(new JIDefaultAuthInfoImpl(session.getDomain(), session.getUserName(), session.getPassword()), session.getTargetServer(), true);
                        JIPolicyHandle hkcr = registry.winreg_OpenHKCR();
                        JIPolicyHandle key = registry.winreg_CreateKey(hkcr, "CLSID\\{" + this.clsid + "}", 0, 983103);
                        registry.winreg_SetValue(key, "AppID", ("{" + this.clsid + "}").getBytes(), false, false);
                        registry.winreg_CloseKey(key);
                        key = registry.winreg_CreateKey(hkcr, "AppID\\{" + this.clsid + "}", 1, 983103);
                        registry.winreg_SetValue(key, "DllSurrogate", "  ".getBytes(), false, false);
                        registry.winreg_CloseKey(key);
                        registry.winreg_CloseKey(hkcr);
                    }
                    catch (UnknownHostException e1) {
                        JISystem.getLogger().exception("", "", e1);
                        throw new JIException(4148, (Throwable)e1);
                    }
                    this.init();
                }
                throw e;
            }
            throw e;
        }
    }

    private void init() throws JIException {
        if (this.remoteActivation != null && this.remoteActivation.isActivationSuccessful()) {
            return;
        }
        try {
            this.syntax = "4d9f4ab8-7d1c-11cf-861e-0020af6e7c57:0.0";
            this.remoteActivation = new JIRemActivation(this.clsid);
            this.call(2, this.remoteActivation);
        }
        catch (FaultException e) {
            this.remoteActivation = null;
            throw new JIException(e.status, (Throwable)((Object)e));
        }
        catch (IOException e) {
            this.remoteActivation = null;
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e1) {
            this.remoteActivation = null;
            throw new JIException(e1);
        }
        this.syntax = "00000143-0000-0000-c000-000000000046:0.0";
        JIStringBinding[] bindings = this.remoteActivation.getDualStringArrayForOxid().getStringBindings();
        int i = 0;
        JIStringBinding binding = null;
        JIStringBinding nameBinding = null;
        String targetAddress = this.getAddress();
        targetAddress = targetAddress.substring(targetAddress.indexOf(58) + 1, targetAddress.indexOf(91));
        while (i < bindings.length) {
            block11: {
                binding = bindings[i];
                int index = binding.getNetworkAddress().indexOf(".");
                if (index != -1) {
                    try {
                        index = binding.getNetworkAddress().indexOf("[");
                        if (index != -1 && binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) {
                            break;
                        }
                        break block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block11;
                    }
                }
                nameBinding = binding;
                index = binding.getNetworkAddress().indexOf("[");
                if (binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) break;
            }
            ++i;
        }
        if (binding == null) {
            binding = nameBinding;
        }
        this.setAddress("ncacn_ip_tcp:" + binding.getNetworkAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IJIComObject getInterface(String iid, String ipidOfTheTargetUnknown) throws JIException {
        IJIComObject retval = null;
        byte[] oid = null;
        Object object = this.mutex;
        synchronized (object) {
            this.setObject(this.remoteActivation.getIPID());
            JIRemUnknown reqUnknown = new JIRemUnknown(ipidOfTheTargetUnknown, iid, 5);
            try {
                this.call(2, reqUnknown);
            }
            catch (FaultException e) {
                throw new JIException(e.status, (Throwable)((Object)e));
            }
            catch (IOException e) {
                throw new JIException(-2147352577, (Throwable)e);
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
            retval = this.getObject(reqUnknown.getObjectReference().getIpid(), iid);
            oid = reqUnknown.getObjectReference().getObjectId();
            if (!iid.equalsIgnoreCase("00020400-0000-0000-c000-000000000046")) {
                JIRemUnknown dispatch = new JIRemUnknown(reqUnknown.getObjectReference().getIpid(), "00020400-0000-0000-c000-000000000046", 5);
                try {
                    this.call(2, dispatch);
                }
                catch (FaultException e) {
                    throw new JIException(e.status, (Throwable)((Object)e));
                }
                catch (IOException e) {
                    throw new JIException(-2147352577, (Throwable)e);
                }
                catch (JIRuntimeException jIRuntimeException) {
                    // empty catch block
                }
                if (dispatch.isSuccessful() && dispatch.getHresult() == 0) {
                    ((JIComObjectImpl)retval).isDual = true;
                    this.session.releaseRef(dispatch.getObjectReference().getIpid());
                }
            }
        }
        this.session.addToSession(retval, oid);
        return retval;
    }

    private IJIComObject getObject(String ipid, String iid) {
        return new JIComObjectImpl(this, ipid, iid, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJIComObject createInstance() throws JIException {
        IJIComObject comObject = null;
        byte[] oid = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.unknownIPID != null) {
                throw new JIException(4097, null);
            }
            JIStdObjRef objRef = (JIStdObjRef)this.remoteActivation.getMInterfacePointer().getObjectReference(1);
            this.unknownIPID = objRef.getIpid();
            comObject = this.getObject(this.unknownIPID, "00000000-0000-0000-c000-000000000046");
            oid = objRef.getObjectId();
            if (this.remoteActivation.isDual) {
                this.session.releaseRef(this.remoteActivation.dispIpid);
                this.remoteActivation.dispIpid = null;
                ((JIComObjectImpl)comObject).isDual = true;
            }
        }
        this.session.addToSession(comObject, oid);
        return comObject;
    }

    protected String getSyntax() {
        return this.syntax;
    }

    String getIpid() {
        if (this.remoteActivation != null && this.remoteActivation.isActivationSuccessful()) {
            return this.remoteActivation.getIPID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] call(JICallObject obj, String targetIID) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.attach();
                if (!this.getEndpoint().getSyntax().getUuid().toString().equalsIgnoreCase(targetIID)) {
                    this.getEndpoint().getSyntax().setUuid(new UUID(targetIID));
                    this.getEndpoint().getSyntax().setVersion(0, 0);
                    ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
                }
                this.setObject(obj.getParentIpid());
                this.call(2, obj);
            }
            catch (FaultException e) {
                throw new JIException(e.status, (Throwable)((Object)e));
            }
            catch (IOException e) {
                throw new JIException(-2147352577, (Throwable)e);
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
            return obj.getResults();
        }
    }

    JIRemActivation getActivated() {
        return this.remoteActivation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef_ReleaseRef(JICallObject obj) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.remoteActivation == null) {
                return;
            }
            obj.setParentIpid(this.remoteActivation.getIPID());
            try {
                this.call(obj, "00000143-0000-0000-c000-000000000046");
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
        }
    }

    void closeStub() {
        try {
            this.detach();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

