/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import jcifs.util.Hexdump;

final class JIObjectId
implements Serializable {
    private static final long serialVersionUID = -4335536047242439700L;
    private final byte[] oid;
    private int refcountofIPID = 0;
    private long lastPingTime = System.currentTimeMillis();

    int getIPIDRefCount() {
        return this.refcountofIPID;
    }

    boolean hasExpired() {
        if (System.currentTimeMillis() - this.lastPingTime > 480000L) {
            return true;
        }
        this.lastPingTime = System.currentTimeMillis();
        return false;
    }

    void setIPIDRefCountTo0() {
        this.refcountofIPID = 0;
    }

    void decrementIPIDRefCountBy1() {
        --this.refcountofIPID;
    }

    void incrementIPIDRefCountBy1() {
        ++this.refcountofIPID;
    }

    JIObjectId(byte[] oid) {
        this.oid = oid;
    }

    byte[] getOID() {
        return this.oid;
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.oid.length) {
            result = 31 * result + this.oid[i];
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JIObjectId)) {
            return false;
        }
        return Arrays.equals(this.oid, ((JIObjectId)obj).getOID());
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.oid, (int)0, (int)this.oid.length);
        return "{ IPID ref count is " + this.refcountofIPID + " } \n and OID in bytes[] " + byteArrayOutputStream.toString() + " } ";
    }
}

