/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import org.jinterop.dcom.core.JIStdObjRef;
import rpc.core.UUID;

final class JIRemUnknown
extends NdrObject {
    public static final String IID = "00000143-0000-0000-c000-000000000046";
    private String ipidOfIUnknown = null;
    private String requestedIID = null;
    private int requestedPublicRefs = 5;
    private JIOrpcThat orpcthat = null;
    private int hresult = -1;
    private JIStdObjRef stdObjRef = null;
    private boolean isSuccessful = false;

    JIRemUnknown(String ipidOfIUnknown, String requestedIID, int requestedPublicRefs) {
        this.ipidOfIUnknown = ipidOfIUnknown;
        this.requestedIID = requestedIID;
        this.requestedPublicRefs = requestedPublicRefs;
    }

    public int getOpnum() {
        return 3;
    }

    public void write(NetworkDataRepresentation ndr) {
        JIOrpcThis orpcthis = new JIOrpcThis();
        orpcthis.encode(ndr);
        UUID uuid = new UUID(this.ipidOfIUnknown);
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().exception("", "", e);
        }
        ndr.writeUnsignedLong(this.requestedPublicRefs);
        ndr.writeUnsignedShort(1);
        ndr.writeUnsignedShort(0);
        ndr.writeUnsignedLong(1);
        uuid = new UUID(this.requestedIID);
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().exception("", "", e);
        }
        ndr.writeUnsignedLong(0);
    }

    public void read(NetworkDataRepresentation ndr) {
        this.orpcthat = JIOrpcThat.decode(ndr);
        int ptr = ndr.readUnsignedLong();
        if (ptr == 0) {
            this.hresult = ndr.readUnsignedLong();
            this.isSuccessful = false;
            throw new JIRuntimeException(this.hresult);
        }
        int length = ndr.readUnsignedLong();
        this.hresult = ndr.readUnsignedLong();
        if (this.hresult != 0) {
            this.isSuccessful = false;
            throw new JIRuntimeException(this.hresult);
        }
        ndr.readUnsignedLong();
        this.stdObjRef = JIStdObjRef.decode(ndr);
        this.isSuccessful = true;
    }

    public JIOrpcThat getORPCThat() {
        return this.orpcthat;
    }

    public int getHresult() {
        return this.hresult;
    }

    public JIStdObjRef getObjectReference() {
        return this.stdObjRef;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }
}

