/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallObject;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIStruct;
import rpc.core.UUID;

public final class JISession {
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private int sessionIdentifier = -1;
    private String username = null;
    private String password = null;
    private String domain = null;
    private String targetServer = null;
    private boolean isSTA = true;
    private static Map mapOfObjects = new HashMap();
    private static Object mutex = new Object();
    private IJIAuthInfo authInfo = null;
    private JIComServer stub = null;
    private static int oxidResolverPort = -1;
    private static byte[] localhost;
    private static String localhostStr;
    private static String localhostStr2;
    private static Map mapOfSessionIdsVsSessions;
    private static List listOfSessions;
    private List listOfDeferencedIpids = new ArrayList();
    private static Timer releaseRefsTimer;
    private Map mapOfUnreferencedHandlers = new HashMap();
    static ReferenceQueue referenceQueueOfCOMObjects;
    static Thread cleanUpThread;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        localhost = byArray;
        localhostStr = "127.0.0.1";
        localhostStr2 = "LOCALHOST";
        mapOfSessionIdsVsSessions = new HashMap();
        listOfSessions = new ArrayList();
        releaseRefsTimer = new Timer(true);
        referenceQueueOfCOMObjects = new ReferenceQueue();
        cleanUpThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if ((r = JISession.referenceQueueOfCOMObjects.remove()) == null) {
                            continue;
                        }
                        var2_3 = JISession.access$0();
                        synchronized (var2_3) {
                            holder = (IPID_SessionID_Holder)JISession.access$1().remove(r);
                            session = null;
                            if (holder == null) {
                                continue;
                            }
                            session = (JISession)JISession.access$2().get(holder.sessionID);
                            if (holder.isOnlySessionIDPresent) {
                                try {
                                    JISession.destroySession(session);
                                }
                                catch (Exception e) {
                                    JISystem.getLogger().finest("exception from destroy session in clean up thread: " + e.getMessage());
                                }
                            } else {
                                if (session == null) {
                                    continue;
                                }
                                try {
                                    IPID = holder.IPID;
                                    JISession.access$3(session, IPID, holder.oid);
                                    holder = null;
                                    unreferenced = (IJIUnreferenced)JISession.access$4(session).get(IPID);
                                    if (unreferenced != null) {
                                        unreferenced.unReferenced();
                                    }
                                    session.unregisterUnreferencedHandler(IPID);
                                }
                                catch (Exception e) {
                                    JISystem.getLogger().info("exception from removing a IPID from session in clean up thread: " + e.getMessage());
                                }
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    JISystem.getLogger().exception("", "", e);
                    return;
                }
                {
                    ** while (true)
                }
            }
        });
        JISystem.getLogger();
        try {
            InetAddress localhostAddr = InetAddress.getLocalHost();
            localhost = localhostAddr.getAddress();
            localhostStr = localhostAddr.getHostAddress();
            localhostStr2 = localhostAddr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.setProperty("jcifs.smb.client.domain", "JIDomain");
        cleanUpThread.setDaemon(true);
        cleanUpThread.start();
        JIComOxidRuntime.startResolver();
        JIComOxidRuntime.startResolverTimer();
        oxidResolverPort = JIComOxidRuntime.getOxidResolverPort();
        releaseRefsTimer.scheduleAtFixedRate((TimerTask)new Release_References_TimerTask(), 0L, 180000L);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < listOfSessions.size()) {
                    JISession session = (JISession)listOfSessions.get(i);
                    try {
                        JISession.destroySession(session);
                    }
                    catch (JIException e) {
                        JISystem.getLogger().exception("", "", e);
                    }
                }
                JISystem.writeProgIdsToFile();
                JIComOxidRuntime.stopResolver();
                releaseRefsTimer.cancel();
                mapOfSessionIdsVsSessions.clear();
                mapOfObjects.clear();
                listOfSessions.clear();
            }
        }));
    }

    private static String getLocalHost(String destination) {
        InetAddress intendedDestination;
        DatagramSocket sock;
        try {
            sock = new DatagramSocket();
            intendedDestination = InetAddress.getByName(destination);
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
        sock.connect(intendedDestination, sock.getLocalPort());
        return sock.getLocalAddress().getHostAddress();
    }

    void setTargetServer(String targetServer) {
        if (targetServer.equalsIgnoreCase("127.0.0.1")) {
            this.targetServer = JISession.getLocalhostAddressAsIPString();
        } else {
            this.targetServer = targetServer;
            if (localhostStr.equalsIgnoreCase("127.0.0.1")) {
                localhostStr = JISession.getLocalHost(targetServer);
            }
        }
    }

    static byte[] getLocalhostAddressAsIPbytes() {
        return localhost;
    }

    static String getLocalhostAddressAsIPString() {
        return localhostStr;
    }

    static String getLocalhostCanonicalAddressAsString() {
        return localhostStr2;
    }

    String getTargetServer() {
        return this.targetServer;
    }

    private JISession() {
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    public IJIAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public static JISession createSession(IJIAuthInfo authInfo) {
        return JISession.createSession(authInfo, true);
    }

    public static JISession createSession(IJIAuthInfo authInfo, boolean isSTA) {
        if (authInfo == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.authInfo = authInfo;
        session.isSTA = isSTA;
        session.sessionIdentifier = authInfo.getUserName().hashCode() ^ authInfo.getPassword().hashCode() ^ authInfo.getDomain().hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
        listOfSessions.add(session);
        JISystem.getLogger().info("Created Session: " + session.sessionIdentifier);
        return session;
    }

    public static JISession createSession(String domain, String username, String password, boolean isSTA) {
        if (username == null || password == null || domain == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.username = username;
        session.password = password;
        session.domain = domain;
        session.isSTA = isSTA;
        session.sessionIdentifier = username.hashCode() ^ password.hashCode() ^ domain.hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
        listOfSessions.add(session);
        JISystem.getLogger().info("Created Session: " + session.sessionIdentifier);
        return session;
    }

    public static JISession createSession(String domain, String username, String password) {
        return JISession.createSession(domain, username, password, true);
    }

    public static JISession createSession(JISession session, boolean isSTA) {
        JISession newSession = JISession.createSession(session.getDomain(), session.getUserName(), session.getPassword(), isSTA);
        newSession.authInfo = session.authInfo;
        return newSession;
    }

    public static JISession createSession(JISession session) {
        JISession newSession = JISession.createSession(session.getDomain(), session.getUserName(), session.getPassword());
        newSession.authInfo = session.authInfo;
        return newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void destroySession(JISession session) throws JIException {
        var1_1 = JISession.mutex;
        synchronized (var1_1) {
            block19: {
                block17: {
                    try {
                        block18: {
                            if (session.stub == null) {
                                var6_2 = null;
                                if (session.stub != null) {
                                    session.stub.closeStub();
                                    session.stub = null;
                                }
                                JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                                break block17;
                            }
                            list = new ArrayList<JIStruct>();
                            iterator = JISession.mapOfObjects.keySet().iterator();
                            while (true) {
                                if (!iterator.hasNext()) break;
                                holder = (IPID_SessionID_Holder)JISession.mapOfObjects.get(iterator.next());
                                if (session.getSessionIdentifier() != holder.sessionID.intValue() || (ipid = holder.IPID) == null) continue;
                                list.add(session.prepareForReleaseRef(ipid));
                            }
                            j = 0;
                            while (true) {
                                if (j >= session.listOfDeferencedIpids.size()) {
                                    session.listOfDeferencedIpids.clear();
                                    if (session.stub != null && session.stub.getActivated() != null && session.stub.getActivated().getMInterfacePointer() != null) {
                                        list.add(session.prepareForReleaseRef(session.stub.getActivated().getMInterfacePointer().getIPID()));
                                    }
                                    if (list.size() > 0) {
                                        array = new JIArray(list.toArray(new JIStruct[list.size()]), true);
                                        ** try [egrp 2[TRYBLOCK] [0 : 251->260)] { 
lbl32:
                                        // 1 sources

                                        break;
                                    }
                                    break block18;
                                }
                                list.add(session.prepareForReleaseRef((String)session.listOfDeferencedIpids.get(j)));
                                ++j;
                            }
                            {
                                session.releaseRefs(array);
                            }
lbl40:
                            // 1 sources

                            catch (JIException e) {
                                JISystem.getLogger().exception(null, null, e);
                            }
                        }
                        JIComOxidRuntime.clearIPIDsforSession(session);
                        JISystem.getLogger().info("Destroyed Session: " + session.sessionIdentifier);
                        break block19;
                    }
                    catch (Throwable var7_12) {
                        var6_3 = null;
                        if (session.stub != null) {
                            session.stub.closeStub();
                            session.stub = null;
                        }
                        JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                        JISession.listOfSessions.remove(session);
                        throw var7_12;
                    }
                }
                JISession.listOfSessions.remove(session);
                return;
            }
            var6_4 = null;
            if (session.stub != null) {
                session.stub.closeStub();
                session.stub = null;
            }
            JISession.mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
            JISession.listOfSessions.remove(session);
            return;
        }
    }

    void setStub(JIComServer stub) {
        this.stub = stub;
    }

    JIComServer getStub() {
        return this.stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSession(IJIComObject comObject, byte[] oid) {
        IPID_SessionID_Holder holder = new IPID_SessionID_Holder(comObject.getIpid(), this.getSessionIdentifier(), false, oid);
        Object object = mutex;
        synchronized (object) {
            mapOfObjects.put(new WeakReference<IJIComObject>(comObject, referenceQueueOfCOMObjects), holder);
        }
        this.addToSession(comObject.getIpid(), oid);
        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
            JISystem.getLogger().info(" for IID: " + comObject.getInterfaceIdentifier());
        }
    }

    private void addToSession(String IPID, byte[] oid) {
        JIObjectId joid = new JIObjectId(oid);
        JIComOxidRuntime.addUpdateOXIDs(this, IPID, joid);
        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
            JISystem.getLogger().info("[addToSession] Adding IPID: " + IPID + " to session: " + this.getSessionIdentifier());
        }
    }

    void releaseRef(String IPID) throws JIException {
        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
            JISystem.getLogger().info("releaseRef:Reclaiming from Session: " + this.getSessionIdentifier() + " , the IPID: " + IPID);
        }
        JICallObject obj = new JICallObject(IPID, true);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(IPID)}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(5, 0);
        obj.addInParamAsInt(0, 0);
        this.stub.addRef_ReleaseRef(obj);
    }

    private void addDereferencedIpids(String IPID, byte[] oid) {
        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
            JISystem.getLogger().info("addDereferencedIpids for session : " + this.getSessionIdentifier() + " , IPID is: " + IPID);
        }
        this.listOfDeferencedIpids.add(IPID);
        JIComOxidRuntime.delIPIDReference(IPID, new JIObjectId(oid), this);
    }

    private void releaseRefs(JIArray arrayOfStructs) throws JIException {
        if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
            JISystem.getLogger().info("In releaseRefs for session : " + this.getSessionIdentifier() + " , array length is: " + (short)((Object[])arrayOfStructs.getArrayInstance()).length);
        }
        JICallObject obj = new JICallObject(null, true);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)((Object[])arrayOfStructs.getArrayInstance()).length, 0);
        obj.addInParamAsArray(arrayOfStructs, 0);
        this.stub.addRef_ReleaseRef(obj);
    }

    private JIStruct prepareForReleaseRef(String IPID) throws JIException {
        JIStruct remInterface = new JIStruct();
        remInterface.addMember(new UUID(IPID));
        remInterface.addMember(new Integer(5));
        remInterface.addMember(new Integer(0));
        return remInterface;
    }

    public String getUserName() {
        return this.authInfo == null ? this.username : this.authInfo.getUserName();
    }

    String getPassword() {
        return this.authInfo == null ? this.password : this.authInfo.getPassword();
    }

    public String getDomain() {
        return this.authInfo == null ? this.domain : this.authInfo.getDomain();
    }

    public boolean isSTA() {
        return this.isSTA;
    }

    public int getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JISession)) {
            return false;
        }
        JISession temp = (JISession)obj;
        return temp.sessionIdentifier == this.sessionIdentifier;
    }

    public int hashCode() {
        return this.sessionIdentifier;
    }

    protected void finalize() {
        try {
            JISession.destroySession(this);
        }
        catch (JIException e) {
            JISystem.getLogger().finest("Exception in finalize when destroying session " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IJIUnreferenced getUnreferencedHandler(String ipid) {
        Object object = mutex;
        synchronized (object) {
            return (IJIUnreferenced)this.mapOfUnreferencedHandlers.get(ipid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerUnreferencedHandler(String ipid, IJIUnreferenced unreferenced) {
        Object object = mutex;
        synchronized (object) {
            this.mapOfUnreferencedHandlers.put(ipid, unreferenced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterUnreferencedHandler(String ipid) {
        Object object = mutex;
        synchronized (object) {
            this.mapOfUnreferencedHandlers.remove(ipid);
        }
    }

    static /* synthetic */ void access$3(JISession jISession, String string, byte[] byArray) {
        jISession.addDereferencedIpids(string, byArray);
    }

    static /* synthetic */ Map access$4(JISession jISession) {
        return jISession.mapOfUnreferencedHandlers;
    }

    private static class IPID_SessionID_Holder {
        public final String IPID;
        public final Integer sessionID;
        public final boolean isOnlySessionIDPresent;
        public final byte[] oid;

        private IPID_SessionID_Holder(String IPID, int sessionID, boolean isOnlySessionId, byte[] oid) {
            this.IPID = IPID;
            this.isOnlySessionIDPresent = isOnlySessionId;
            this.sessionID = new Integer(sessionID);
            this.oid = oid;
        }
    }

    private static class Release_References_TimerTask
    extends TimerTask {
        private Release_References_TimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = mutex;
            synchronized (object) {
                int i = 0;
                while (i < listOfSessions.size()) {
                    JISession session = (JISession)listOfSessions.get(i);
                    ArrayList<JIStruct> listToKill = new ArrayList<JIStruct>();
                    int j = 0;
                    while (j < session.listOfDeferencedIpids.size()) {
                        try {
                            listToKill.add(session.prepareForReleaseRef((String)session.listOfDeferencedIpids.get(j)));
                        }
                        catch (JIException jIException) {
                            // empty catch block
                        }
                        ++j;
                    }
                    if (JISystem.getLogLevel().intValue() <= Level.INFO.intValue()) {
                        JISystem.getLogger().info("Release_References_TimerTask:[RUN] Session:  " + session.getSessionIdentifier() + " , listOfDeferencedIpids: " + session.listOfDeferencedIpids);
                    }
                    session.listOfDeferencedIpids.clear();
                    if (listToKill.size() > 0) {
                        JIArray array = new JIArray(listToKill.toArray(new JIStruct[listToKill.size()]), true);
                        try {
                            session.releaseRefs(array);
                        }
                        catch (JIException e) {
                            JISystem.getLogger().exception(null, null, e);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

