/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JIUtil;
import rpc.core.UUID;

final class JIStdObjRef
implements Serializable {
    private static final long serialVersionUID = 7714589108476632990L;
    private int flags = 0;
    private int publicRefs = -1;
    private byte[] oxid = null;
    private byte[] oid = null;
    private String ipidOfthisObjectRef = null;

    private JIStdObjRef() {
    }

    JIStdObjRef(String ipid, JIOxid oxid, JIObjectId oid) {
        this.ipidOfthisObjectRef = ipid;
        this.oxid = oxid.getOXID();
        this.oid = oid.getOID();
        this.publicRefs = 5;
    }

    static JIStdObjRef decode(NetworkDataRepresentation ndr) {
        JIStdObjRef objRef = new JIStdObjRef();
        objRef.flags = ndr.readUnsignedLong();
        objRef.publicRefs = ndr.readUnsignedLong();
        objRef.oxid = JIUtil.readOctetArrayLE(ndr, 8);
        objRef.oid = JIUtil.readOctetArrayLE(ndr, 8);
        try {
            UUID ipid2 = new UUID();
            ipid2.decode(ndr, ndr.getBuffer());
            objRef.ipidOfthisObjectRef = ipid2.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().exception("", "", e);
        }
        return objRef;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getPublicRefs() {
        return this.publicRefs;
    }

    public byte[] getOxid() {
        return this.oxid;
    }

    public byte[] getObjectId() {
        return this.oid;
    }

    public String getIpid() {
        return this.ipidOfthisObjectRef;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedLong(this.flags);
        ndr.writeUnsignedLong(this.publicRefs);
        JIUtil.writeOctetArrayLE(ndr, this.oxid);
        JIUtil.writeOctetArrayLE(ndr, this.oid);
        try {
            UUID ipid = new UUID(this.ipidOfthisObjectRef);
            ipid.encode(ndr, ndr.getBuffer());
        }
        catch (NdrException e) {
            JISystem.getLogger().exception("", "", e);
        }
    }

    public String toString() {
        String retVal = "IPID: " + this.ipidOfthisObjectRef;
        return retVal;
    }
}

