/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcifs.util.Encdec;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIInterfacePointerBody;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnion;
import org.jinterop.dcom.core.JIUnsigned;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.core.VariantBody;
import org.jinterop.dcom.win32.JIDispatchImpl;
import rpc.core.UUID;

final class JIUtil {
    private static Map mapOfSerializers = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz, new DateImpl());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jinterop.dcom.core.JICurrency");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz2, new JICurrencyImpl());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.jinterop.dcom.core.VariantBody");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz3, new JIVariant2Impl());
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.jinterop.dcom.core.JIVariant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz4, new JIVariantImpl());
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz5, new DoubleImpl());
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz6, new BooleanImpl());
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz7, new ShortImpl());
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz8, new IntegerImpl());
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz9, new FloatImpl());
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz10, new StringImpl());
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("rpc.core.UUID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz11, new UUIDImpl());
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz12, new ByteImpl());
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz13, new LongImpl());
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz14, new CharacterImpl());
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.jinterop.dcom.core.JIInterfacePointer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz15, new MInterfacePointerImpl());
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.jinterop.dcom.core.JIInterfacePointerBody");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz16, new MInterfacePointerImpl2());
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.jinterop.dcom.win32.JIDispatchImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz17, new IJIDispatchImpl());
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("org.jinterop.dcom.core.JIComObjectImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz18, new IJIUnknownImpl());
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("org.jinterop.dcom.core.JIPointer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz19, new PointerImpl());
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz20, new StructImpl());
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("org.jinterop.dcom.core.JIUnion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz21, new UnionImpl());
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("org.jinterop.dcom.core.JIString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz22, new JIStringImpl());
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("org.jinterop.dcom.core.JIUnsignedByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz23, new JIUnsignedByteImpl());
        Class<?> clazz24 = class$23;
        if (clazz24 == null) {
            try {
                clazz24 = class$23 = Class.forName("org.jinterop.dcom.core.JIUnsignedShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz24, new JIUnsignedShortImpl());
        Class<?> clazz25 = class$24;
        if (clazz25 == null) {
            try {
                clazz25 = class$24 = Class.forName("org.jinterop.dcom.core.JIUnsignedInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapOfSerializers.put(clazz25, new JIUnsignedIntImpl());
    }

    JIUtil() {
    }

    static byte[] readOctetArrayLE(NetworkDataRepresentation ndr, int length) {
        byte[] bytes = new byte[8];
        ndr.readOctetArray(bytes, 0, 8);
        int i = 0;
        while (i < 4) {
            byte t = bytes[i];
            bytes[i] = bytes[7 - i];
            bytes[7 - i] = t;
            ++i;
        }
        return bytes;
    }

    static void writeOctetArrayLE(NetworkDataRepresentation ndr, byte[] b) {
        int i = 0;
        while (i < b.length) {
            ndr.writeUnsignedSmall((int)b[b.length - i - 1]);
            ++i;
        }
    }

    static void serialize(NetworkDataRepresentation ndr, Class c, Object value, List defferedPointers, int FLAG) {
        Class<?> clazz = class$25;
        if (clazz == null) {
            try {
                clazz = class$25 = Class.forName("org.jinterop.dcom.core.JIArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz)) {
            ((JIArray)value).encode(ndr, ((JIArray)value).getArrayInstance(), defferedPointers, FLAG);
        } else {
            JIUtil.alignMemberWhileEncoding(ndr, c, value);
            Class<?> clazz2 = class$21;
            if (clazz2 == null) {
                try {
                    clazz2 = class$21 = Class.forName("org.jinterop.dcom.core.JIString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz2)) {
                ((JIString)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz3 = class$18;
            if (clazz3 == null) {
                try {
                    clazz3 = class$18 = Class.forName("org.jinterop.dcom.core.JIPointer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz3)) {
                ((JIPointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz4 = class$19;
            if (clazz4 == null) {
                try {
                    clazz4 = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz4)) {
                ((JIStruct)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz5 = class$20;
            if (clazz5 == null) {
                try {
                    clazz5 = class$20 = Class.forName("org.jinterop.dcom.core.JIUnion");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz5)) {
                ((JIUnion)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz6 = class$16;
            if (clazz6 == null) {
                try {
                    clazz6 = class$16 = Class.forName("org.jinterop.dcom.win32.JIDispatchImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz6)) {
                IJIComObject unknown = ((JIDispatchImpl)value).getCOMObject();
                JIInterfacePointer interfacePointer = new JIInterfacePointer("00020400-0000-0000-c000-000000000046", unknown.getInterfacePointer());
                interfacePointer.encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz7 = class$17;
            if (clazz7 == null) {
                try {
                    clazz7 = class$17 = Class.forName("org.jinterop.dcom.core.JIComObjectImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz7)) {
                JIInterfacePointer interfacePointer = ((IJIComObject)value).getInterfacePointer();
                interfacePointer.encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz8 = class$14;
            if (clazz8 == null) {
                try {
                    clazz8 = class$14 = Class.forName("org.jinterop.dcom.core.JIInterfacePointer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz8)) {
                ((JIInterfacePointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz9 = class$3;
            if (clazz9 == null) {
                try {
                    clazz9 = class$3 = Class.forName("org.jinterop.dcom.core.JIVariant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz9)) {
                ((JIVariant)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            Class<?> clazz10 = class$2;
            if (clazz10 == null) {
                try {
                    clazz10 = class$2 = Class.forName("org.jinterop.dcom.core.VariantBody");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz10)) {
                ((VariantBody)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (mapOfSerializers.get(c) == null) {
                throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), c.toString()));
            }
            ((SerializerDeserializer)mapOfSerializers.get(c)).serializeData(ndr, value, FLAG);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void alignMemberWhileEncoding(NetworkDataRepresentation ndr, Class c, Object obj) {
        double index;
        block42: {
            long i;
            block41: {
                index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
                Class<?> clazz = class$19;
                if (clazz == null) {
                    try {
                        clazz = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) {
                    double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
                    long i2 = Math.round(index % align);
                    i2 = (long)(i2 == 0L ? 0.0 : align - (double)i2);
                    ndr.writeOctetArray(new byte[(int)i2], 0, (int)i2);
                    return;
                }
                Class<?> clazz2 = class$20;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$20 = Class.forName("org.jinterop.dcom.core.JIUnion");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz2)) {
                    double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
                    long i3 = Math.round(index % align);
                    i3 = (long)(i3 == 0L ? 0.0 : align - (double)i3);
                    ndr.writeOctetArray(new byte[(int)i3], 0, (int)i3);
                    return;
                }
                Class<?> clazz3 = class$7;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$7 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz3)) break block41;
                Class<?> clazz4 = class$8;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$8 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz4)) break block41;
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("org.jinterop.dcom.core.JIVariant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz5)) break block41;
                Class<?> clazz6 = class$9;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$9 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz6)) break block41;
                Class<?> clazz7 = class$18;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$18 = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!c.equals(clazz7)) break block42;
            }
            i = (i = Math.round(index % 4.0)) == 0L ? 0L : 4L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            return;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            return;
        }
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!c.equals(clazz8)) return;
        long i = Math.round(index % 2.0);
        i = i == 0L ? 0L : 2L - i;
        ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void alignMemberWhileDecoding(NetworkDataRepresentation ndr, Class c, Object obj) {
        double index;
        block42: {
            long i;
            block41: {
                index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
                Class<?> clazz = class$19;
                if (clazz == null) {
                    try {
                        clazz = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) {
                    double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
                    long i2 = Math.round(index % align);
                    i2 = (long)(i2 == 0L ? 0.0 : align - (double)i2);
                    ndr.readOctetArray(new byte[(int)i2], 0, (int)i2);
                    return;
                }
                Class<?> clazz2 = class$20;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$20 = Class.forName("org.jinterop.dcom.core.JIUnion");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz2)) {
                    double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
                    long i3 = Math.round(index % align);
                    i3 = (long)(i3 == 0L ? 0.0 : align - (double)i3);
                    ndr.readOctetArray(new byte[(int)i3], 0, (int)i3);
                    return;
                }
                Class<?> clazz3 = class$7;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$7 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz3)) break block41;
                Class<?> clazz4 = class$8;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$8 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz4)) break block41;
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("org.jinterop.dcom.core.JIVariant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz5)) break block41;
                Class<?> clazz6 = class$9;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$9 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz6)) break block41;
                Class<?> clazz7 = class$18;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$18 = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!c.equals(clazz7)) break block42;
            }
            i = (i = Math.round(index % 4.0)) == 0L ? 0L : 4L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
            return;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c.equals(clazz)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
            return;
        }
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!c.equals(clazz8)) return;
        long i = Math.round(index % 2.0);
        i = i == 0L ? 0L : 2L - i;
        ndr.readOctetArray(new byte[(int)i], 0, (int)i);
    }

    static Object deSerialize(NetworkDataRepresentation ndr, Object obj, List defferedPointers, int FLAG, Map additionalData) {
        block52: {
            block51: {
                Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
                Class<?> clazz = class$25;
                if (clazz == null) {
                    try {
                        clazz = class$25 = Class.forName("org.jinterop.dcom.core.JIArray");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) {
                    return ((JIArray)obj).decode(ndr, ((JIArray)obj).getArrayClass(), ((JIArray)obj).getDimensions(), defferedPointers, FLAG, additionalData);
                }
                JIUtil.alignMemberWhileDecoding(ndr, c, obj);
                Class<?> clazz2 = class$18;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$18 = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz2)) {
                    JIPointer retVal = ((JIPointer)obj).decode(ndr, defferedPointers, FLAG, additionalData);
                    return retVal;
                }
                Class<?> clazz3 = class$19;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz3)) {
                    JIStruct retVal = ((JIStruct)obj).decode(ndr, defferedPointers, FLAG, additionalData);
                    return retVal;
                }
                Class<?> clazz4 = class$20;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$20 = Class.forName("org.jinterop.dcom.core.JIUnion");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz4)) {
                    JIUnion retVal = ((JIUnion)obj).decode(ndr, defferedPointers, FLAG, additionalData);
                    return retVal;
                }
                Class<?> clazz5 = class$21;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$21 = Class.forName("org.jinterop.dcom.core.JIString");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz5)) {
                    JIString retVal = ((JIString)obj).decode(ndr, defferedPointers, FLAG, additionalData);
                    return retVal;
                }
                Class<?> clazz6 = class$14;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$14 = Class.forName("org.jinterop.dcom.core.JIInterfacePointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (obj.equals(clazz6)) break block51;
                Class<?> clazz7 = class$16;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$16 = Class.forName("org.jinterop.dcom.win32.JIDispatchImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (obj.equals(clazz7)) break block51;
                Class<?> clazz8 = class$17;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$17 = Class.forName("org.jinterop.dcom.core.JIComObjectImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!obj.equals(clazz8)) break block52;
            }
            JIInterfacePointer retVal = JIInterfacePointer.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.jinterop.dcom.core.JIVariant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (obj.equals(clazz)) {
            JIVariant retVal = JIVariant.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        Class<?> clazz9 = class$2;
        if (clazz9 == null) {
            try {
                clazz9 = class$2 = Class.forName("org.jinterop.dcom.core.VariantBody");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (obj.equals(clazz9)) {
            VariantBody retVal = VariantBody.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (mapOfSerializers.get(obj) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), obj.toString()));
        }
        return ((SerializerDeserializer)mapOfSerializers.get(obj)).deserializeData(ndr, additionalData, FLAG);
    }

    static int getLengthInBytes(Class c, Object obj, int FLAG) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            Class<?> clazz2 = class$25;
            if (clazz2 == null) {
                try {
                    clazz2 = class$25 = Class.forName("org.jinterop.dcom.core.JIArray");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return ((JIArray)obj).getSizeOfAllElementsInBytes();
            }
        }
        if ((SerializerDeserializer)mapOfSerializers.get(c) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), obj.toString()));
        }
        return ((SerializerDeserializer)mapOfSerializers.get(c)).getLengthInBytes(obj, FLAG);
    }

    private static interface SerializerDeserializer {
        public void serializeData(NetworkDataRepresentation var1, Object var2, int var3);

        public Object deserializeData(NetworkDataRepresentation var1, Map var2, int var3);

        public int getLengthInBytes(Object var1, int var2);
    }

    private static class PointerImpl
    implements SerializerDeserializer {
        private PointerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIPointer)value).getLength();
        }
    }

    private static class JIUnsignedIntImpl
    implements SerializerDeserializer {
        private JIUnsignedIntImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JIUtil.serialize(ndr, clazz, new Integer(((JIUnsignedInteger)value).getEncapsulatedUnsigned().intValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Integer b = (Integer)JIUtil.deSerialize(ndr, clazz, null, FLAG, additionalData);
            return JIUnsigned.getUnsigned(new Long((long)b.intValue() & 0xFFFFFFFFL), 1024);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class JIUnsignedByteImpl
    implements SerializerDeserializer {
        private JIUnsignedByteImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JIUtil.serialize(ndr, clazz, new Byte(((JIUnsignedByte)value).getEncapsulatedUnsigned().byteValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Byte b = (Byte)JIUtil.deSerialize(ndr, clazz, null, FLAG, additionalData);
            return JIUnsigned.getUnsigned(new Short((short)(b & 0xFF)), 256);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class JIUnsignedShortImpl
    implements SerializerDeserializer {
        private JIUnsignedShortImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JIUtil.serialize(ndr, clazz, new Short(((JIUnsignedShort)value).getEncapsulatedUnsigned().shortValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Short b = (Short)JIUtil.deSerialize(ndr, clazz, null, FLAG, additionalData);
            return JIUnsigned.getUnsigned(new Integer((int)(b & 0xFFFF)), 512);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 2;
        }
    }

    private static class StructImpl
    implements SerializerDeserializer {
        private StructImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIStruct)value).getLength();
        }
    }

    private static class UnionImpl
    implements SerializerDeserializer {
        private UnionImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIUnion)value).getLength();
        }
    }

    private static class IJIUnknownImpl
    implements SerializerDeserializer {
        private IJIUnknownImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            JIInterfacePointer interfacePointer = ((IJIComObject)value).getInterfacePointer();
            return interfacePointer.getLength();
        }
    }

    private static class IJIDispatchImpl
    implements SerializerDeserializer {
        private IJIDispatchImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            IJIComObject unknown = ((JIDispatchImpl)value).getCOMObject();
            JIInterfacePointer interfacePointer = new JIInterfacePointer("00020400-0000-0000-c000-000000000046", unknown.getInterfacePointer());
            return interfacePointer.getLength();
        }
    }

    private static class JIVariant2Impl
    implements SerializerDeserializer {
        private JIVariant2Impl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((VariantBody)value).getLengthInBytes();
        }
    }

    private static class JIVariantImpl
    implements SerializerDeserializer {
        private JIVariantImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            try {
                return ((JIVariant)value).getLengthInBytes(FLAG);
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
        }
    }

    private static class CharacterImpl
    implements SerializerDeserializer {
        private CharacterImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            ndr.writeUnsignedSmall((int)((Character)value).charValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Character c = new Character((char)ndr.readUnsignedSmall());
            return c;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class ByteImpl
    implements SerializerDeserializer {
        private ByteImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            ndr.writeUnsignedSmall((int)((Byte)value).byteValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Byte c = new Byte((byte)ndr.readUnsignedSmall());
            return c;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class ShortImpl
    implements SerializerDeserializer {
        private ShortImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = new Short(Short.MIN_VALUE);
            }
            ndr.writeUnsignedShort((int)((Short)value).shortValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            Short s = new Short((short)ndr.readUnsignedShort());
            return s;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class BooleanImpl
    implements SerializerDeserializer {
        private BooleanImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            if ((FLAG & 0x2000) == 8192) {
                ndr.writeUnsignedShort((Boolean)value != false ? 65535 : 0);
            } else {
                ndr.writeBoolean(((Boolean)value).booleanValue());
            }
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            int s;
            Boolean b = null;
            b = (FLAG & 0x2000) == 8192 ? ((s = ndr.readUnsignedShort()) != 0 ? Boolean.TRUE : Boolean.FALSE) : Boolean.valueOf(ndr.readBoolean());
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            if ((FLAG & 0x2000) == 8192) {
                return 2;
            }
            return 1;
        }
    }

    private static class IntegerImpl
    implements SerializerDeserializer {
        private IntegerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = new Integer(Integer.MIN_VALUE);
            }
            ndr.writeUnsignedLong(((Integer)value).intValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            return new Integer(ndr.readUnsignedLong());
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class LongImpl
    implements SerializerDeserializer {
        private LongImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = new Long(Long.MIN_VALUE);
            }
            ndr.getBuffer().align(8);
            Encdec.enc_uint64le((long)((Long)value), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Long b = new Long(Encdec.dec_uint64le((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class DoubleImpl
    implements SerializerDeserializer {
        private DoubleImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = new Double(Double.NaN);
            }
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)((Double)value), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Double b = new Double(Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class JICurrencyImpl
    implements SerializerDeserializer {
        private JICurrencyImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            Class<?> clazz;
            JICurrency currency = (JICurrency)value;
            int units = currency.getUnits();
            int fractionalUnits = currency.getFractionalUnits();
            int toSend = units * 10000 + fractionalUnits;
            String toSend2 = Integer.toHexString(toSend);
            int hibytes = 0;
            int lowbytes = 0;
            if (toSend2.length() > 8) {
                lowbytes = Integer.valueOf(toSend2.substring(8), 16);
                hibytes = Integer.valueOf(toSend2.substring(0, 8), 16);
            } else {
                lowbytes = toSend;
                if (toSend < 0) {
                    hibytes = -1;
                }
            }
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            JIStruct struct = new JIStruct();
            try {
                struct.addMember(new Integer(lowbytes));
                struct.addMember(new Integer(hibytes));
            }
            catch (JIException jIException) {
                // empty catch block
            }
            if ((clazz = class$19) == null) {
                try {
                    clazz = class$19 = Class.forName("org.jinterop.dcom.core.JIStruct");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JIUtil.serialize(ndr, clazz, struct, null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
            int lowbyte = ndr.readUnsignedLong();
            int hibyte = ndr.readUnsignedLong();
            if (hibyte < 0) {
                lowbyte = -1 * Math.abs(lowbyte);
            }
            return new JICurrency((lowbyte - lowbyte % 10000) / 10000, lowbyte % 10000);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class DateImpl
    implements SerializerDeserializer {
        private DateImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)this.convertMillisecondsToWindowsTime(((Date)value).getTime()), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Date b = new Date(this.convertWindowsTimeToMilliseconds(Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex())));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }

        private long convertWindowsTimeToMilliseconds(double comTime) {
            long result = 0L;
            Calendar cal = Calendar.getInstance();
            result = Math.round(8.64E7 * (comTime -= 25569.0)) - (long)cal.get(15);
            cal.setTime(new Date(result));
            return result -= (long)cal.get(16);
        }

        private double convertMillisecondsToWindowsTime(long milliseconds) {
            double result = 0.0;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(milliseconds);
            result = (double)(milliseconds += (long)(cal.get(15) + cal.get(16))) / 8.64E7 + 25569.0;
            return result;
        }
    }

    private static class FloatImpl
    implements SerializerDeserializer {
        private FloatImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            if (value == null) {
                value = new Float(Float.NaN);
            }
            ndr.getBuffer().align(4);
            Encdec.enc_floatle((float)((Float)value).floatValue(), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(4);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            ndr.getBuffer().align(4);
            Float b = new Float(Encdec.dec_floatle((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(4);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class StringImpl
    implements SerializerDeserializer {
        private StringImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            String str = (String)value;
            if (str == null) {
                str = "";
            }
            if ((FLAG & 1) == 1) {
                byte[] strBytes = null;
                try {
                    strBytes = str.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JIRuntimeException(4153);
                }
                ndr.writeUnsignedLong(strBytes.length / 2);
                ndr.writeUnsignedLong(strBytes.length);
                ndr.writeUnsignedLong(strBytes.length / 2);
                int i = 0;
                while (i < strBytes.length) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                    ++i;
                }
            } else if ((FLAG & 2) == 2) {
                int strlen = (int)Math.round((double)str.length() / 2.0);
                ndr.writeUnsignedLong(strlen + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strlen + 1);
                if (str.length() != 0) {
                    ndr.writeCharacterArray(str.toCharArray(), 0, str.length());
                    if (str.length() % 2 != 0) {
                        ndr.writeUnsignedSmall(0);
                    }
                }
                ndr.writeUnsignedShort(0);
            } else if ((FLAG & 4) == 4) {
                byte[] strBytes = null;
                try {
                    strBytes = str.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JIRuntimeException(4153);
                }
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                int i = 0;
                while (i < strBytes.length) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                    ++i;
                }
                ndr.writeUnsignedShort(0);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            int retVal = -1;
            String retString = null;
            try {
                if ((FLAG & 1) == 1) {
                    ndr.readUnsignedLong();
                    ndr.readUnsignedLong();
                    int actuallength = ndr.readUnsignedLong() * 2;
                    byte[] buffer = new byte[actuallength];
                    int i = 0;
                    while (i < actuallength) {
                        retVal = ndr.readUnsignedSmall();
                        buffer[i] = (byte)retVal;
                        ++i;
                    }
                    retString = new String(buffer, "UTF-16LE");
                } else if ((FLAG & 2) == 2) {
                    int actuallength = ndr.readUnsignedLong();
                    if (actuallength == 0) {
                        return null;
                    }
                    ndr.readUnsignedLong();
                    ndr.readUnsignedLong();
                    char[] ret = new char[actuallength * 2 - 2];
                    ndr.readCharacterArray(ret, 0, actuallength * 2 - 2);
                    retString = ret[ret.length - 1] == '0' ? new String(ret, 0, ret.length - 1) : new String(ret);
                    ndr.readUnsignedShort();
                } else if ((FLAG & 4) == 4) {
                    int maxlength = ndr.readUnsignedLong();
                    if (maxlength == 0) {
                        return null;
                    }
                    ndr.readUnsignedLong();
                    int actuallength = ndr.readUnsignedLong() * 2;
                    byte[] buffer = new byte[actuallength - 2];
                    int i = 0;
                    while (i < actuallength - 2) {
                        retVal = ndr.readUnsignedSmall();
                        buffer[i] = (byte)retVal;
                        ++i;
                    }
                    if (actuallength != 0) {
                        ndr.readUnsignedShort();
                    }
                    retString = new String(buffer, "UTF-16LE");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new JIRuntimeException(4153);
            }
            return retString;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            int length = 12;
            if ((FLAG & 1) != 1) {
                length += 2;
            }
            if ((FLAG & 2) == 2) {
                length += ((String)value).length();
                if (((String)value).length() % 2 != 0) {
                    ++length;
                }
            } else {
                length += ((String)value).length() * 2;
            }
            return length;
        }
    }

    private static class JIStringImpl
    implements SerializerDeserializer {
        private JIStringImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return 4 + JIUtil.getLengthInBytes(clazz, ((JIString)value).getString(), ((JIString)value).getType() | FLAG);
        }
    }

    private static class UUIDImpl
    implements SerializerDeserializer {
        private UUIDImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            try {
                ((UUID)value).encode(ndr, ndr.getBuffer());
            }
            catch (NdrException e) {
                JISystem.getLogger().exception("", "", e);
            }
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            UUID ret = new UUID();
            try {
                ret.decode(ndr, ndr.getBuffer());
            }
            catch (NdrException e) {
                JISystem.getLogger().exception("", "", e);
                ret = null;
            }
            return ret;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 16;
        }
    }

    private static class MInterfacePointerImpl
    implements SerializerDeserializer {
        private MInterfacePointerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointer)value).getLength();
        }
    }

    private static class MInterfacePointerImpl2
    implements SerializerDeserializer {
        private MInterfacePointerImpl2() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, int FLAG) {
            ((JIInterfacePointerBody)value).encode(ndr);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, Map additionalData, int FLAG) {
            return JIInterfacePointerBody.decode(ndr);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointerBody)value).getLength();
        }
    }
}

