/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.ObjectId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.IJICOMRuntimeWorker;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIDualStringArray;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISetId;
import org.jinterop.dcom.core.JIUtil;
import rpc.core.UUID;

class OxidObject
extends NdrObject
implements IJICOMRuntimeWorker {
    private int opnum = -1;
    private NdrBuffer buffer = null;
    private Random random = new Random(System.currentTimeMillis());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    OxidObject() {
    }

    public void setCurrentObjectID(UUID objectId) {
    }

    public void setOpnum(int opnum) {
        this.opnum = opnum;
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.setBuffer(this.buffer);
    }

    public void read(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 1: {
                this.buffer = this.SimplePing(ndr);
                break;
            }
            case 2: {
                this.buffer = this.ComplexPing(ndr);
                break;
            }
            case 3: {
                this.buffer = this.ServerAlive(ndr);
                break;
            }
            case 5: {
                this.buffer = this.ServerAlive2(ndr);
                break;
            }
            case 4: {
                this.buffer = this.ResolveOxid2(ndr);
                break;
            }
            default: {
                JISystem.getLogger().info("Oxid Object: DEFAULTED !!!");
                throw new JIRuntimeException(-1073610706);
            }
        }
    }

    private NdrBuffer SimplePing(NetworkDataRepresentation ndr) {
        JISystem.getLogger().info("Oxid Object: SimplePing");
        byte[] b = JIUtil.readOctetArrayLE(ndr, 8);
        JIComOxidRuntime.addUpdateSets(new JISetId(b), new ArrayList(), new ArrayList());
        this.buffer = new NdrBuffer(new byte[16], 0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        return this.buffer;
    }

    private NdrBuffer ComplexPing(NetworkDataRepresentation ndr) {
        JISystem.getLogger().info("Oxid Object: ComplexPing");
        byte[] b = JIUtil.readOctetArrayLE(ndr, 8);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.deSerialize(ndr, clazz, null, 0, null);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Short lengthAdds = (Short)JIUtil.deSerialize(ndr, clazz2, null, 0, null);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Short lengthDels = (Short)JIUtil.deSerialize(ndr, clazz3, null, 0, null);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.deSerialize(ndr, clazz4, null, 0, null);
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.deSerialize(ndr, clazz5, null, 0, null);
        ArrayList<JIObjectId> listOfAdds = new ArrayList<JIObjectId>();
        int i = 0;
        while (i < lengthAdds.intValue()) {
            listOfAdds.add(new JIObjectId(JIUtil.readOctetArrayLE(ndr, 8)));
            ++i;
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.deSerialize(ndr, clazz6, null, 0, null);
        ArrayList<JIObjectId> listOfDels = new ArrayList<JIObjectId>();
        int i2 = 0;
        while (i2 < lengthDels.intValue()) {
            listOfDels.add(new JIObjectId(JIUtil.readOctetArrayLE(ndr, 8)));
            ++i2;
        }
        if (Arrays.equals(b, new byte[8])) {
            this.random.nextBytes(b);
        }
        JIComOxidRuntime.addUpdateSets(new JISetId(b), listOfAdds, listOfDels);
        this.buffer = new NdrBuffer(new byte[32], 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(this.buffer);
        JIUtil.writeOctetArrayLE(ndr2, b);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz7, new Short(0), null, 0);
        Class<?> clazz8 = class$1;
        if (clazz8 == null) {
            try {
                clazz8 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz8, new Integer(0), null, 0);
        return this.buffer;
    }

    private NdrBuffer ServerAlive(NetworkDataRepresentation ndr) {
        JISystem.getLogger().info("Oxid Object: ServerAlive");
        byte[] buffer = new byte[32];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        return ndrBuffer;
    }

    private NdrBuffer ServerAlive2(NetworkDataRepresentation ndr) {
        JISystem.getLogger().info("Oxid Object: ServerAlive2");
        JIDualStringArray dualStringArray = new JIDualStringArray(-1);
        byte[] buffer = new byte[dualStringArray.getLength() + 4 + 16 + 16];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(ndrBuffer);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz, new Short((short)JISystem.getCOMVersion().getMajorVersion()), null, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz2, new Short((short)JISystem.getCOMVersion().getMinorVersion()), null, 0);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz3, new Integer(0), null, 0);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz4, new Integer(dualStringArray.getLength()), null, 0);
        dualStringArray.encode(ndr2);
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz5, new Integer(0), null, 0);
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz6, new Integer(0), null, 0);
        return ndrBuffer;
    }

    private NdrBuffer ResolveOxid2(NetworkDataRepresentation ndr) {
        JISystem.getLogger().info("Oxid Object: ResolveOxid2");
        JIOxid oxid = new JIOxid(JIUtil.readOctetArrayLE(ndr, 8));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int length = ((Short)JIUtil.deSerialize(ndr, clazz, null, 0, null)).intValue();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIArray array = (JIArray)JIUtil.deSerialize(ndr, new JIArray(clazz2, null, 1, true), null, 8, null);
        JIComOxidDetails details = JIComOxidRuntime.getOxidDetails(oxid);
        if (details == null) {
            throw new JIRuntimeException(-2147022986);
        }
        int port = -1;
        try {
            port = details.getPortForRemUnknown();
            port = port == -1 ? details.getCOMRuntimeHelper().startRemUnknown() : port;
            details.setPortForRemUnknown(port);
        }
        catch (IOException e) {
            throw new JIRuntimeException(-2147418113);
        }
        JIDualStringArray dualStringArray = new JIDualStringArray(port);
        String str = new ObjectId().toHexString();
        str = String.valueOf(str.substring(0, 8)) + "-" + str.substring(8, 12) + "-" + str.substring(12, 16) + "-" + str.substring(16, 20) + "-" + str.substring(20);
        UUID uuid = new UUID(str);
        Integer authnHint = new Integer(2);
        byte[] buffer = new byte[8 + dualStringArray.getLength() + 16 + 4 + 2 + 2 + 4 + 16];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(ndrBuffer);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz3, new Integer(new Object().hashCode()), null, 0);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz4, new Integer((dualStringArray.getLength() - 4) / 2), null, 0);
        dualStringArray.encode(ndr2);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("rpc.core.UUID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz5, uuid, null, 0);
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz6, authnHint, null, 0);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz7, new Short((short)JISystem.getCOMVersion().getMajorVersion()), null, 0);
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz8, new Short((short)JISystem.getCOMVersion().getMinorVersion()), null, 0);
        Class<?> clazz9 = class$1;
        if (clazz9 == null) {
            try {
                clazz9 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIUtil.serialize(ndr2, clazz9, new Integer(0), null, 0);
        return ndrBuffer;
    }

    public List getQIedIIDs() {
        return null;
    }

    public UUID getCurrentObjectID() {
        return null;
    }

    public boolean isResolver() {
        return true;
    }
}

