/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUtil;
import org.jinterop.dcom.core.JIVariant;

class VariantBody
implements Serializable {
    private static final long serialVersionUID = -8484108480626831102L;
    public static final short VT_PTR = 26;
    public static final short VT_SAFEARRAY = 27;
    public static final short VT_CARRAY = 28;
    public static final short VT_USERDEFINED = 29;
    public static final EMPTY EMPTY = new EMPTY();
    public static final NULL NULL = new NULL();
    public static final SCODE SCODE = new SCODE();
    private boolean is2Dimensional = false;
    private Object obj = null;
    private int type = -1;
    private JIStruct safeArrayStruct = null;
    private boolean isArray = false;
    private boolean isScode = false;
    private boolean isNull = false;
    private Class nestedArraysRealClass = null;
    private static ArrayList type3 = new ArrayList();
    private boolean isByRef = false;
    int FLAG = 0;
    int variantType = 29;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.jinterop.dcom.core.VariantBody$EMPTY");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.jinterop.dcom.core.VariantBody$NULL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.jinterop.dcom.core.VariantBody$SCODE");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.jinterop.dcom.core.JIUnsignedByte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.jinterop.dcom.core.JIUnsignedShort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz11);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.jinterop.dcom.core.JIUnsignedInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type3.add(clazz12);
    }

    boolean isByRef() {
        return this.isByRef;
    }

    boolean isNull() {
        return this.isNull;
    }

    int getType() {
        return this.isArray ? 0x2000 | this.type : this.type;
    }

    VariantBody(Object referent, boolean isByRef) {
        this(referent, isByRef, -1);
    }

    private VariantBody(Object referent, boolean isByRef, int dataType) {
        Object object = this.obj = referent == null ? EMPTY : referent;
        if (this.obj instanceof JIString && ((JIString)this.obj).getType() != 1) {
            throw new JIRuntimeException(4130);
        }
        if (this.obj instanceof Boolean) {
            this.FLAG = 8192;
        }
        this.isByRef = isByRef;
        this.variantType = this.getMaxLength(this.obj.getClass(), isByRef, this.obj);
        Integer types = JIVariant.getSupportedType(this.obj, dataType);
        if (types == null) {
            throw new JIRuntimeException(4144);
        }
        this.type = types | (isByRef ? 16384 : 0);
    }

    VariantBody(NULL value) {
        this(new Integer(0), false);
        this.isNull = true;
        this.type = 1;
    }

    VariantBody(SCODE value, int errorCode, boolean isByRef) {
        this(new Integer(errorCode), isByRef);
        this.isScode = true;
        this.type = 10;
    }

    VariantBody(JIStruct safeArray, Class nestedClass, boolean is2Dimensional, boolean isByRef, int FLAG) {
        this.FLAG = FLAG;
        this.safeArrayStruct = safeArray;
        this.isArray = true;
        if (this.safeArrayStruct == null) {
            this.isNull = true;
        }
        this.nestedArraysRealClass = nestedClass;
        this.is2Dimensional = is2Dimensional;
        this.isByRef = isByRef;
        Integer types = JIVariant.getSupportedType(nestedClass, FLAG);
        if (types == null) {
            throw new JIRuntimeException(4144);
        }
        this.type = types | (isByRef ? 16384 : 0);
    }

    Object getObject() throws JIException {
        return this.obj == null ? this.getArray() : this.obj;
    }

    JIArray getArray() throws JIException {
        JIArray retVal = null;
        if (this.safeArrayStruct != null) {
            retVal = (JIArray)((JIPointer)this.safeArrayStruct.getMember(7)).getReferent();
            if (this.is2Dimensional) {
                Object[] obj3 = (Object[])retVal.getArrayInstance();
                JIArray safeArrayBound = (JIArray)this.safeArrayStruct.getMember(8);
                JIStruct[] safeArrayBound2 = (JIStruct[])safeArrayBound.getArrayInstance();
                int firstDim = (Integer)safeArrayBound2[0].getMember(0);
                int secondDim = (Integer)safeArrayBound2[1].getMember(0);
                Object obj = Array.newInstance(this.nestedArraysRealClass, firstDim, secondDim);
                Object[][] obj2 = (Object[][])obj;
                int k = 0;
                int i = 0;
                while (i < secondDim) {
                    int j = 0;
                    while (j < firstDim) {
                        obj2[j][i] = obj3[k++];
                        ++j;
                    }
                    ++i;
                }
                retVal = new JIArray(obj2);
            } else if (this.nestedArraysRealClass != null) {
                Object[] obj = (Object[])retVal.getArrayInstance();
                Object obj2 = Array.newInstance(this.nestedArraysRealClass, obj.length);
                int i = 0;
                while (i < obj.length) {
                    ((Object[])obj2)[i] = obj[i];
                    ++i;
                }
                retVal = new JIArray(obj2);
            } else {
                throw new JIException(4144);
            }
        }
        return retVal;
    }

    int getObjectAsInt() {
        try {
            return (Integer)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    long getObjectAsLong() {
        try {
            return (Long)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    IJIUnsigned getObjectAsUnsigned() {
        try {
            return (IJIUnsigned)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    int getObjectAsSCODE() {
        try {
            return ((SCODE)this.obj).errorCode;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    float getObjectAsFloat() {
        try {
            return ((Float)this.obj).floatValue();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    double getObjectAsDouble() {
        try {
            return (Double)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    short getObjectAsShort() {
        try {
            return (Short)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    boolean getObjectAsBoolean() {
        try {
            return (Boolean)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    JIString getObjectAsString() {
        try {
            return (JIString)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    Date getObjectAsDate() {
        try {
            return (Date)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    char getObjectAsChar() {
        try {
            return ((Character)this.obj).charValue();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    JIVariant getObjectAsVariant() {
        try {
            return (JIVariant)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    JIInterfacePointer getObjectAsInterfacePointer() {
        try {
            return (JIInterfacePointer)this.obj;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    void encode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG) {
        try {
            FLAG |= this.FLAG;
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            if (index % 8.0 != 0.0) {
                long i = Math.round(index % 8.0);
                i = i == 0L ? 0L : 8L - i;
                ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            }
            int start = ndr.getBuffer().getIndex();
            int length = this.variantType;
            if (this.safeArrayStruct != null) {
                length = this.fillArrayType(ndr);
            } else {
                ndr.writeUnsignedLong(this.variantType);
            }
            ndr.writeUnsignedLong(0);
            int varType = this.getVarType(this.obj != null ? this.obj.getClass() : this.nestedArraysRealClass);
            ndr.writeUnsignedShort(varType);
            ndr.writeUnsignedSmall(204);
            ndr.writeUnsignedSmall(204);
            ndr.writeUnsignedSmall(204);
            ndr.writeUnsignedSmall(204);
            ndr.writeUnsignedSmall(204);
            ndr.writeUnsignedSmall(204);
            if (this.obj != null) {
                ndr.writeUnsignedLong(varType);
            } else if (!this.isByRef) {
                ndr.writeUnsignedLong(8192);
            } else {
                ndr.writeUnsignedLong(24576);
            }
            if (this.isByRef) {
                int flag = -1;
                if (this.isArray) {
                    flag = 4;
                } else {
                    switch (this.type) {
                        case 16396: {
                            flag = 16;
                            break;
                        }
                        case 16390: 
                        case 16391: {
                            flag = 8;
                            break;
                        }
                        default: {
                            flag = 4;
                        }
                    }
                }
                ndr.writeUnsignedLong(flag);
            }
            ArrayList varDefferedPointers = new ArrayList();
            this.setValue(ndr, this.obj, varDefferedPointers, FLAG);
            int x = 0;
            while (x < varDefferedPointers.size()) {
                ArrayList newList = new ArrayList();
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JIUtil.serialize(ndr, clazz, (JIPointer)varDefferedPointers.get(x), newList, FLAG);
                varDefferedPointers.addAll(++x, newList);
            }
            if (this.safeArrayStruct != null && this.isArray && (index = new Integer(ndr.getBuffer().getIndex()).doubleValue()) < (double)(length = length * 8 + start)) {
                Integer size = (Integer)this.safeArrayStruct.getMember(2);
                long i = 0L;
                if (size == 8) {
                    if (index % 8.0 != 0.0) {
                        i = Math.round(index % 8.0);
                        long l = i = i == 0L ? 0L : 8L - i;
                        if (index + (double)i <= (double)length) {
                            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
                        } else {
                            ndr.writeOctetArray(new byte[length - (int)index], 0, length - (int)index);
                        }
                    }
                } else if (index % 4.0 != 0.0) {
                    i = Math.round(index % 4.0);
                    long l = i = i == 0L ? 0L : 4L - i;
                    if (index + (double)i <= (double)length) {
                        ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
                    } else {
                        ndr.writeOctetArray(new byte[length - (int)index], 0, length - (int)index);
                    }
                }
            }
        }
        catch (JIException e) {
            throw new JIRuntimeException(e.getErrorCode());
        }
    }

    private int getMaxLength(Class c, boolean isByRef, Object obj) {
        int length;
        block39: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block38: {
                                length = 3;
                                if (!type3.contains(c)) break block38;
                                length = 3;
                                if (isByRef) {
                                    ++length;
                                }
                                break block39;
                            }
                            Class<?> clazz = class$13;
                            if (clazz == null) {
                                try {
                                    clazz = class$13 = Class.forName("java.lang.Long");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz)) break block40;
                            Class<?> clazz2 = class$14;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$14 = Class.forName("java.lang.Double");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz2)) break block40;
                            Class<?> clazz3 = class$15;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$15 = Class.forName("java.util.Date");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz3)) break block40;
                            Class<?> clazz4 = class$16;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = class$16 = Class.forName("org.jinterop.dcom.core.JICurrency");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!c.equals(clazz4)) break block41;
                        }
                        length = 4;
                        break block39;
                    }
                    Class<?> clazz = class$17;
                    if (clazz == null) {
                        try {
                            clazz = class$17 = Class.forName("org.jinterop.dcom.core.JIString");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!c.equals(clazz)) break block42;
                    int strlen = 0;
                    if (obj != null && ((JIString)obj).getString() != null) {
                        strlen = ((JIString)obj).getString().length();
                    }
                    double value = 36 + strlen * 2;
                    if (isByRef) {
                        value += 4.0;
                    }
                    double d = value % 8.0;
                    length = (int)value / 8;
                    if (d != 0.0) {
                        ++length;
                    }
                    break block39;
                }
                Class<?> clazz = class$18;
                if (clazz == null) {
                    try {
                        clazz = class$18 = Class.forName("org.jinterop.dcom.win32.JIDispatchImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) break block43;
                Class<?> clazz5 = class$19;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$19 = Class.forName("org.jinterop.dcom.core.JIComObjectImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!c.equals(clazz5)) break block39;
            }
            double value = ((IJIComObject)obj).getInterfacePointer().getLength();
            if (isByRef) {
                value += 4.0;
            }
            value = value + 20.0 + 4.0 + 4.0 + 4.0;
            double d = value % 8.0;
            length = (int)value / 8;
            if (d != 0.0) {
                ++length;
            }
        }
        return length;
    }

    private int getMaxLength2(Class c, Object obj) {
        int length;
        block32: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                length = 0;
                                if (!type3.contains(c)) break block31;
                                length = JIUtil.getLengthInBytes(c, obj, this.FLAG);
                                break block32;
                            }
                            Class<?> clazz = class$13;
                            if (clazz == null) {
                                try {
                                    clazz = class$13 = Class.forName("java.lang.Long");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz)) break block33;
                            Class<?> clazz2 = class$14;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$14 = Class.forName("java.lang.Double");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz2)) break block33;
                            Class<?> clazz3 = class$15;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$15 = Class.forName("java.util.Date");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (c.equals(clazz3)) break block33;
                            Class<?> clazz4 = class$16;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = class$16 = Class.forName("org.jinterop.dcom.core.JICurrency");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!c.equals(clazz4)) break block34;
                        }
                        length = 8;
                        break block32;
                    }
                    Class<?> clazz = class$17;
                    if (clazz == null) {
                        try {
                            clazz = class$17 = Class.forName("org.jinterop.dcom.core.JIString");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!c.equals(clazz)) break block35;
                    length = JIUtil.getLengthInBytes(c, obj, this.FLAG);
                    break block32;
                }
                Class<?> clazz = class$18;
                if (clazz == null) {
                    try {
                        clazz = class$18 = Class.forName("org.jinterop.dcom.win32.JIDispatchImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz)) break block36;
                Class<?> clazz5 = class$19;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$19 = Class.forName("org.jinterop.dcom.core.JIComObjectImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!c.equals(clazz5)) break block32;
            }
            double value = ((IJIComObject)obj).getInterfacePointer().getLength();
            value = value + 4.0 + 4.0 + 4.0;
        }
        return length;
    }

    int getVariantType() throws JIException {
        return this.safeArrayStruct == null ? this.variantType : this.getArrayLengthForVarType();
    }

    private int fillArrayType(NetworkDataRepresentation ndr) throws JIException {
        int length = this.getArrayLengthForVarType();
        ndr.writeUnsignedLong(length);
        return length;
    }

    private int getArrayLengthForVarType() throws JIException {
        boolean isVariantArray;
        JIArray objArray = (JIArray)((JIPointer)this.safeArrayStruct.getMember(7)).getReferent();
        Object[] array = (Object[])objArray.getArrayInstance();
        double length = 20.0;
        if (this.isByRef) {
            length += 4.0;
        }
        length += 44.0;
        boolean bl = isVariantArray = ((Short)this.safeArrayStruct.getMember(1) & 0x800) == 2048;
        if (array != null) {
            int i;
            length += 4.0;
            if (isVariantArray) {
                i = 0;
                while (i < array.length) {
                    JIVariant variant = (JIVariant)array[i];
                    length += (double)(((VariantBody)variant.member.getReferent()).variantType * 8);
                    ++i;
                }
            } else {
                i = 0;
                while (i < array.length) {
                    length += (double)this.getMaxLength2(array[i].getClass(), array[i]);
                    ++i;
                }
            }
        } else {
            length += 4.0;
        }
        int value = (int)length / 8;
        if (length % 8.0 != 0.0) {
            ++value;
        }
        return value;
    }

    static VariantBody decode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG, Map additionalData) {
        boolean isByRef;
        double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
        if (index % 8.0 != 0.0) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        }
        int start = ndr.getBuffer().getIndex();
        int length = ndr.readUnsignedLong();
        ndr.readUnsignedLong();
        int variantType = ndr.readUnsignedShort();
        ndr.readUnsignedShort();
        ndr.readUnsignedShort();
        ndr.readUnsignedShort();
        ndr.readUnsignedLong();
        VariantBody variant = null;
        ArrayList varDefferedPointers = new ArrayList();
        if ((variantType & 0x2000) == 8192) {
            isByRef = (variantType & 0x4000) != 0;
            JIStruct safeArray = VariantBody.getDecodedValueAsArray(ndr, varDefferedPointers, variantType & 0xFFFFDFFF, isByRef, additionalData, FLAG);
            int type2 = variantType;
            if (isByRef) {
                type2 &= 0xFFFFBFFF;
            }
            int flagofFlags = FLAG;
            if ((type2 &= 0xFFF) == 22) {
                flagofFlags |= 0x800;
            } else if (type2 == 23) {
                flagofFlags |= 0x1000;
            } else if (type2 == 11) {
                FLAG = flagofFlags |= 0x2000;
            }
            variant = safeArray != null ? new VariantBody(safeArray, JIVariant.getSupportedClass(new Integer(type2 & 0xFFFFDFFF)), ((Object[])((JIArray)safeArray.getMember(8)).getArrayInstance()).length > 1, isByRef, flagofFlags) : new VariantBody(null, JIVariant.getSupportedClass(new Integer(type2 & 0xFFFFDFFF)), false, isByRef, flagofFlags);
            variant.FLAG = flagofFlags;
        } else {
            isByRef = (variantType & 0x4000) != 0;
            variant = new VariantBody(VariantBody.getDecodedValue(ndr, varDefferedPointers, variantType, isByRef, additionalData, FLAG), isByRef, variantType);
            int type2 = variantType & 0xFFF;
            if (type2 == 22) {
                variant.FLAG = 2048;
            } else if (type2 == 23) {
                variant.FLAG = 4096;
            }
        }
        int x = 0;
        while (x < varDefferedPointers.size()) {
            ArrayList newList = new ArrayList();
            JIPointer replacement = (JIPointer)JIUtil.deSerialize(ndr, (JIPointer)varDefferedPointers.get(x), newList, FLAG, additionalData);
            ((JIPointer)varDefferedPointers.get(x)).replaceSelfWithNewPointer(replacement);
            varDefferedPointers.addAll(++x, newList);
        }
        if (variant.isArray && variant.safeArrayStruct != null) {
            index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            if (index < (double)(length = length * 8 + start)) {
                JIStruct safeArrayStruct = variant.safeArrayStruct;
                Integer size = (Integer)safeArrayStruct.getMember(2);
                long i = 0L;
                if (size == 8) {
                    if (index % 8.0 != 0.0) {
                        i = Math.round(index % 8.0);
                        long l = i = i == 0L ? 0L : 8L - i;
                        if (index + (double)i <= (double)length) {
                            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
                        } else {
                            ndr.readOctetArray(new byte[length - (int)index], 0, length - (int)index);
                        }
                    }
                } else if (index % 4.0 != 0.0) {
                    i = Math.round(index % 4.0);
                    long l = i = i == 0L ? 0L : 4L - i;
                    if (index + (double)i <= (double)length) {
                        ndr.readOctetArray(new byte[(int)i], 0, (int)i);
                    } else {
                        ndr.readOctetArray(new byte[length - (int)index], 0, length - (int)index);
                    }
                }
            }
            JIArray array = null;
            try {
                array = variant.getArray();
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
            JIVariant variantMain = new JIVariant(array, variant.isByRef, variant.FLAG);
            variant = (VariantBody)variantMain.member.getReferent();
        }
        return variant;
    }

    private static Class getVarClass(int type) {
        Class<?> c = null;
        switch (type &= 0xFFF) {
            case 0: {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("org.jinterop.dcom.core.VariantBody$EMPTY");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c = clazz;
                break;
            }
            case 1: {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.jinterop.dcom.core.VariantBody$NULL");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c = clazz;
                break;
            }
            case 10: {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("org.jinterop.dcom.core.VariantBody$SCODE");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c = clazz;
                break;
            }
            default: {
                c = JIVariant.getSupportedClass(new Integer(type));
            }
        }
        return c;
    }

    private int getVarType(Class c) {
        int type = 0;
        if (c != null) {
            Integer type2 = JIVariant.getSupportedType(c, this.FLAG);
            if (type2 != null) {
                type = type2;
            } else {
                Class<?> clazz = class$20;
                if (clazz == null) {
                    try {
                        clazz = class$20 = Class.forName("org.jinterop.dcom.core.JIVariant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                type2 = JIVariant.getSupportedType(clazz, this.FLAG);
            }
            if (this.isNull) {
                type = 1;
            } else if (this.isScode) {
                type = 10;
            } else if (this.isArray) {
                type = 0x2000 | type;
            }
        }
        if (this.isByRef && type != 0) {
            Class<?> clazz = class$21;
            if (clazz == null) {
                try {
                    clazz = class$21 = Class.forName("org.jinterop.dcom.core.JIArray");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!c.equals(clazz)) {
                type |= 0x4000;
            }
        }
        return type;
    }

    private static Object getDecodedValue(NetworkDataRepresentation ndr, List defferedPointers, int type, boolean isByRef, Map additionalData, int FLAG) {
        Object obj = null;
        Class c = VariantBody.getVarClass(type);
        if (c != null) {
            Class<?> clazz;
            if (isByRef) {
                ndr.readUnsignedLong();
            }
            if ((clazz = class$8) == null) {
                try {
                    clazz = class$8 = Class.forName("org.jinterop.dcom.core.VariantBody$SCODE");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz)) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                obj = JIUtil.deSerialize(ndr, clazz2, null, FLAG, additionalData);
                obj = new SCODE((Integer)obj);
            } else {
                Class<?> clazz3 = class$7;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$7 = Class.forName("org.jinterop.dcom.core.VariantBody$NULL");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c.equals(clazz3)) {
                    obj = NULL;
                } else {
                    Class<?> clazz4 = class$6;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$6 = Class.forName("org.jinterop.dcom.core.VariantBody$EMPTY");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (c.equals(clazz4)) {
                        obj = EMPTY;
                    } else {
                        Class<?> clazz5 = class$17;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$17 = Class.forName("org.jinterop.dcom.core.JIString");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (c.equals(clazz5)) {
                            obj = new JIString(1);
                            obj = ((JIString)obj).decode(ndr, null, FLAG, additionalData);
                        } else {
                            Class<?> clazz6 = class$3;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$3 = Class.forName("java.lang.Boolean");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            obj = c.equals(clazz6) ? JIUtil.deSerialize(ndr, c, defferedPointers, FLAG | 0x2000, additionalData) : JIUtil.deSerialize(ndr, c, defferedPointers, FLAG, additionalData);
                        }
                    }
                }
            }
        }
        return obj;
    }

    private static JIStruct getDecodedValueAsArray(NetworkDataRepresentation ndr, List defferedPointers, int type, boolean isByRef, Map additionalData, int FLAG) {
        JIStruct safeArray;
        block64: {
            if (isByRef) {
                ndr.readUnsignedLong();
                type &= 0xFFFFBFFF;
            }
            if (ndr.readUnsignedLong() == 0) {
                return null;
            }
            ndr.readUnsignedLong();
            safeArray = new JIStruct();
            try {
                Class<?> clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz2);
                JIStruct safeArrayBound = new JIStruct();
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArrayBound.addMember(clazz3);
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArrayBound.addMember(clazz4);
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz5);
                Class<?> clazz6 = class$0;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz6);
                Class<?> clazz7 = class$1;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz7);
                Class<?> clazz8 = class$1;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz8);
                Class<?> clazz9 = class$0;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz9);
                Class<?> clazz10 = class$0;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                safeArray.addMember(clazz10);
                Class c = (Class)JIVariant.supportedTypes_classes.get(new Integer(type));
                if (c == null) {
                    JISystem.getLogger().warning("From JIVariant: while decoding an Array, type " + type + " , was not found in supportedTypes_classes map , hence using JIVariant instead...");
                    Class<?> clazz11 = class$20;
                    if (clazz11 == null) {
                        try {
                            clazz11 = class$20 = Class.forName("org.jinterop.dcom.core.JIVariant");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    c = clazz11;
                }
                if ((clazz = class$3) == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c == clazz) {
                    FLAG |= 0x2000;
                }
                JIArray values = null;
                Class<?> clazz12 = class$17;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$17 = Class.forName("org.jinterop.dcom.core.JIString");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c == clazz12) {
                    values = new JIArray(new JIString(1), null, 1, true);
                    safeArray.addMember(new JIPointer(values));
                } else {
                    values = new JIArray(c, null, 1, true);
                    safeArray.addMember(new JIPointer(values));
                }
                safeArray.addMember(new JIArray(safeArrayBound, null, 1, true));
                safeArray = (JIStruct)JIUtil.deSerialize(ndr, safeArray, defferedPointers, FLAG, additionalData);
                Short features = (Short)safeArray.getMember(1);
                if ((features & 0x800) == 2048) {
                    Class<?> clazz13 = class$20;
                    if (clazz13 == null) {
                        try {
                            clazz13 = class$20 = Class.forName("org.jinterop.dcom.core.JIVariant");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    values.updateClazz(clazz13);
                    break block64;
                }
                if ((features & 0x400) != 1024 && (features & 0x200) != 512) break block64;
                Class<?> clazz14 = class$22;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$22 = Class.forName("org.jinterop.dcom.core.JIInterfacePointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                values.updateClazz(clazz14);
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
        }
        return safeArray;
    }

    private void setValue(NetworkDataRepresentation ndr, Object obj, List defferedPointers, int FLAG) {
        if (this.isNull) {
            return;
        }
        if (obj != null) {
            Class<?> c = obj.getClass();
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.jinterop.dcom.core.VariantBody$EMPTY");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c.equals(clazz)) {
                return;
            }
            JIUtil.serialize(ndr, c, obj, defferedPointers, FLAG);
        } else {
            ndr.writeUnsignedLong(new Object().hashCode());
            ndr.writeUnsignedLong(1);
            Class<?> clazz = class$23;
            if (clazz == null) {
                try {
                    clazz = class$23 = Class.forName("org.jinterop.dcom.core.JIStruct");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JIUtil.serialize(ndr, clazz, this.safeArrayStruct, defferedPointers, FLAG);
        }
    }

    boolean isArray() {
        return this.isArray;
    }

    int getLengthInBytes() {
        if (this.safeArrayStruct == null) {
            Class<?> clazz = this.obj.getClass();
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("org.jinterop.dcom.core.VariantBody$EMPTY");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return 28;
            }
        }
        if (this.isArray) {
            int length = 0;
            JIArray objArray = (JIArray)((JIPointer)this.safeArrayStruct.getMember(7)).getReferent();
            Object[] array = (Object[])objArray.getArrayInstance();
            int i = 0;
            while (i < array.length) {
                Class<?> c = array[i].getClass();
                length += JIUtil.getLengthInBytes(c, array[i], this.FLAG);
                ++i;
            }
            return length;
        }
        return JIUtil.getLengthInBytes(this.obj.getClass(), this.obj, this.FLAG);
    }

    public String toString() {
        String retVal = "";
        retVal = this.obj == null ? String.valueOf(retVal) + "obj is null , " : String.valueOf(retVal) + this.obj.toString();
        if (this.isArray) {
            retVal = this.is2Dimensional ? String.valueOf(retVal) + "2 dimensional array , " : "1 dimensional array , ";
            if (this.safeArrayStruct != null) {
                retVal = String.valueOf(retVal) + this.safeArrayStruct.toString();
            }
        }
        return retVal;
    }

    static final class EMPTY {
        EMPTY() {
        }
    }

    static final class NULL {
        NULL() {
        }
    }

    static final class SCODE {
        private int errorCode;

        private SCODE() {
        }

        private SCODE(int errorCode) {
            this.errorCode = errorCode;
        }
    }
}

