/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.win32.ComFactory;
import org.jinterop.dcom.win32.IJIDispatch;

public class MSPowerPoint {
    private JIComServer comStub = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;

    public MSPowerPoint(String address, String[] args) throws JIException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        this.comStub = new JIComServer(JIProgId.valueOf(session, "PowerPoint.Application"), address, session);
    }

    public void startPowerPoint() throws JIException {
        this.unknown = this.comStub.createInstance();
        this.dispatch = (IJIDispatch)ComFactory.createCOMInstance("00020400-0000-0000-c000-000000000046", this.unknown);
    }

    public void showPowerPoint() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Visible");
        JIVariant variant = new JIVariant(-1);
        this.dispatch.put(dispId, variant);
    }

    public void performOp() throws JIException, InterruptedException {
        IJIDispatch presentations = (IJIDispatch)this.dispatch.get("Presentations").getObjectAsComObject(this.unknown);
        int i = 0;
        while (i < 2) {
            JIVariant[] results = presentations.callMethodA("Add", new Object[]{JIVariant.OPTIONAL_PARAM});
            IJIDispatch presentation = (IJIDispatch)results[0].getObjectAsComObject(this.unknown);
            IJIDispatch slides = (IJIDispatch)presentation.get("Slides").getObjectAsComObject(this.unknown);
            results = slides.callMethodA("Add", new Object[]{new Integer(1), new Integer(1)});
            IJIDispatch slide = (IJIDispatch)results[0].getObjectAsComObject(this.unknown);
            IJIDispatch shapes = (IJIDispatch)slide.get("Shapes").getObjectAsComObject(this.unknown);
            IJIDispatch shape = (IJIDispatch)shapes.get("Title").getObjectAsComObject(this.unknown);
            IJIDispatch textframe = (IJIDispatch)shape.get("TextFrame").getObjectAsComObject(this.unknown);
            IJIDispatch textrange = (IJIDispatch)textframe.get("TextRange").getObjectAsComObject(this.unknown);
            if (i == 0) {
                textrange.put("Text", new JIString((String)"Presentation1").Variant);
                presentation.callMethod("SaveAs", new Object[]{new JIString((String)"C:\\temp\\presentation1.ppt").Variant, JIVariant.OPTIONAL_PARAM, new Integer(-1)});
                Thread.sleep(3000L);
                presentation.callMethod("Close");
            } else {
                textrange.put("Text", new JIString((String)"Presentation2").Variant);
                slides.callMethod("InsertFromFile", new Object[]{new JIString("C:\\temp\\presentation1.ppt"), new Integer(1), new Integer(1), new Integer(1)});
                presentation.callMethod("SaveAs", new Object[]{new JIString("C:\\temp\\presentation2.ppt"), JIVariant.OPTIONAL_PARAM, new Integer(-1)});
                Thread.sleep(3000L);
                presentation.callMethod("Close");
                this.dispatch.callMethod("Quit");
            }
            ++i;
        }
        JISession.destroySession(this.dispatch.getAssociatedSession());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            MSPowerPoint test = new MSPowerPoint(args[0], args);
            test.startPowerPoint();
            test.showPowerPoint();
            test.performOp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

