/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.win32.ComFactory;
import org.jinterop.dcom.win32.FuncDesc;
import org.jinterop.dcom.win32.IJIDispatch;
import org.jinterop.dcom.win32.IJITypeInfo;
import org.jinterop.dcom.win32.IJITypeLib;
import org.jinterop.dcom.win32.TypeAttr;
import org.jinterop.dcom.win32.VarDesc;

public class MSTypeLibraryBrowser {
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;

    public MSTypeLibraryBrowser(String address, String[] args) throws JIException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        this.comServer = new JIComServer(JIProgId.valueOf(session, "Excel.Application"), address, session);
    }

    public void start() throws JIException {
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)ComFactory.createCOMInstance("00020400-0000-0000-c000-000000000046", this.unknown);
        IJITypeInfo typeInfo = this.dispatch.getTypeInfo(0);
        IJITypeLib typeLib = (IJITypeLib)typeInfo.getContainingTypeLib()[0];
        Object[] result = typeLib.getDocumentation(-1);
        System.out.println(((JIString)result[0]).getString());
        System.out.println(((JIString)result[1]).getString());
        System.out.println(((JIString)result[3]).getString());
        System.out.println("-------------------------------");
        int typeInfoCount = typeLib.getTypeInfoCount();
        int i = 0;
        String[] g_arrClassification = new String[]{"Enum", "Struct", "Module", "Interface", "Dispinterface", "Coclass", "Typedef", "Union"};
        while (i < typeInfoCount) {
            result = typeLib.getDocumentation(i);
            int j = typeLib.getTypeInfoType(i);
            System.out.println(((JIString)result[0]).getString());
            System.out.println(((JIString)result[1]).getString());
            System.out.println(((JIString)result[3]).getString());
            System.out.println(g_arrClassification[j]);
            IJITypeInfo typeInfo2 = typeLib.getTypeInfo(i);
            TypeAttr typeAttr = typeInfo2.getTypeAttr();
            j = 0;
            while (j < typeAttr.cFuncs) {
                FuncDesc funcDesc = typeInfo2.getFuncDesc(j);
                result = typeInfo2.getDocumentation(funcDesc.memberId);
                System.out.println(((JIString)result[0]).getString());
                System.out.println(((JIString)result[1]).getString());
                System.out.println(((JIString)result[3]).getString());
                ++j;
            }
            j = 0;
            while (j < typeAttr.cVars) {
                if (j == 77) {
                    boolean funcDesc = false;
                }
                VarDesc varDesc = typeInfo2.getVarDesc(j);
                result = typeInfo2.getDocumentation(varDesc.memberId);
                System.out.println(((JIString)result[0]).getString());
                System.out.println(((JIString)result[1]).getString());
                System.out.println(((JIString)result[3]).getString());
                ++j;
            }
            System.out.println("***************************************");
            ++i;
        }
        JISession.destroySession(this.dispatch.getAssociatedSession());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            JISystem.setLogLevel(Level.INFO);
            MSTypeLibraryBrowser typeLibraryBrowser = new MSTypeLibraryBrowser(args[0], args);
            typeLibraryBrowser.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

