/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.win32.ComFactory;
import org.jinterop.dcom.win32.ElemDesc;
import org.jinterop.dcom.win32.FuncDesc;
import org.jinterop.dcom.win32.IJIDispatch;
import org.jinterop.dcom.win32.IJITypeInfo;
import org.jinterop.dcom.win32.IJITypeLib;
import org.jinterop.dcom.win32.TYPEKIND;
import org.jinterop.dcom.win32.TypeAttr;
import org.jinterop.dcom.win32.TypeDesc;
import org.jinterop.dcom.win32.VarDesc;

public class MSTypeLibraryBrowser2 {
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;

    public MSTypeLibraryBrowser2(String address, String[] args) throws JIException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        this.comServer = new JIComServer(JIProgId.valueOf(session, args[4]), address, session);
    }

    public void start() throws JIException {
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)ComFactory.createCOMInstance("00020400-0000-0000-c000-000000000046", this.unknown);
        IJITypeLib typeLib = (IJITypeLib)this.dispatch.getTypeInfo(0).getContainingTypeLib()[0];
        Object[] result = typeLib.getDocumentation(-1);
        System.out.println("Name: " + ((JIString)result[0]).getString());
        System.out.println("Library Name: " + ((JIString)result[1]).getString());
        System.out.println("Full path to help file: " + ((JIString)result[3]).getString());
        System.out.println("\n------------------------Library Members---------------------");
        int typeInfoCount = typeLib.getTypeInfoCount();
        String[] g_arrClassification = new String[]{"Enum", "Struct", "Module", "Interface", "Dispinterface", "Coclass", "Typedef", "Union"};
        int l = 0;
        while (l < typeInfoCount) {
            int nCount;
            Object[] ret;
            System.out.println("\n\n-----------------------Member Description--------------------------");
            result = typeLib.getDocumentation(l);
            int k = typeLib.getTypeInfoType(l);
            System.out.println("Name: " + ((JIString)result[0]).getString());
            System.out.println("Type: " + g_arrClassification[k]);
            IJITypeInfo typeInfo = typeLib.getTypeInfo(l);
            TypeAttr typeAttr = typeInfo.getTypeAttr();
            IJITypeInfo ptempInfo = null;
            TypeAttr pTempAttr = null;
            if (typeAttr.typekind != TYPEKIND.TKIND_DISPATCH && typeAttr.typekind != TYPEKIND.TKIND_COCLASS) {
                int p = 0;
                ++p;
            }
            if (typeAttr.typekind == TYPEKIND.TKIND_COCLASS) {
                int i = 0;
                while (i < typeAttr.cImplTypes) {
                    block39: {
                        int nFlags = -1;
                        try {
                            nFlags = typeInfo.getImplTypeFlags(i);
                        }
                        catch (JIException e) {
                            break block39;
                        }
                        if ((nFlags & 1) == 1) {
                            int hRefType = -1;
                            try {
                                hRefType = typeInfo.getRefTypeOfImplType(i);
                            }
                            catch (JIException e) {
                                break;
                            }
                            try {
                                ptempInfo = typeInfo.getRefTypeInfo(hRefType);
                            }
                            catch (JIException e) {
                                break;
                            }
                            try {
                                pTempAttr = ptempInfo.getTypeAttr();
                            }
                            catch (JIException e) {
                                System.out.println("Failed to get reference type info.");
                                return;
                            }
                        }
                    }
                    ++i;
                }
            }
            if (pTempAttr != null) {
                typeInfo = ptempInfo;
                typeAttr = pTempAttr;
            }
            int m_nMethodCount = typeAttr.cFuncs;
            short m_nVarCount = typeAttr.cVars;
            int m_nDispInfoCount = m_nMethodCount + 2 * m_nVarCount;
            System.out.println("Method and variable count = " + m_nMethodCount + m_nVarCount + "\n\n");
            int i = 0;
            while (i < m_nMethodCount) {
                FuncDesc pFuncDesc;
                System.out.println("************Method Seperator*****************");
                try {
                    pFuncDesc = typeInfo.getFuncDesc(i);
                }
                catch (JIException e) {
                    e.printStackTrace();
                    return;
                }
                System.out.println(String.valueOf(i) + ": DispID = " + pFuncDesc.memberId);
                try {
                    ret = typeInfo.getNames(pFuncDesc.memberId, 1);
                    System.out.println("MethodName = " + ((JIString)((Object[])((JIArray)ret[0]).getArrayInstance())[0]).getString());
                    nCount = (Integer)ret[1];
                }
                catch (JIException e) {
                    System.out.println("GetNames failed.");
                    return;
                }
                switch (pFuncDesc.invokeKind) {
                    case 2: {
                        System.out.println("PropertyGet");
                        break;
                    }
                    case 4: {
                        System.out.println("PropertyPut");
                        break;
                    }
                    case 8: {
                        System.out.println("PropertyPutRef");
                        break;
                    }
                    case 1: {
                        System.out.println("DispatchMethod");
                        break;
                    }
                }
                System.out.println("VTable offset: " + pFuncDesc.oVft);
                System.out.println("Calling convention: " + pFuncDesc.callConv);
                System.out.println("Return type = " + pFuncDesc.elemdescFunc.typeDesc.vt);
                System.out.println("ParamCount = " + pFuncDesc.cParams);
                JIArray array = (JIArray)pFuncDesc.lprgelemdescParam.getReferent();
                Object[] types = null;
                if (array != null) {
                    types = (Object[])array.getArrayInstance();
                }
                int j = 0;
                while (j < pFuncDesc.cParams) {
                    if (((ElemDesc)types[j]).typeDesc.vt == TypeDesc.VT_SAFEARRAY) {
                        System.out.println("Param(" + j + ") type = SafeArray");
                    } else if (((ElemDesc)types[j]).typeDesc.vt == TypeDesc.VT_PTR) {
                        System.out.println("Param(" + j + ") type = Pointer");
                    } else {
                        System.out.println("Param(" + j + ") type = UserDefined");
                    }
                    ++j;
                }
                ++i;
            }
            i = m_nMethodCount;
            while (i < m_nMethodCount + m_nVarCount) {
                VarDesc pVarDesc;
                System.out.println("************Variable Seperator*****************");
                try {
                    pVarDesc = typeInfo.getVarDesc(i - m_nMethodCount);
                }
                catch (JIException e) {
                    System.out.println("GetVarDesc failed.");
                    return;
                }
                System.out.println(String.valueOf(i) + ": DispID = " + pVarDesc.memberId);
                try {
                    ret = typeInfo.getNames(pVarDesc.memberId, 1);
                    System.out.println("VarName = " + ((JIString)((Object[])((JIArray)ret[0]).getArrayInstance())[0]).getString());
                    nCount = (Integer)ret[1];
                }
                catch (JIException e) {
                    System.out.println("GetNames failed.");
                    return;
                }
                switch (pVarDesc.varkind) {
                    case 3: {
                        System.out.println("VarKind = VAR_DISPATCH");
                        System.out.println("VarType = " + pVarDesc.elemdescVar.typeDesc.vt);
                        break;
                    }
                    default: {
                        System.out.println("VarKind = " + pVarDesc.varkind);
                    }
                }
                ++i;
            }
            ++l;
        }
        System.out.println("########################Execution complete#########################");
        JISession.destroySession(this.dispatch.getAssociatedSession());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 5) {
                System.out.println("Please provide address domain username password progIdOfApplication");
                return;
            }
            JISystem.setLogLevel(Level.ALL);
            MSTypeLibraryBrowser2 typeLibraryBrowser = new MSTypeLibraryBrowser2(args[0], args);
            typeLibraryBrowser.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

