/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.IJICOMRuntimeWorker;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComRuntimeNTLMConnectionContext;
import rpc.ConnectionOrientedEndpoint;
import rpc.ConnectionOrientedPdu;
import rpc.FaultException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.core.PresentationSyntax;
import rpc.core.UUID;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.Auth3Pdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public final class JIComRuntimeEndpoint
extends ConnectionOrientedEndpoint {
    JIComRuntimeEndpoint(Transport transport, PresentationSyntax syntax) {
        super(transport, syntax);
    }

    public void call(int semantics, UUID object, int opnum, NdrObject ndrobj) throws IOException {
        throw new JIRuntimeException(4121);
    }

    public void processRequests(IJICOMRuntimeWorker workerObject) throws IOException {
        this.bind();
        while (true) {
            ConnectionOrientedPdu response = null;
            ConnectionOrientedPdu request = this.receive();
            JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] request : " + Thread.currentThread().getName() + " , " + request + " workerObject is resolver: " + workerObject.isResolver());
            NdrBuffer buffer = null;
            NetworkDataRepresentation ndr = new NetworkDataRepresentation();
            if (request instanceof RequestCoPdu) {
                buffer = new NdrBuffer(((RequestCoPdu)request).getStub(), 0);
                if (buffer.buf != null && JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])buffer.buf, (int)0, (int)buffer.buf.length);
                    JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
                }
                ndr.setFormat(((RequestCoPdu)request).getFormat());
                workerObject.setOpnum(((RequestCoPdu)request).getOpnum());
                workerObject.setCurrentObjectID(((RequestCoPdu)request).getObject());
                try {
                    ((NdrObject)workerObject).decode(ndr, buffer);
                    ResponseCoPdu responseCoPdu = new ResponseCoPdu();
                    responseCoPdu.setFormat(((RequestCoPdu)request).getFormat());
                    responseCoPdu.setCallId(((RequestCoPdu)request).getCallId());
                    ((NdrObject)workerObject).encode(ndr, null);
                    responseCoPdu.setAllocationHint(ndr.getBuffer().length);
                    responseCoPdu.setStub(ndr.getBuffer().getBuffer());
                    response = responseCoPdu;
                }
                catch (JIRuntimeException e) {
                    JISystem.getLogger().exception("", "", e);
                    response = new FaultCoPdu();
                    response.setCallId(((RequestCoPdu)request).getCallId());
                    ((FaultCoPdu)response).setStatus(e.getHResult());
                }
            } else if (request instanceof BindPdu || request instanceof AlterContextPdu) {
                if (!workerObject.isResolver() && this.context instanceof JIComRuntimeNTLMConnectionContext) {
                    ((JIComRuntimeNTLMConnectionContext)this.context).updateListOfInterfacesSupported(workerObject.getQIedIIDs());
                }
                response = this.context.accept(request);
                if (!workerObject.isResolver()) {
                    PresentationResult[] result = null;
                    PresentationContext context = null;
                    boolean successful = false;
                    if (response instanceof BindAcknowledgePdu) {
                        result = ((BindAcknowledgePdu)response).getResultList();
                        successful = result[0].result == 0;
                        context = ((BindPdu)request).getContextList()[0];
                    } else {
                        result = ((AlterContextResponsePdu)response).getResultList();
                        successful = result[0].result == 0;
                        context = ((AlterContextPdu)request).getContextList()[0];
                    }
                }
            } else {
                if (request instanceof FaultCoPdu) {
                    FaultCoPdu fault = (FaultCoPdu)request;
                    throw new FaultException("Received fault.", fault.getStatus(), fault.getStub());
                }
                if (request instanceof ShutdownPdu) {
                    throw new RpcException("Received shutdown request from server.");
                }
                if (request instanceof Auth3Pdu) continue;
            }
            JISystem.getLogger().info("processRequests: [JIComRuntimeEndPoint] response : " + Thread.currentThread().getName() + " , " + response);
            this.send(response);
        }
    }
}

