/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import rpc.BasicConnectionContext;
import rpc.ConnectionContext;
import rpc.ConnectionOrientedPdu;
import rpc.Endpoint;
import rpc.FaultException;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationContext;
import rpc.core.PresentationSyntax;
import rpc.core.UUID;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public class ConnectionOrientedEndpoint
implements Endpoint {
    public static final String CONNECTION_CONTEXT = "rpc.connectionContext";
    protected ConnectionContext context;
    private Transport transport;
    private PresentationSyntax syntax;
    private boolean bound;
    private int callId;

    public ConnectionOrientedEndpoint(Transport transport, PresentationSyntax syntax) {
        this.transport = transport;
        this.syntax = syntax;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public PresentationSyntax getSyntax() {
        return this.syntax;
    }

    public void call(int semantics, UUID object, int opnum, NdrObject ndrobj) throws IOException {
        this.bind();
        RequestCoPdu request = new RequestCoPdu();
        request.setCallId(++this.callId);
        byte[] b = new byte[1024];
        NdrBuffer buffer = new NdrBuffer(b, 0);
        NetworkDataRepresentation ndr = new NetworkDataRepresentation();
        ndrobj.encode(ndr, buffer);
        byte[] stub = new byte[buffer.getLength()];
        System.arraycopy(buffer.buf, 0, stub, 0, stub.length);
        if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])stub, (int)0, (int)stub.length);
            JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
        }
        request.setStub(stub);
        request.setAllocationHint(buffer.getLength());
        request.setOpnum(opnum);
        request.setObject(object);
        if ((semantics & 1) != 0) {
            request.setFlag(64, true);
        }
        this.send((ConnectionOrientedPdu)request);
        if (request.getFlag(64)) {
            return;
        }
        ConnectionOrientedPdu reply = this.receive();
        if (reply instanceof ResponseCoPdu) {
            ndr.setFormat(reply.getFormat());
            buffer = new NdrBuffer(((ResponseCoPdu)reply).getStub(), 0);
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])buffer.buf, (int)0, (int)buffer.buf.length);
                JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
            }
        } else {
            if (reply instanceof FaultCoPdu) {
                FaultCoPdu fault = (FaultCoPdu)reply;
                throw new FaultException("Received fault.", fault.getStatus(), fault.getStub());
            }
            if (reply instanceof ShutdownPdu) {
                throw new RpcException("Received shutdown request from server.");
            }
            throw new RpcException("Received unexpected PDU from server.");
        }
        ndrobj.decode(ndr, buffer);
    }

    protected void rebind() throws IOException {
        this.bound = false;
        this.bind();
    }

    protected void bind() throws IOException {
        if (this.bound) {
            return;
        }
        if (this.context != null) {
            this.bound = true;
            try {
                ConnectionOrientedPdu pdu = this.context.alter(new PresentationContext(0, this.getSyntax()));
                if (pdu != null) {
                    this.send(pdu);
                }
                while (!this.context.isEstablished()) {
                    pdu = this.context.accept(this.receive());
                    if (pdu == null) continue;
                    this.send(pdu);
                }
            }
            catch (IOException ex) {
                this.bound = false;
                throw ex;
            }
            catch (RuntimeException ex) {
                this.bound = false;
                throw ex;
            }
            catch (Exception ex) {
                this.bound = false;
                throw new IOException(ex.getMessage());
            }
        } else {
            this.connect();
        }
    }

    protected void send(ConnectionOrientedPdu request) throws IOException {
        this.bind();
        this.context.getConnection().transmit(request, this.getTransport());
    }

    protected ConnectionOrientedPdu receive() throws IOException {
        return this.context.getConnection().receive(this.getTransport());
    }

    public void detach() throws IOException {
        this.bound = false;
        this.context = null;
        this.getTransport().close();
    }

    private void connect() throws IOException {
        this.bound = true;
        try {
            this.context = this.createContext();
            ConnectionOrientedPdu pdu = this.context.init(new PresentationContext(0, this.getSyntax()), this.getTransport().getProperties());
            if (pdu != null) {
                this.send(pdu);
            }
            while (!this.context.isEstablished()) {
                pdu = this.context.accept(this.receive());
                if (pdu == null) continue;
                this.send(pdu);
            }
        }
        catch (IOException ex) {
            try {
                this.detach();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            try {
                this.detach();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        catch (Exception ex) {
            try {
                this.detach();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(ex.getMessage());
        }
    }

    protected ConnectionContext createContext() throws ProviderException {
        Properties properties = this.getTransport().getProperties();
        if (properties == null) {
            return new BasicConnectionContext();
        }
        String context = properties.getProperty(CONNECTION_CONTEXT);
        if (context == null) {
            return new BasicConnectionContext();
        }
        try {
            return (ConnectionContext)Class.forName(context).newInstance();
        }
        catch (Exception ex) {
            throw new ProviderException(ex.getMessage());
        }
    }
}

