/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import rpc.Connection;
import rpc.ConnectionOrientedPdu;
import rpc.Fragmentable;
import rpc.RpcException;
import rpc.Security;
import rpc.Transport;
import rpc.core.AuthenticationVerifier;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.Auth3Pdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindNoAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.CancelCoPdu;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.OrphanedPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public class DefaultConnection
implements Connection {
    protected NetworkDataRepresentation ndr = new NetworkDataRepresentation();
    protected NdrBuffer transmitBuffer;
    protected NdrBuffer receiveBuffer;
    protected Security security;
    protected int contextId;
    private boolean bytesRemainingInRecieveBuffer = false;

    public DefaultConnection() {
        this(1432, 1432);
    }

    public DefaultConnection(int transmitLength, int receiveLength) {
        this.transmitBuffer = new NdrBuffer(new byte[transmitLength], 0);
        this.receiveBuffer = new NdrBuffer(new byte[receiveLength], 0);
    }

    public void transmit(ConnectionOrientedPdu pdu, Transport transport) throws IOException {
        if (!(pdu instanceof Fragmentable)) {
            this.transmitFragment(pdu, transport);
            return;
        }
        Iterator fragments = ((Fragmentable)pdu).fragment(this.transmitBuffer.getCapacity());
        while (fragments.hasNext()) {
            this.transmitFragment((ConnectionOrientedPdu)fragments.next(), transport);
        }
    }

    public ConnectionOrientedPdu receive(final Transport transport) throws IOException {
        ConnectionOrientedPdu fragment = this.receiveFragment(transport);
        if (!(fragment instanceof Fragmentable) || fragment.getFlag(2)) {
            return fragment;
        }
        return (ConnectionOrientedPdu)((Fragmentable)fragment).assemble(new Iterator(fragment){
            ConnectionOrientedPdu currentFragment;
            private int i;
            {
                this.currentFragment = connectionOrientedPdu;
                this.i = 0;
            }

            public boolean hasNext() {
                return this.currentFragment != null;
            }

            public Object next() {
                ConnectionOrientedPdu connectionOrientedPdu;
                if (this.currentFragment == null) {
                    throw new NoSuchElementException();
                }
                try {
                    connectionOrientedPdu = this.currentFragment;
                    Object var1_2 = null;
                }
                catch (Throwable throwable) {
                    Object var1_3 = null;
                    if (this.currentFragment.getFlag(2)) {
                        this.currentFragment = null;
                    } else {
                        try {
                            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                                JISystem.getLogger().finest("[Fragmented Packet] [" + this.i++ + "] recieved , fragment decomposition is below:- ");
                            }
                            this.currentFragment = DefaultConnection.this.receiveFragment(transport);
                        }
                        catch (Exception ex) {
                            throw new IllegalStateException();
                        }
                    }
                    throw throwable;
                }
                if (this.currentFragment.getFlag(2)) {
                    this.currentFragment = null;
                } else {
                    try {
                        if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                            JISystem.getLogger().finest("[Fragmented Packet] [" + this.i++ + "] recieved , fragment decomposition is below:- ");
                        }
                        this.currentFragment = DefaultConnection.this.receiveFragment(transport);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException();
                    }
                }
                return connectionOrientedPdu;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    protected void transmitFragment(ConnectionOrientedPdu fragment, Transport transport) throws IOException {
        this.transmitBuffer.reset();
        fragment.encode(this.ndr, this.transmitBuffer);
        this.processOutgoing();
        if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.transmitBuffer.getBuffer(), (int)0, (int)this.transmitBuffer.length);
            JISystem.getLogger().finest("[TRANSMIT BUFFER]:-\n" + byteArrayOutputStream.toString());
        }
        transport.send(this.transmitBuffer);
    }

    protected ConnectionOrientedPdu receiveFragment(Transport transport) throws IOException {
        int fragmentLength = -1;
        int type = -1;
        boolean read = true;
        if (this.bytesRemainingInRecieveBuffer) {
            this.receiveBuffer.setIndex(2);
            type = this.receiveBuffer.dec_ndr_small();
            if (this.isValidType(type)) {
                read = false;
            } else if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("\n bytesRemainingInRecieveBuffer is TRUE, RecieveBuffer size =  " + this.receiveBuffer.buf.length);
            }
            this.bytesRemainingInRecieveBuffer = false;
        }
        if (read) {
            this.receiveBuffer.reset();
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("\n Reading bytes from RecieveBuffer Socket...Current Capacity:- " + this.receiveBuffer.getCapacity());
            }
            transport.receive(this.receiveBuffer);
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("[RECIEVER BUFFER] Full packet is dumped below...");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.receiveBuffer.getBuffer(), (int)0, (int)this.receiveBuffer.length);
                JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
            }
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("\n Bytes read from RecieveBuffer Socket:- " + this.receiveBuffer.length);
            }
        }
        byte[] newbuffer = null;
        int counter = 0;
        int trimSize = -1;
        int lengthOfArrayTobeRead = this.receiveBuffer.length;
        if (this.receiveBuffer.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.receiveBuffer.setIndex(8);
            fragmentLength = this.receiveBuffer.dec_ndr_short();
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("\n length of the fragment " + fragmentLength);
                JISystem.getLogger().finest("\n size in bytes of the buffer [] " + this.receiveBuffer.buf.length);
            }
            newbuffer = new byte[fragmentLength];
            if (fragmentLength > this.receiveBuffer.length) {
                int remainingBytes = fragmentLength - this.receiveBuffer.length;
                if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                    JISystem.getLogger().finest("\n Some bytes from RecieveBuffer Socket have not been read: Remaining  " + remainingBytes);
                }
                while (fragmentLength > counter) {
                    System.arraycopy(this.receiveBuffer.buf, 0, newbuffer, counter, lengthOfArrayTobeRead);
                    if (fragmentLength != (counter += lengthOfArrayTobeRead)) {
                        if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                            JISystem.getLogger().finest("\n About to read more bytes from socket , current counter is: " + counter);
                        }
                        this.receiveBuffer.reset();
                        transport.receive(this.receiveBuffer);
                        if (fragmentLength - counter >= this.receiveBuffer.length) {
                            lengthOfArrayTobeRead = this.receiveBuffer.length;
                        } else {
                            lengthOfArrayTobeRead = fragmentLength - counter;
                            trimSize = this.receiveBuffer.length - lengthOfArrayTobeRead;
                        }
                        if (JISystem.getLogLevel().intValue() > Level.FINEST.intValue()) continue;
                        JISystem.getLogger().finest("\nlengthOfArrayTobeRead = " + lengthOfArrayTobeRead);
                        JISystem.getLogger().finest("\ntrimSize = " + trimSize);
                        JISystem.getLogger().finest("\nRecieveBuffer current read size: " + this.receiveBuffer.length);
                        JISystem.getLogger().finest("\n\n[RECIEVER BUFFER] and the read packet is dumped below...");
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.receiveBuffer.getBuffer(), (int)0, (int)this.receiveBuffer.length);
                        JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
                        continue;
                    }
                    break;
                }
            } else {
                if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                    JISystem.getLogger().finest("\nfragmentLength is less than  receiveBuffer.length");
                }
                System.arraycopy(this.receiveBuffer.buf, 0, newbuffer, 0, fragmentLength);
                trimSize = this.receiveBuffer.length - fragmentLength;
            }
            if (trimSize > 0) {
                if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                    JISystem.getLogger().finest("\ntrimSize = " + trimSize);
                }
                System.arraycopy(this.receiveBuffer.buf, this.receiveBuffer.length - trimSize, this.receiveBuffer.buf, 0, trimSize);
                this.receiveBuffer.length = trimSize;
                this.receiveBuffer.index = 0;
                this.receiveBuffer.start = 0;
                this.bytesRemainingInRecieveBuffer = true;
            }
            NdrBuffer bufferToBeUsed = new NdrBuffer(newbuffer, 0);
            bufferToBeUsed.length = newbuffer.length;
            if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                JISystem.getLogger().finest("\nbufferToBeUsed Size = " + bufferToBeUsed.length);
                JISystem.getLogger().finest("\n\n[bufferToBeUsed] packet is dumped below...");
                byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])bufferToBeUsed.getBuffer(), (int)0, (int)bufferToBeUsed.length);
                JISystem.getLogger().finest("\n" + byteArrayOutputStream.toString());
                JISystem.getLogger().finest("\n*********************************************************************************");
            }
            this.processIncoming(bufferToBeUsed);
            bufferToBeUsed.setIndex(2);
            type = bufferToBeUsed.dec_ndr_small();
            Object pdu = null;
            switch (type) {
                case 14: {
                    pdu = new AlterContextPdu();
                    break;
                }
                case 15: {
                    pdu = new AlterContextResponsePdu();
                    break;
                }
                case 16: {
                    pdu = new Auth3Pdu();
                    break;
                }
                case 11: {
                    pdu = new BindPdu();
                    break;
                }
                case 12: {
                    pdu = new BindAcknowledgePdu();
                    break;
                }
                case 13: {
                    pdu = new BindNoAcknowledgePdu();
                    break;
                }
                case 18: {
                    pdu = new CancelCoPdu();
                    break;
                }
                case 3: {
                    pdu = new FaultCoPdu();
                    break;
                }
                case 19: {
                    pdu = new OrphanedPdu();
                    break;
                }
                case 0: {
                    pdu = new RequestCoPdu();
                    break;
                }
                case 2: {
                    pdu = new ResponseCoPdu();
                    break;
                }
                case 17: {
                    pdu = new ShutdownPdu();
                    break;
                }
                default: {
                    throw new IOException("Unknown PDU type: 0x" + Integer.toHexString(type));
                }
            }
            bufferToBeUsed.setIndex(0);
            pdu.decode(this.ndr, bufferToBeUsed);
            return pdu;
        }
        throw new IOException("Socket Closed");
    }

    private boolean isValidType(int type) {
        switch (type) {
            case 0: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    protected void processIncoming(NdrBuffer buffer) throws IOException {
        buffer.setIndex(2);
        boolean logMsg = true;
        switch (buffer.dec_ndr_small()) {
            case 12: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved BIND_ACK");
                    logMsg = false;
                }
            }
            case 15: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved ALTER_CTX_RESP");
                    logMsg = false;
                }
            }
            case 11: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved BIND");
                    logMsg = false;
                }
            }
            case 14: {
                AuthenticationVerifier verifier;
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved ALTER_CTX");
                    logMsg = false;
                }
                if ((verifier = this.detachAuthentication(buffer)) == null) break;
                this.incomingRebind(verifier);
                break;
            }
            case 3: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved FAULT");
                    logMsg = false;
                }
            }
            case 18: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved CANCEL");
                    logMsg = false;
                }
            }
            case 19: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved ORPHANED");
                    logMsg = false;
                }
            }
            case 2: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved RESPONSE");
                    logMsg = false;
                }
            }
            case 0: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved REQUEST");
                    logMsg = false;
                }
                this.detachAuthentication(buffer);
                break;
            }
            case 16: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Recieved AUTH3");
                    logMsg = false;
                }
                this.incomingRebind(this.detachAuthentication2(buffer));
                break;
            }
            case 13: 
            case 17: {
                return;
            }
            default: {
                throw new RpcException("Invalid incoming PDU type.");
            }
        }
    }

    protected void processOutgoing() throws IOException {
        this.ndr.getBuffer().setIndex(2);
        boolean logMsg = true;
        switch (this.ndr.readUnsignedSmall()) {
            case 11: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending BIND");
                    logMsg = false;
                }
            }
            case 16: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending AUTH3");
                    logMsg = false;
                }
            }
            case 12: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending BIND_ACK");
                    logMsg = false;
                }
            }
            case 15: {
                AuthenticationVerifier verifier;
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending ALTER_CTX_RESP");
                    logMsg = false;
                }
                if ((verifier = this.outgoingRebind()) == null) break;
                this.attachAuthentication(verifier);
                break;
            }
            case 14: {
                if (!logMsg) break;
                JISystem.getLogger().info("\n Sending ALTER_CTX");
                logMsg = false;
                break;
            }
            case 0: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending REQUEST");
                    logMsg = false;
                }
            }
            case 18: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending CANCEL");
                    logMsg = false;
                }
            }
            case 19: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending ORPHANED");
                    logMsg = false;
                }
            }
            case 3: {
                if (logMsg) {
                    JISystem.getLogger().info("\n Sending FAULT");
                    logMsg = false;
                }
            }
            case 2: {
                if (!logMsg) break;
                JISystem.getLogger().info("\n Sending RESPONSE");
                logMsg = false;
                break;
            }
            case 13: 
            case 17: {
                return;
            }
            default: {
                throw new RpcException("Invalid outgoing PDU type.");
            }
        }
    }

    protected void setSecurity(Security security) {
        this.security = security;
    }

    private void attachAuthentication(AuthenticationVerifier verifier) throws IOException {
        try {
            NdrBuffer buffer = this.ndr.getBuffer();
            int length = buffer.getLength();
            buffer.setIndex(length);
            verifier.encode(this.ndr, buffer);
            length = buffer.getLength();
            buffer.setIndex(8);
            this.ndr.writeUnsignedShort(length);
            this.ndr.writeUnsignedShort(verifier.body.length);
        }
        catch (Exception ex) {
            throw new IOException("Error attaching authentication to PDU: " + ex.getMessage());
        }
    }

    private AuthenticationVerifier detachAuthentication2(NdrBuffer buffer) throws IOException {
        try {
            buffer.setIndex(10);
            int length = buffer.dec_ndr_short();
            int index = 20;
            buffer.setIndex(index);
            AuthenticationVerifier verifier = new AuthenticationVerifier(length);
            verifier.decode(this.ndr, buffer);
            buffer.setIndex(index + 2);
            length = index - buffer.dec_ndr_small();
            buffer.setIndex(8);
            buffer.enc_ndr_short(length);
            buffer.enc_ndr_short(0);
            buffer.setIndex(length);
            return verifier;
        }
        catch (Exception ex) {
            throw new IOException("Error stripping authentication from PDU: " + ex);
        }
    }

    private AuthenticationVerifier detachAuthentication(NdrBuffer buffer) throws IOException {
        int length;
        block5: {
            try {
                buffer.setIndex(10);
                length = buffer.dec_ndr_short();
                if (length != 0) break block5;
                if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
                    JISystem.getLogger().finest("\nIn [detachAuthentication] No authn info present...");
                }
                return null;
            }
            catch (Exception ex) {
                throw new IOException("Error stripping authentication from PDU: " + ex);
            }
        }
        int index = buffer.getLength() - length - 8;
        buffer.setIndex(index);
        AuthenticationVerifier verifier = new AuthenticationVerifier(length);
        verifier.decode(this.ndr, buffer);
        buffer.setIndex(index + 2);
        length = index - buffer.dec_ndr_small();
        buffer.setIndex(8);
        buffer.enc_ndr_short(length);
        buffer.enc_ndr_short(0);
        buffer.setIndex(length);
        if (JISystem.getLogLevel().intValue() <= Level.FINEST.intValue()) {
            JISystem.getLogger().finest("\nIn [detachAuthentication] (after stripping authn info) setting new FRAG_LENGTH_OFFSET for the packet as = " + length);
        }
        return verifier;
    }

    protected void incomingRebind(AuthenticationVerifier verifier) throws IOException {
    }

    protected AuthenticationVerifier outgoingRebind() throws IOException {
        return null;
    }
}

