/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Random;
import jcifs.Config;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.HMACT64;
import jcifs.util.MD4;
import rpc.ProviderException;
import rpc.Security;
import rpc.security.ntlm.ArcFour;
import rpc.security.ntlm.AuthenticationSource;
import rpc.security.ntlm.DES;
import rpc.security.ntlm.Ntlm1;
import rpc.security.ntlm.Ntlm2;

public class NtlmAuthentication {
    public static final int AUTHENTICATION_SERVICE_NTLM = 10;
    private static final int LM_COMPATIBILITY = Config.getInt((String)"jcifs.smb.lmCompatibility", (int)0);
    private static final boolean UNICODE_SUPPORTED = Config.getBoolean((String)"jcifs.smb.client.useUnicode", (boolean)true);
    private static final String OEM_ENCODING = Config.getProperty((String)"jcifs.smb.client.codepage", (String)Config.getProperty((String)"jcifs.encoding", (String)System.getProperty("file.encoding")));
    private static final int BASIC_FLAGS = 0x8202 | (UNICODE_SUPPORTED ? 1 : 0);
    private static final byte[] LM_CONSTANT = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private static final Random RANDOM = new Random();
    protected Properties properties;
    private NtlmPasswordAuthentication credentials;
    private InetAddress inetAddress = null;
    private AuthenticationSource authenticationSource;
    private boolean lanManagerKey;
    private boolean seal;
    private boolean sign;
    private boolean keyExchange;
    private int keyLength = 40;

    public NtlmAuthentication(Properties properties) {
        this.properties = properties;
        String domain = null;
        String user = null;
        String password = null;
        if (properties != null) {
            this.lanManagerKey = Boolean.valueOf(properties.getProperty("rpc.ntlm.lanManagerKey"));
            this.seal = Boolean.valueOf(properties.getProperty("rpc.ntlm.seal"));
            this.sign = this.seal ? true : Boolean.valueOf(properties.getProperty("rpc.ntlm.sign"));
            this.keyExchange = Boolean.valueOf(properties.getProperty("rpc.ntlm.keyExchange"));
            String keyLength = properties.getProperty("rpc.ntlm.keyLength");
            if (keyLength != null) {
                try {
                    this.keyLength = Integer.parseInt(keyLength);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid key length: " + keyLength);
                }
            }
            domain = properties.getProperty("rpc.ntlm.domain");
            user = properties.getProperty("rpc.security.username");
            password = properties.getProperty("rpc.security.password");
        }
        this.credentials = new NtlmPasswordAuthentication(domain, user, password);
        try {
            this.inetAddress = InetAddress.getByName(this.credentials.getDomain());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Security createSecurity(boolean server, Type2Message type2, Type3Message type3) throws IOException {
        byte[] sessionKey;
        int flags;
        boolean datagram = type2.getFlag(64);
        int n = flags = datagram ? type3.getFlags() : type2.getFlags();
        if (!server && (flags & 0x30) == 0) {
            return null;
        }
        if (this.inetAddress != null && (this.inetAddress.isSiteLocalAddress() || this.inetAddress.isLoopbackAddress())) {
            return null;
        }
        byte[] byArray = sessionKey = server ? this.getAuthenticationSource().authenticate(this.properties, type2, type3) : this.getSessionKey(type2, type3);
        if (sessionKey == null) {
            return null;
        }
        byte[] exchangedKey = (flags & 0x40000000) != 0 ? type3.getSessionKey() : null;
        return type3.getFlag(524288) ? new Ntlm2(server, flags, sessionKey, exchangedKey, datagram) : new Ntlm1(flags, sessionKey, exchangedKey, datagram);
    }

    protected AuthenticationSource getAuthenticationSource() {
        String sourceClass;
        if (this.authenticationSource != null) {
            return this.authenticationSource;
        }
        String string = sourceClass = this.properties != null ? this.properties.getProperty("rpc.ntlm.authenticationSource") : null;
        if (sourceClass == null) {
            this.authenticationSource = AuthenticationSource.getDefaultInstance();
            return this.authenticationSource;
        }
        try {
            this.authenticationSource = (AuthenticationSource)Class.forName(sourceClass).newInstance();
            return this.authenticationSource;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid authentication source: " + ex);
        }
    }

    private int getDefaultFlags() {
        int flags = BASIC_FLAGS;
        if (this.lanManagerKey) {
            flags |= 0x80;
        }
        if (this.sign) {
            flags |= 0x10;
        }
        if (this.seal) {
            flags |= 0x20;
        }
        if (this.keyExchange) {
            flags |= 0x40000000;
        }
        if (this.keyLength >= 56) {
            flags |= Integer.MIN_VALUE;
        }
        if (this.keyLength >= 128) {
            flags |= 0x20000000;
        }
        return flags;
    }

    private int adjustFlags(int flags) {
        if (UNICODE_SUPPORTED && (flags & 1) != 0) {
            flags &= 0xFFFFFFFD;
            flags |= 1;
        } else {
            flags &= 0xFFFFFFFE;
            flags |= 2;
        }
        if (!this.lanManagerKey) {
            flags &= 0xFFFFFF7F;
        }
        if (!this.sign && !this.seal) {
            flags &= 0xFFFFFFEF;
        }
        if (!this.seal) {
            flags &= 0xFFFFFFDF;
        }
        if (!this.keyExchange) {
            flags &= 0xBFFFFFFF;
        }
        if (this.keyLength < 128) {
            flags &= 0xDFFFFFFF;
        }
        if (this.keyLength < 56) {
            flags &= Integer.MAX_VALUE;
        }
        return flags &= 0xFFF7FFFF;
    }

    public Type1Message createType1() throws IOException {
        int flags = this.getDefaultFlags();
        return new Type1Message(flags, Type1Message.getDefaultDomain(), Type1Message.getDefaultWorkstation());
    }

    public Type2Message createType2(Type1Message type1) throws IOException {
        int flags = type1 == null ? this.getDefaultFlags() : this.adjustFlags(type1.getFlags());
        if (this.inetAddress != null && (this.inetAddress.isSiteLocalAddress() || this.inetAddress.isLoopbackAddress())) {
            return new Type2Message(flags, new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, Type2Message.getDefaultDomain());
        }
        return new Type2Message(flags, this.getAuthenticationSource().createChallenge(this.properties, type1), Type2Message.getDefaultDomain());
    }

    public Type3Message createType3(Type2Message type2) throws IOException {
        int flags = type2.getFlags();
        if ((flags & 0x40) != 0) {
            flags = this.adjustFlags(flags);
        }
        byte[] challenge = type2.getChallenge();
        byte[] lmResponse = NtlmPasswordAuthentication.getPreNTLMResponse((String)this.credentials.getPassword(), (byte[])challenge);
        byte[] ntResponse = NtlmPasswordAuthentication.getNTLMResponse((String)this.credentials.getPassword(), (byte[])challenge);
        Type3Message type3 = new Type3Message(flags, lmResponse, ntResponse, this.credentials.getDomain(), this.credentials.getUsername(), Type3Message.getDefaultWorkstation());
        if ((flags & 0x40000000) != 0) {
            byte[] exchangedKey = new byte[16];
            RANDOM.nextBytes(exchangedKey);
            new ArcFour(this.getSessionKey(type2, type3), false).process(exchangedKey, 0, 16, exchangedKey, 0);
            type3.setSessionKey(exchangedKey);
        }
        return type3;
    }

    private byte[] getSessionKey(Type2Message type2, Type3Message type3) throws IOException {
        int flags;
        int n = flags = type2.getFlag(64) ? type3.getFlags() : type2.getFlags();
        if (LM_COMPATIBILITY < 3) {
            return (flags & 0x80) != 0 ? this.v1LmSessionKey(flags, type2, type3) : this.v1UserSessionKey(flags, type2, type3);
        }
        return (flags & 0x80) != 0 ? this.v2LmSessionKey(flags, type2, type3) : this.v2UserSessionKey(flags, type2, type3);
    }

    private byte[] v1LmSessionKey(int flags, Type2Message type2, Type3Message type3) throws IOException {
        if (LM_COMPATIBILITY == 2) {
            throw new ProviderException("LanManager session keys are incompatible with LmCompatibility = 2.");
        }
        byte[] response = type3.getLMResponse();
        if (response == null) {
            throw new ProviderException("LanManager session key requires the LM Response.");
        }
        String password = this.credentials.getPassword();
        if (password == null) {
            password = "";
        }
        byte[] lmHash = NtlmAuthentication.lmHash(password);
        int i = 8;
        while (i < 14) {
            lmHash[i] = -67;
            ++i;
        }
        byte[] sessionKey = new byte[16];
        new DES(DES.createKey((byte[])lmHash, (int)0)).process(response, 0, 8, sessionKey, 0);
        new DES(DES.createKey((byte[])lmHash, (int)7)).process(response, 0, 8, sessionKey, 8);
        return sessionKey;
    }

    private byte[] v1UserSessionKey(int flags, Type2Message type2, Type3Message type3) throws IOException {
        String password = this.credentials.getPassword();
        if (password == null) {
            password = "";
        }
        if (type3.getNTResponse() != null) {
            MD4 md4 = new MD4();
            byte[] key = md4.digest(md4.digest(password.getBytes("UnicodeLittleUnmarked")));
            if ((flags & 0x80000) == 0) {
                return key;
            }
            HMACT64 hmac = new HMACT64(key);
            hmac.update(type2.getChallenge());
            hmac.update(type3.getLMResponse(), 0, 8);
            return hmac.digest();
        }
        byte[] lmHash = NtlmAuthentication.lmHash(password);
        int i = 8;
        while (i < 16) {
            lmHash[i] = 0;
            ++i;
        }
        return lmHash;
    }

    private byte[] v2LmSessionKey(int flags, Type2Message type2, Type3Message type3) throws IOException {
        throw new ProviderException("The algorithm for NTLMv2 LanManager session keys is currently unknown.");
    }

    private byte[] v2UserSessionKey(int flags, Type2Message type2, Type3Message type3) throws IOException {
        byte[] response = type3.getNTResponse();
        if (response == null) {
            return new byte[16];
        }
        MD4 md4 = new MD4();
        String password = this.credentials.getPassword();
        if (password == null) {
            password = "";
        }
        HMACT64 hmac = new HMACT64(md4.digest(password.getBytes("UnicodeLittleUnmarked")));
        hmac.update(type3.getUser().toUpperCase().getBytes("UnicodeLittleUnmarked"));
        String domain = type3.getDomain();
        if (domain == null) {
            domain = "";
        }
        hmac = new HMACT64(hmac.digest(domain.toUpperCase().getBytes("UnicodeLittleUnmarked")));
        hmac.update(type2.getChallenge());
        hmac.update(response, 16, response.length - 16);
        return hmac.digest(hmac.digest());
    }

    private static byte[] lmHash(String password) throws IOException {
        byte[] pwd = password.toUpperCase().getBytes(OEM_ENCODING);
        int length = pwd.length;
        if (length > 14) {
            length = 14;
        }
        byte[] hash = new byte[14];
        System.arraycopy(pwd, 0, hash, 0, length);
        pwd = hash;
        hash = new byte[16];
        new DES(DES.createKey((byte[])pwd, (int)0)).process(LM_CONSTANT, 0, 8, hash, 0);
        new DES(DES.createKey((byte[])pwd, (int)7)).process(LM_CONSTANT, 0, 8, hash, 8);
        return hash;
    }
}

