/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessage
extends DefaultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMessage.class);
    private javax.jms.Message jmsMessage;
    private Session jmsSession;
    private JmsBinding binding;

    @Deprecated
    public JmsMessage(javax.jms.Message jmsMessage, JmsBinding binding) {
        this(jmsMessage, null, binding);
    }

    public JmsMessage(javax.jms.Message jmsMessage, Session jmsSession, JmsBinding binding) {
        this.setJmsMessage(jmsMessage);
        this.setJmsSession(jmsSession);
        this.setBinding(binding);
    }

    @Override
    public String toString() {
        if (this.jmsMessage != null) {
            try {
                return "JmsMessage[JmsMessageID: " + this.jmsMessage.getJMSMessageID() + "]";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "JmsMessage@" + ObjectHelper.getIdentityHashCode(this);
    }

    @Override
    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        this.getHeaders().clear();
        boolean copyMessageId = true;
        if (that instanceof JmsMessage) {
            JmsMessage thatMessage = (JmsMessage)that;
            this.jmsMessage = thatMessage.jmsMessage;
            if (this.jmsMessage != null) {
                copyMessageId = false;
            }
        }
        if (copyMessageId) {
            this.setMessageId(that.getMessageId());
        }
        this.setBody(that.getBody());
        this.setFault(that.isFault());
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
        this.getAttachments().clear();
        if (that.hasAttachments()) {
            this.getAttachmentObjects().putAll(that.getAttachmentObjects());
        }
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = ExchangeHelper.getBinding(this.getExchange(), JmsBinding.class);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public javax.jms.Message getJmsMessage() {
        return this.jmsMessage;
    }

    public void setJmsMessage(javax.jms.Message jmsMessage) {
        if (jmsMessage != null) {
            try {
                this.setMessageId(jmsMessage.getJMSMessageID());
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from JMS Message", e);
            }
        }
        this.jmsMessage = jmsMessage;
    }

    public Session getJmsSession() {
        return this.jmsSession;
    }

    public void setJmsSession(Session jmsSession) {
        this.jmsSession = jmsSession;
    }

    @Override
    public void setBody(Object body) {
        super.setBody(body);
        if (body == null) {
            this.ensureInitialHeaders();
            this.jmsMessage = null;
        }
    }

    @Override
    public Object getHeader(String name) {
        this.ensureInitialHeaders();
        return super.getHeader(name);
    }

    @Override
    public Map<String, Object> getHeaders() {
        this.ensureInitialHeaders();
        return super.getHeaders();
    }

    @Override
    public Object removeHeader(String name) {
        this.ensureInitialHeaders();
        return super.removeHeader(name);
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        this.ensureInitialHeaders();
        super.setHeaders(headers);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.ensureInitialHeaders();
        super.setHeader(name, value);
    }

    @Override
    public JmsMessage newInstance() {
        return new JmsMessage(null, null, this.binding);
    }

    public boolean shouldCreateNewMessage() {
        return super.hasPopulatedHeaders();
    }

    protected void ensureInitialHeaders() {
        if (this.jmsMessage != null && !this.hasPopulatedHeaders()) {
            super.setHeaders(this.createHeaders());
        }
    }

    @Override
    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null && map != null) {
            map.putAll(this.getBinding().extractHeadersFromJms(this.jmsMessage, this.getExchange()));
        }
    }

    @Override
    protected String createMessageId() {
        if (this.jmsMessage == null) {
            LOG.trace("No javax.jms.Message set so generating a new message id");
            return super.createMessageId();
        }
        try {
            String id = this.getDestinationAsString(this.jmsMessage.getJMSDestination()) + this.jmsMessage.getJMSMessageID();
            return this.getSanitizedString(id);
        }
        catch (JMSException e) {
            throw new RuntimeExchangeException("Unable to retrieve JMSMessageID from JMS Message", this.getExchange(), e);
        }
    }

    @Override
    protected Boolean isTransactedRedelivered() {
        if (this.jmsMessage != null) {
            return JmsMessageHelper.getJMSRedelivered(this.jmsMessage);
        }
        return null;
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = destination == null ? "null destination!" + File.separator : (destination instanceof Topic ? "topic" + File.separator + ((Topic)destination).getTopicName() + File.separator : "queue" + File.separator + ((Queue)destination).getQueueName() + File.separator);
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

